/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.panels;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.widgets.JLabelComparator;
import com.topcoder.client.contestApplet.widgets.JLabelListCellRenderer;
import com.topcoder.client.contestApplet.widgets.LookupJLabelComboBoxEditor;
import com.topcoder.client.contestApplet.widgets.LookupJLabelTextField;
import com.topcoder.client.contestApplet.widgets.SortedComboBoxModel;
import com.topcoder.client.contestant.view.ChatView;
import com.topcoder.client.contestant.view.UserListListener;
import com.topcoder.netCommon.contestantMessages.response.data.UserListItem;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.Observer;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Element;
import javax.swing.text.Highlighter;
import javax.swing.text.JTextComponent;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyledDocument;

public final class ChatPanel
extends JPanel
implements Observer,
UserListListener,
ChatView {
    private static final Dimension spacing = new Dimension(5, 20);
    private StringBuffer msgBuf = new StringBuffer(100);
    private int currentMode = -1;
    private int currentInputMode = -1;
    private JComboBox msgType = Common.createComboBox();
    private JComboBox toWho = Common.createComboBox();
    private JButton modeSwitcher = new JButton(">>");
    private Box currentBox = null;
    private JPanel boxPanel = new JPanel(new BorderLayout());
    private SortedComboBoxModel userModel = new SortedComboBoxModel(512, new JLabelComparator(false));
    private JPanel currentInputPanel = null;
    private JPanel bottomPanel = new JPanel(new BorderLayout());
    private JPanel inputModePanel = new JPanel(new BorderLayout());
    private JButton chatModeButton = new JButton();
    private JButton findModeButton = new JButton();
    private JPanel findPanel = new JPanel(new BorderLayout());
    private JTextField findInput = new JTextField();
    private JButton findNext = new JButton("Find Next");
    private JButton findPrevious = new JButton("Find Previous");
    private JCheckBox findMatchCase = new JCheckBox("Match Case");
    private JCheckBox findHighlight = new JCheckBox("Highlight");
    private ContestApplet ca = null;
    private MutableAttributeSet mae = new SimpleAttributeSet();
    private MutableAttributeSet smae = new SimpleAttributeSet();
    private MutableAttributeSet umae = new SimpleAttributeSet();
    private MutableAttributeSet amae = new SimpleAttributeSet();
    private MutableAttributeSet moderatedChatAttributes = new SimpleAttributeSet();
    private final JTextPane chatContainer = new TraversableTextPane();
    private LookupJLabelTextField chatInputBox = new LookupJLabelTextField(this.userModel, true);
    private ActionListener ci_al = null;
    private JScrollPane pane;
    private LinkedList chatHistory = new LinkedList();
    private int chatHistoryIndex = -1;
    private static boolean isAdmin = false;
    private int scope;
    private LocalPreferences localPref = LocalPreferences.getInstance();
    private boolean enabled = true;
    private HashSet ignoreList;
    public UserListItem[] itemsToAdd = null;
    private String findString = null;
    private boolean findCaseSensitive = false;
    private boolean findHighlightAll = false;
    private int findIndex = 0;

    public ChatPanel(ContestApplet contestApplet, String string, int n) {
        super(new GridBagLayout());
        this.ca = contestApplet;
        this.localPref.addSaveObserver(this);
        this.createChatPanel(string, 0, 0, Common.BG_COLOR);
        this.ignoreList = LocalPreferences.getInstance().getIgnoreList();
        this.scope = n;
    }

    private void createChatPanel(String string, int n, int n2, Color color) {
        this.setLayout(new BorderLayout());
        this.pane = new JScrollPane(this.chatContainer);
        this.pane.setBackground(color);
        this.pane.setBorder(new EmptyBorder(-1, -1, -1, -1));
        this.chatInputBox.setSelectedTextColor(Common.HF_COLOR);
        this.chatInputBox.setSelectionColor(Common.HB_COLOR);
        this.chatInputBox.setMinimumSize(new Dimension(0, 20));
        this.chatInputBox.setPreferredSize(new Dimension(0, 20));
        this.modeSwitcher.setFont(new Font("SansSerif", 0, 10));
        this.modeSwitcher.setMinimumSize(new Dimension(25, 21));
        this.modeSwitcher.setPreferredSize(new Dimension(25, 21));
        this.modeSwitcher.setMargin(new Insets(-1, -1, -1, -1));
        this.modeSwitcher.addActionListener(new ModeSwitchHandler());
        this.modeSwitcher.setBackground(Common.WPB_COLOR);
        this.modeSwitcher.setForeground(Common.FG_COLOR);
        this.modeSwitcher.setBorder(BorderFactory.createBevelBorder(0, Common.FG_COLOR, Common.WPB_COLOR));
        this.msgType.setFont(new Font("SansSerif", 0, 12));
        this.msgType.setMinimumSize(new Dimension(0, 20));
        this.msgType.setPreferredSize(new Dimension(80, 20));
        this.msgType.setModel(new SortedComboBoxModel());
        this.msgType.addItem("Whisper");
        this.msgType.addItem("Admins");
        this.msgType.addItem("General");
        this.msgType.addItem("Me");
        this.msgType.addItem("Reply To");
        this.msgType.addItem("Question");
        this.msgType.addActionListener(new TypeSwitchHandler());
        this.msgType.setSelectedItem("General");
        this.toWho.setFont(new Font("SansSerif", 0, 12));
        this.toWho.setMinimumSize(new Dimension(0, 20));
        this.toWho.setPreferredSize(new Dimension(120, 20));
        this.toWho.setModel(this.userModel);
        this.toWho.setSelectedItem(new JLabel(""));
        this.toWho.setRenderer(new JLabelListCellRenderer());
        this.toWho.setEditable(true);
        this.toWho.setEditor(new LookupJLabelComboBoxEditor(this.userModel));
        StyleConstants.setForeground(this.moderatedChatAttributes, Color.white);
        this.update(null, null);
        this.chatContainer.setText("");
        this.chatContainer.setEditable(false);
        this.chatContainer.setSelectedTextColor(Common.HF_COLOR);
        this.chatContainer.setSelectionColor(Common.HB_COLOR);
        this.chatContainer.setBackground(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chatpanelback"));
        this.chatContainer.setForeground(Color.green);
        this.chatContainer.addMouseListener(new MouseHandler());
        this.setBorder(Common.getTitledBorder(string));
        this.setPreferredSize(new Dimension(n, n2));
        this.setBackground(color);
        this.setOpaque(false);
        KeyHandler keyHandler = new KeyHandler();
        this.chatContainer.addKeyListener(keyHandler);
        this.chatInputBox.addKeyListener(keyHandler);
        this.ci_al = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatPanel.this.chatinputEvent();
            }
        };
        this.boxPanel.setBackground(Common.BG_COLOR);
        Box box = Box.createHorizontalBox();
        box.add(this.chatModeButton);
        box.add(this.findModeButton);
        this.inputModePanel.add((Component)box, "Center");
        this.inputModePanel.setBackground(Common.BG_COLOR);
        this.chatModeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatPanel.this.setInputMode(0);
            }
        });
        this.findModeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatPanel.this.setInputMode(1);
            }
        });
        this.findMatchCase.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ChatPanel.this.findCaseSensitive = true;
                } else if (itemEvent.getStateChange() == 2) {
                    ChatPanel.this.findCaseSensitive = false;
                }
                ChatPanel.this.find(ChatPanel.this.findInput.getText(), false);
            }
        });
        this.findHighlight.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent itemEvent) {
                if (itemEvent.getStateChange() == 1) {
                    ChatPanel.this.findHighlightAll = true;
                } else if (itemEvent.getStateChange() == 2) {
                    ChatPanel.this.findHighlightAll = false;
                }
                ChatPanel.this.find(ChatPanel.this.findInput.getText(), false);
            }
        });
        this.findNext.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ChatPanel.this.find(ChatPanel.this.findInput.getText());
            }
        });
        this.findInput.addKeyListener(new KeyListener(){
            private String last = "";

            public void keyReleased(KeyEvent keyEvent) {
                String string = ChatPanel.this.findInput.getText();
                if (!string.equals(this.last) || keyEvent.getKeyCode() == 10) {
                    ChatPanel.this.find(string);
                }
                this.last = string;
            }

            public void keyPressed(KeyEvent keyEvent) {
            }

            public void keyTyped(KeyEvent keyEvent) {
            }
        });
        this.applyButtonStyle(this.findNext);
        this.applyButtonStyle(this.findPrevious);
        this.applyCheckBoxStyle(this.findMatchCase, 78);
        this.applyCheckBoxStyle(this.findHighlight, 68);
        this.chatModeButton.setMargin(new Insets(0, 0, 0, 0));
        this.findModeButton.setMargin(new Insets(0, 0, 0, 0));
        this.chatModeButton.setPreferredSize(new Dimension(81, 18));
        this.findModeButton.setPreferredSize(new Dimension(81, 18));
        this.chatModeButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.findModeButton.setBorder(new EmptyBorder(0, 0, 0, 0));
        Box box2 = Box.createHorizontalBox();
        box2.add(this.findInput);
        box2.add(Box.createHorizontalStrut(5));
        box2.add(this.findNext);
        box2.add(Box.createHorizontalStrut(3));
        box2.add(this.findMatchCase);
        box2.add(this.findHighlight);
        this.findPanel.setBackground(Common.BG_COLOR);
        this.findPanel.add((Component)box2, "Center");
        this.add((Component)this.pane, "Center");
        this.add((Component)this.bottomPanel, "South");
        this.setMode(0);
        this.setInputMode(0);
    }

    private void applyButtonStyle(JButton jButton) {
        jButton.setFont(new Font("SansSerif", 0, 10));
        jButton.setMinimumSize(new Dimension(80, 21));
        jButton.setPreferredSize(new Dimension(80, 21));
        jButton.setBackground(Common.WPB_COLOR);
        jButton.setForeground(Common.FG_COLOR);
    }

    private void applyCheckBoxStyle(JCheckBox jCheckBox, int n) {
        jCheckBox.setFont(new Font("SansSerif", 0, 10));
        jCheckBox.setMinimumSize(new Dimension(n, 21));
        jCheckBox.setPreferredSize(new Dimension(n, 21));
        jCheckBox.setMargin(new Insets(0, 0, 0, 0));
        jCheckBox.setBackground(Common.BG_COLOR);
        jCheckBox.setForeground(Common.FG_COLOR);
    }

    public void enter() {
        this.chatInputBox.removeActionListener(this.ci_al);
        this.localPref.removeSaveObserver(this);
        this.localPref.addSaveObserver(this);
        this.chatInputBox.addActionListener(this.ci_al);
        this.setFocus(this.chatInputBox);
        this.update(null, null);
        this.setupTabs();
    }

    public void leave() {
        this.localPref.removeSaveObserver(this);
        this.chatInputBox.removeActionListener(this.ci_al);
        this.setFocus(this.chatContainer);
    }

    public void clear() {
        this.chatContainer.setText("");
        this.chatInputBox.setText("");
        this.userModel.clear();
        this.toWho.setSelectedItem(new JLabel(""));
        this.setFocus(this.chatInputBox);
    }

    private String formatTime(Calendar calendar) {
        String string = "(";
        int n = calendar.get(11);
        int n2 = calendar.get(12);
        int n3 = calendar.get(13);
        string = string + (n < 10 ? "0" : "") + n + ":";
        string = string + (n2 < 10 ? "0" : "") + n2 + ":";
        string = string + (n3 < 10 ? "0" : "") + n3 + ")";
        return string;
    }

    public void updateChat(String string, int n, String string2, int n2) {
        boolean bl = this.isAtLastLine();
        try {
            if (this.ignoreList.contains(string.substring(0, string.length() - 1).trim())) {
                return;
            }
            StyledDocument styledDocument = this.chatContainer.getStyledDocument();
            int n3 = styledDocument.getDefaultRootElement().getElementCount();
            int n4 = styledDocument.getDefaultRootElement().getElement(0).getEndOffset();
            this.umae.addAttribute("com.topcoder.jmaContestApplet.panels.useridentifier", string.substring(0, string.length() - 1));
            this.mae.addAttribute("com.topcoder.jmaContestApplet.panels.useridentifier", string.substring(0, string.length() - 1));
            this.moderatedChatAttributes.addAttribute("com.topcoder.jmaContestApplet.panels.useridentifier", string.substring(0, string.length() - 1));
            String string3 = LocalPreferences.getInstance().getProperty("com.topcoder.jmaContesntApplet.ContestApplet.enableTimestamps");
            if (string3 == null) {
                string3 = "false";
            }
            if (string3.equals("true")) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(new Date(System.currentTimeMillis()));
                string = this.formatTime(gregorianCalendar) + " " + string;
            }
            StyleConstants.setForeground(this.umae, Common.getRankColor(n));
            StyleConstants.setItalic(this.umae, n == -1);
            StyleConstants.setBold(this.umae, n == -1);
            styledDocument.insertString(styledDocument.getLength(), string + " ", this.umae);
            this.updateChat(0, string2, n2, bl);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateChat(int n, String string, int n2) {
        this.updateChat(n, string, n2, this.isAtLastLine());
    }

    private boolean isAtLastLine() {
        JScrollBar jScrollBar = this.pane.getVerticalScrollBar();
        StyledDocument styledDocument = this.chatContainer.getStyledDocument();
        int n = styledDocument.getDefaultRootElement().getElementCount();
        if (n <= 0) {
            return true;
        }
        Element element = styledDocument.getDefaultRootElement().getElement(n - 1);
        Font font = styledDocument.getFont(element.getAttributes());
        return jScrollBar.getValue() + jScrollBar.getVisibleAmount() + this.chatContainer.getFontMetrics(font).getHeight() >= jScrollBar.getMaximum();
    }

    private synchronized void updateChat(int n, String string, int n2, boolean bl) {
        int n3;
        String string2 = LocalPreferences.getInstance().getProperty("com.topcoder.jmaContesntApplet.ContestApplet.enableTimestamps");
        if (string2 == null) {
            string2 = "false";
        }
        String string3 = null;
        switch (n) {
            case 1: 
            case 2: {
                if (!this.ca.isEnterExitMsgsDisabled() || !string.startsWith("System") || !string.endsWith("has entered the room.\n") && !string.endsWith("has left the room.\n") && !string.endsWith("has logged out.\n")) break;
                return;
            }
            case 3: 
            case 6: {
                int n4 = string.indexOf(" whispers to you");
                if (n4 != -1 && this.ignoreList.contains(string.substring(0, n4).trim())) {
                    return;
                }
                if (n4 != -1) {
                    string3 = string.substring(0, n4).trim();
                }
                if (string3 != null) break;
                n4 = string.indexOf(" whispers to admins");
                if (n4 != -1 && this.ignoreList.contains(string.substring(2, n4).trim())) {
                    return;
                }
                if (n4 == -1) break;
                string3 = string.substring(2, n4).trim();
                break;
            }
            case 4: 
            case 5: {
                n3 = string3.indexOf(62);
                if (n3 >= 0) {
                    string3 = string.substring(0, n3);
                }
            }
            case 0: {
                break;
            }
            default: {
                System.err.println("Unknown chat type (" + n + ").");
            }
        }
        try {
            int n5;
            StyledDocument styledDocument = this.chatContainer.getStyledDocument();
            n3 = styledDocument.getDefaultRootElement().getElementCount();
            int n6 = styledDocument.getLength();
            n3 = bl ? (n3 -= 200) : (n3 -= 2000);
            if (n3 > 0) {
                n5 = styledDocument.getDefaultRootElement().getElement(n3 - 1).getEndOffset();
                styledDocument.remove(0, n5);
            }
            n5 = styledDocument.getLength();
            if (n != 0 && string2.equals("true")) {
                GregorianCalendar gregorianCalendar = new GregorianCalendar();
                gregorianCalendar.setTime(new Date(System.currentTimeMillis()));
                string = this.formatTime(gregorianCalendar) + " " + string;
            }
            switch (n) {
                case 0: {
                    this.processUserChat(styledDocument, string);
                    break;
                }
                case 1: {
                    this.processSystemChat(styledDocument, string);
                    break;
                }
                case 6: {
                    this.processWhisperToYou(styledDocument, string, string3);
                    break;
                }
                case 3: {
                    if (string.startsWith("You whisper to")) {
                        this.processWhisper(styledDocument, string);
                        break;
                    }
                    this.processMe(styledDocument, string);
                    break;
                }
                case 2: {
                    this.processEmphSystemChat(styledDocument, string);
                    break;
                }
                case 4: {
                    this.processModeratedChatQuestionChat(styledDocument, string, string3);
                    break;
                }
                case 5: {
                    this.processModeratedChatSpeakerChat(styledDocument, string, string3);
                    break;
                }
                default: {
                    System.err.println("Unknown chat type (" + n + ").");
                    this.processUserChat(styledDocument, string);
                }
            }
            int n7 = n5 - n6;
            this.findIndex += n7;
            if (this.findIndex < 0) {
                this.findIndex = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.find(this.findInput.getText(), false);
        if (bl) {
            this.setCaretPosition();
        }
    }

    private void setCaretPosition() {
        if (!this.ca.isScrollingChatDisabled()) {
            int n = this.chatContainer.getDocument().getLength();
            this.chatContainer.setCaretPosition(n);
        }
    }

    private void processUserChat(StyledDocument styledDocument, String string) throws BadLocationException {
        if (this.isToUs(string)) {
            StyleConstants.setForeground(this.mae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generaltofore"));
            StyleConstants.setBackground(this.mae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generaltoback"));
        } else {
            StyleConstants.setForeground(this.mae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore"));
            StyleConstants.setBackground(this.mae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.generalback"));
        }
        styledDocument.insertString(styledDocument.getLength(), string, this.mae);
    }

    private void processSystemChat(StyledDocument styledDocument, String string) throws BadLocationException {
        StyleConstants.setItalic(this.smae, false);
        StyleConstants.setBold(this.smae, false);
        StyleConstants.setForeground(this.smae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.systemfore"));
        StyleConstants.setBackground(this.smae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.systemback"));
        styledDocument.insertString(styledDocument.getLength(), string, this.smae);
    }

    private void processEmphSystemChat(StyledDocument styledDocument, String string) throws BadLocationException {
        StyleConstants.setItalic(this.smae, true);
        StyleConstants.setBold(this.smae, true);
        StyleConstants.setForeground(this.smae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemfore"));
        StyleConstants.setBackground(this.smae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemback"));
        styledDocument.insertString(styledDocument.getLength(), string, this.smae);
    }

    private void processWhisper(StyledDocument styledDocument, String string) throws BadLocationException {
        this.amae.removeAttribute("com.topcoder.jmaContestApplet.panels.useridentifier");
        this.amae.removeAttribute("com.topcoder.jmaContestApplet.panels.privateidentifier");
        StyleConstants.setForeground(this.amae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whisperfore"));
        StyleConstants.setBackground(this.amae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whisperback"));
        styledDocument.insertString(styledDocument.getLength(), string, this.amae);
    }

    private void processWhisperToYou(StyledDocument styledDocument, String string, String string2) throws BadLocationException {
        if (string2 == null) {
            this.amae.addAttribute("com.topcoder.jmaContestApplet.panels.useridentifier", "admins");
        } else {
            this.amae.addAttribute("com.topcoder.jmaContestApplet.panels.useridentifier", string2);
        }
        this.amae.addAttribute("com.topcoder.jmaContestApplet.panels.privateidentifier", "private");
        StyleConstants.setForeground(this.amae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whispertofore"));
        StyleConstants.setBackground(this.amae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.whispertoback"));
        styledDocument.insertString(styledDocument.getLength(), string, this.amae);
    }

    private void processMe(StyledDocument styledDocument, String string) throws BadLocationException {
        this.amae.removeAttribute("com.topcoder.jmaContestApplet.panels.useridentifier");
        this.amae.removeAttribute("com.topcoder.jmaContestApplet.panels.privateidentifier");
        StyleConstants.setForeground(this.amae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.mefore"));
        StyleConstants.setBackground(this.amae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.meback"));
        styledDocument.insertString(styledDocument.getLength(), string, this.amae);
    }

    private void processModeratedChatQuestionChat(StyledDocument styledDocument, String string, String string2) throws BadLocationException {
        if (string2 != null) {
            this.moderatedChatAttributes.addAttribute("com.topcoder.jmaContestApplet.panels.useridentifier", string2);
        } else {
            this.moderatedChatAttributes.removeAttribute("com.topcoder.jmaContestApplet.panels.useridentifier");
        }
        StyleConstants.setForeground(this.moderatedChatAttributes, this.localPref.getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionFore"));
        StyleConstants.setBackground(this.moderatedChatAttributes, this.localPref.getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionBack"));
        styledDocument.insertString(styledDocument.getLength(), string, this.moderatedChatAttributes);
    }

    private void processModeratedChatSpeakerChat(StyledDocument styledDocument, String string, String string2) throws BadLocationException {
        if (string2 != null) {
            this.moderatedChatAttributes.addAttribute("com.topcoder.jmaContestApplet.panels.useridentifier", string2);
        } else {
            this.moderatedChatAttributes.removeAttribute("com.topcoder.jmaContestApplet.panels.useridentifier");
        }
        StyleConstants.setForeground(this.moderatedChatAttributes, this.localPref.getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerFore"));
        StyleConstants.setBackground(this.moderatedChatAttributes, this.localPref.getColor("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerBack"));
        styledDocument.insertString(styledDocument.getLength(), string, this.moderatedChatAttributes);
    }

    private boolean isToUs(String string) {
        String string2 = string.trim().toLowerCase();
        String string3 = this.ca.getModel().getCurrentUser().toLowerCase() + ":";
        if (string3.equals(":")) {
            return false;
        }
        if (string2.startsWith(string3)) {
            return true;
        }
        return isAdmin && (string2.startsWith("admin:") || string2.startsWith("admins:"));
    }

    void addToUserList(final UserListItem userListItem) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                ChatPanel.this.userModel.addElement(ChatPanel.createLabel(userListItem.getUserName(), userListItem.getUserRating()));
            }
        });
    }

    public void updateUserList(final UserListItem[] userListItemArray) {
        if (this.currentMode == 1) {
            this.itemsToAdd = userListItemArray;
        } else {
            EventQueue.invokeLater(new Runnable(){

                public void run() {
                    ChatPanel.this.userModel.clear();
                    for (int i = userListItemArray.length - 1; i >= 0; --i) {
                        ChatPanel.this.addToUserList(userListItemArray[i]);
                    }
                }
            });
            this.itemsToAdd = null;
        }
    }

    public void update(Observable observable, Object object) {
        this.chatContainer.setBackground(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chatpanelback"));
        StyleConstants.setBackground(this.umae, this.localPref.getColor("com.topcoder.client.contestApplet.panels.ChatPanel.handleback"));
        StyleConstants.setForeground(this.mae, Color.white);
        StyleConstants.setForeground(this.smae, Color.green);
        StyleConstants.setForeground(this.amae, Common.LIGHT_GREY);
        StyleConstants.setItalic(this.amae, true);
        this.chatInputBox.setFont(new Font(this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfont"), 0, this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize")));
        StyleConstants.setFontFamily(this.mae, this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfont"));
        StyleConstants.setFontFamily(this.smae, this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfont"));
        StyleConstants.setFontFamily(this.umae, this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfont"));
        StyleConstants.setFontFamily(this.amae, this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfont"));
        StyleConstants.setFontFamily(this.moderatedChatAttributes, this.localPref.getFont("com.topcoder.client.contestApplet.common.LocalPreferences.chatfont"));
        StyleConstants.setFontSize(this.mae, this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize"));
        StyleConstants.setFontSize(this.smae, this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize"));
        StyleConstants.setFontSize(this.umae, this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize"));
        StyleConstants.setFontSize(this.amae, this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize"));
        StyleConstants.setFontSize(this.moderatedChatAttributes, this.localPref.getFontSize("com.topcoder.client.contestApplet.common.LocalPreferences.chatfontsize"));
        this.setupTabs();
    }

    private void chatinputEvent() {
        boolean bl;
        JLabel jLabel;
        Object object;
        if (!this.enabled) {
            return;
        }
        if (this.itemsToAdd != null) {
            object = this.itemsToAdd;
            EventQueue.invokeLater(new Runnable((UserListItem[])object){
                private final /* synthetic */ UserListItem[] val$items;
                {
                    this.val$items = userListItemArray;
                }

                public void run() {
                    ChatPanel.this.userModel.clear();
                    for (int i = this.val$items.length - 1; i >= 0; --i) {
                        ChatPanel.this.addToUserList(this.val$items[i]);
                    }
                }
            });
            this.itemsToAdd = null;
        }
        if (this.currentMode == 3) {
            return;
        }
        if (this.chatInputBox.getText().length() > 256) {
            Common.showMessage("Error", "You have entered " + this.chatInputBox.getText().length() + " characters. Please limit your message size to 256 characters.", this.ca.getMainFrame());
            this.setFocus(this.chatInputBox);
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                JScrollBar jScrollBar = ChatPanel.this.pane.getVerticalScrollBar();
                jScrollBar.setValue(Math.max(0, jScrollBar.getMaximum() - jScrollBar.getVisibleAmount()));
            }
        });
        object = this.chatInputBox.getText();
        if (((String)object).trim().equals("")) {
            return;
        }
        this.chatHistory.add(object);
        if (this.chatHistory.size() > 20) {
            this.chatHistory.removeFirst();
        }
        this.chatHistoryIndex = -1;
        if (((String)object).startsWith("/ignore ")) {
            if (!this.ignoreList.contains(((String)object).substring(8).trim())) {
                LocalPreferences.getInstance().addToIgnoreList(((String)object).substring(8).trim());
            }
            this.ignoreList.add(((String)object).substring(8).trim());
            this.updateChat(1, "You are currently ignoring " + ((String)object).substring(8) + ".\n", this.scope);
            this.chatInputBox.setText("");
            return;
        }
        if (((String)object).equals("/ignore")) {
            this.updateChat(1, "Usage: \"/ignore <user>\".\n", this.scope);
            this.chatInputBox.setText("");
            return;
        }
        if (((String)object).startsWith("/unignore ")) {
            this.ignoreList.remove(((String)object).substring(10).trim());
            LocalPreferences.getInstance().removeFromIgnoreList(((String)object).substring(10).trim());
            this.updateChat(1, "You are no longer ignoring " + ((String)object).substring(10).trim() + ".\n", this.scope);
            this.chatInputBox.setText("");
            return;
        }
        if (((String)object).equals("/unignore")) {
            this.updateChat(1, "Usage: \"/unignore <user>\".\n", this.scope);
            this.chatInputBox.setText("");
            return;
        }
        if (((String)object).trim().equals("/ignoreclear")) {
            this.ignoreList = new HashSet();
            LocalPreferences.getInstance().clearIgnore();
            this.updateChat(1, "Your ignore list has been cleared.\n", this.scope);
            this.chatInputBox.setText("");
            return;
        }
        if (((String)object).equals("/ignorelist")) {
            Iterator iterator = this.ignoreList.iterator();
            this.updateChat(1, "***You are ignoring the following people***\n", this.scope);
            Object[] objectArray = new String[this.ignoreList.size()];
            int n = 0;
            while (iterator.hasNext()) {
                objectArray[n] = (String)iterator.next();
                ++n;
            }
            Arrays.sort(objectArray);
            for (n = 0; n < objectArray.length; ++n) {
                this.updateChat(1, (String)objectArray[n] + "\n", this.scope);
            }
            this.chatInputBox.setText("");
            return;
        }
        if (((String)object).equals("/help")) {
            this.updateChat(1, "***Valid Commands:***\n", this.scope);
            this.updateChat(1, "  /help\n", this.scope);
            this.updateChat(1, "  /me <msg>\n", this.scope);
            this.updateChat(1, "  /msg <user> <msg>\n", this.scope);
            this.updateChat(1, "  /ignore <user>\n", this.scope);
            this.updateChat(1, "  /unignore <user>\n", this.scope);
            this.updateChat(1, "  /ignoreclear\n", this.scope);
            this.updateChat(1, "  /ignorelist\n", this.scope);
            this.chatInputBox.setText("");
            return;
        }
        if (((String)object).startsWith("/cmd")) {
            if (((String)(object = ((String)object).substring(4).trim())).equals("I am Admin")) {
                isAdmin = true;
                this.updateChat(1, "You have been set to the admin highlighting mode\n", this.scope);
                this.chatInputBox.setText("");
                return;
            }
            if (((String)object).equals("I am NOT Admin")) {
                isAdmin = false;
                this.updateChat(1, "You have been reset to the non-admin highlighting mode\n", this.scope);
                this.chatInputBox.setText("");
                return;
            }
        }
        String string = (jLabel = (JLabel)this.toWho.getSelectedItem()) == null ? "" : jLabel.getText();
        String string2 = (String)this.msgType.getSelectedItem();
        this.msgBuf.setLength(0);
        boolean bl2 = bl = ((String)object).startsWith("/msg ") || ((String)object).startsWith("/me ") || ((String)object).startsWith("admins: ") || ((String)object).startsWith("/moderator ") || ((String)object).indexOf(":") > 0 && ((String)object).substring(0, ((String)object).indexOf(":")).indexOf(" ") < 0 && !((String)object).startsWith("http:");
        if (!bl && this.currentMode == 1) {
            if (string2.equals("Me")) {
                this.msgBuf.append("/me ");
            } else if (string2.equals("Whisper")) {
                if (string.equals("")) {
                    Common.showMessage("Error", "You need to enter who the message is going to", this.ca.getMainFrame());
                    return;
                }
                this.msgBuf.append("/msg ");
                this.msgBuf.append(string);
                this.msgBuf.append(" ");
            } else if (string2.equals("Reply To")) {
                if (string.equals("")) {
                    Common.showMessage("Error", "You need to enter who the message is going to", this.ca.getMainFrame());
                    return;
                }
                this.msgBuf.append(string);
                this.msgBuf.append(": ");
            } else if (string2.equals("Admins")) {
                this.msgBuf.append("admins: ");
            } else if (string2.equals("Question")) {
                this.msgBuf.append("/moderator ");
            }
        }
        this.msgBuf.append((String)object);
        this.msgBuf.append('\n');
        String string3 = this.msgBuf.toString();
        this.chat(string3);
        if (!(this.ca.isAutoEnhancedChatDisabled() || this.currentMode != 0 && this.currentMode != 1)) {
            if (string3.startsWith("/me ")) {
                this.setMode(1);
                this.msgType.setSelectedItem("Me");
            } else if (string3.startsWith("admins: ")) {
                this.setMode(1);
                this.msgType.setSelectedItem("Admins");
            } else if (string3.startsWith("/msg ")) {
                this.setMode(1);
                this.msgType.setSelectedItem("Whisper");
                int n = "/msg ".length();
                int n2 = string3.indexOf(" ", n);
                if (n2 < 0) {
                    n2 = string3.length();
                }
                String string4 = !string.equals("") ? string3.substring(n, n2).trim() : string;
                JLabel jLabel2 = new JLabel(string4);
                jLabel2.setForeground(this.lookupRank(string4));
                this.toWho.setSelectedItem(jLabel2);
            } else if (string3.indexOf(":") > 0) {
                String string5 = string3.substring(0, string3.indexOf(":"));
                if (string5.indexOf(" ") < 0 && !string5.equals("http")) {
                    this.setMode(1);
                    this.msgType.setSelectedItem("Reply To");
                    JLabel jLabel3 = new JLabel(string5);
                    jLabel3.setForeground(this.lookupRank(string5));
                    this.toWho.setSelectedItem(jLabel3);
                }
            } else if (string3.startsWith("/moderator ")) {
                this.setMode(1);
                this.msgType.setSelectedItem("Question");
            } else {
                this.setMode(0);
            }
        }
        this.chatInputBox.setText("");
        this.setFocus(this.chatInputBox);
    }

    private void setupTabs() {
        this.bottomPanel.remove(this.inputModePanel);
        if (!this.ca.isChatFindTabsDisabled()) {
            this.bottomPanel.add((Component)this.inputModePanel, "North");
        } else if (this.currentInputMode != 3) {
            this.setInputMode(0);
        }
    }

    private void setInputMode(int n) {
        JTextComponent jTextComponent;
        if (n == this.currentInputMode) {
            return;
        }
        if (this.currentInputPanel != null) {
            this.bottomPanel.remove(this.currentInputPanel);
        }
        this.remove(this.bottomPanel);
        String string = "chat-off.gif";
        String string2 = "find-off.gif";
        boolean bl = true;
        switch (n) {
            case 3: {
                jTextComponent = this.chatContainer;
                bl = false;
                break;
            }
            case 1: {
                this.currentInputPanel = this.findPanel;
                string2 = "find-on.gif";
                jTextComponent = this.findInput;
                break;
            }
            default: {
                this.currentInputPanel = this.boxPanel;
                string = "chat-on.gif";
                jTextComponent = this.chatInputBox;
            }
        }
        this.chatModeButton.setIcon(Common.getImage(string, this.ca));
        this.findModeButton.setIcon(Common.getImage(string2, this.ca));
        this.bottomPanel.add((Component)this.currentInputPanel, "South");
        if (bl) {
            this.add((Component)this.bottomPanel, "South");
        }
        this.revalidate();
        this.repaint();
        if (jTextComponent != null) {
            this.setFocus(jTextComponent);
        }
    }

    private void setMode(int n) {
        JComponent jComponent;
        if (n == this.currentMode) {
            return;
        }
        if (this.currentBox != null) {
            this.boxPanel.remove(this.currentBox);
        }
        this.currentBox = Box.createHorizontalBox();
        switch (n) {
            case 0: {
                this.modeSwitcher.setText(">>");
                this.currentBox.add(this.modeSwitcher);
                this.currentBox.add(Box.createRigidArea(spacing));
                this.currentBox.add(this.chatInputBox);
                jComponent = this.chatInputBox;
                break;
            }
            case 1: {
                this.modeSwitcher.setText("<<");
                this.currentBox.add(this.modeSwitcher);
                this.currentBox.add(Box.createRigidArea(spacing));
                this.currentBox.add(this.msgType);
                this.currentBox.add(Box.createRigidArea(spacing));
                this.currentBox.add(this.toWho);
                this.currentBox.add(Box.createRigidArea(spacing));
                this.currentBox.add(this.chatInputBox);
                jComponent = this.msgType;
                break;
            }
            case 2: {
                this.currentBox.add(this.chatInputBox);
                jComponent = this.chatInputBox;
                break;
            }
            case 3: {
                jComponent = this.chatContainer;
                break;
            }
            default: {
                jComponent = this.chatContainer;
            }
        }
        this.boxPanel.add((Component)this.currentBox, "South");
        this.boxPanel.revalidate();
        this.boxPanel.repaint();
        this.currentMode = n;
        this.setFocus(jComponent);
    }

    private final void setFocus(Component component) {
        if (component == this.chatContainer) {
            this.chatInputBox.requestFocus();
            component.requestFocus();
        } else {
            this.chatContainer.requestFocus();
            component.requestFocus();
        }
    }

    private final Color lookupRank(String string) {
        for (int i = 0; i < this.userModel.getSize(); ++i) {
            JLabel jLabel = (JLabel)this.userModel.getElementAt(i);
            if (jLabel == null || !jLabel.getText().equals(string)) continue;
            return jLabel.getForeground();
        }
        return Common.FG_COLOR;
    }

    private static final JLabel createLabel(String string, int n) {
        JLabel jLabel = new JLabel(string);
        if (n != Integer.MAX_VALUE) {
            Color color = Common.getRankColor(n);
            jLabel.setForeground(color);
        }
        return jLabel;
    }

    private void removeHighlights() {
        Highlighter highlighter = this.chatContainer.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            Highlighter.Highlight highlight = highlightArray[i];
            if (!(highlight.getPainter() instanceof MyHighlightPainter)) continue;
            highlighter.removeHighlight(highlight);
        }
    }

    private void highlight(int n, int n2) {
        MyHighlightPainter myHighlightPainter = new MyHighlightPainter(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindback"));
        Highlighter highlighter = this.chatContainer.getHighlighter();
        Highlighter.Highlight[] highlightArray = highlighter.getHighlights();
        for (int i = 0; i < highlightArray.length; ++i) {
            Highlighter.Highlight highlight = highlightArray[i];
            if (highlight.getStartOffset() != n) continue;
            highlighter.removeHighlight(highlight);
        }
        try {
            highlighter.addHighlight(n, n + n2, myHighlightPainter);
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    private void highlight(String string, String string2, int n) {
        if (string2 == null || string2.length() < 1) {
            return;
        }
        Highlighter highlighter = this.chatContainer.getHighlighter();
        MyHighlightPainter myHighlightPainter = new MyHighlightPainter(this.localPref.getColor("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindhighlight"));
        while ((n = this.find(string, string2, true, false, n)) >= 0) {
            try {
                highlighter.addHighlight(n, n + string2.length(), myHighlightPainter);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
            ++n;
        }
    }

    private void highlight(String string, int n, boolean bl) {
        String string2 = this.getChatText();
        if (bl) {
            this.removeHighlights();
        }
        if (this.findHighlightAll) {
            this.highlight(string2, string, n);
        }
    }

    private String getChatText() {
        Document document = this.chatContainer.getDocument();
        int n = document.getStartPosition().getOffset();
        int n2 = document.getEndPosition().getOffset();
        int n3 = n2 - n;
        String string = "";
        try {
            string = document.getText(n, n3);
            if (!this.findCaseSensitive) {
                string = string.toLowerCase();
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
        return string;
    }

    private void find(String string) {
        this.find(string, true);
    }

    private void find(String string, boolean bl) {
        this.highlight(string, 0, true);
        if (string == null || string.length() < 1) {
            this.findIndex = 0;
            return;
        }
        boolean bl2 = false;
        if (this.findString != null && string.equals(this.findString)) {
            bl2 = true;
        }
        bl2 = bl2 && bl;
        this.findString = string;
        String string2 = this.getChatText();
        int n = this.findIndex;
        if (bl2) {
            ++n;
        }
        if ((n = this.find(string2, string, true, true, n)) >= 0) {
            this.highlight(n, string.length());
            this.chatContainer.setCaretPosition(n);
            this.findIndex = n;
        } else {
            this.findIndex = 0;
        }
    }

    private int find(String string, String string2, boolean bl, boolean bl2, int n) {
        int n2 = -1;
        if (!this.findCaseSensitive) {
            string2 = string2.toLowerCase();
        }
        if ((n2 = bl ? string.indexOf(string2, n) : string.lastIndexOf(string2, n)) < 0 && bl2) {
            n2 = this.find(string, string2, bl, false, 0);
        }
        return n2;
    }

    private void chat(String string) {
        if (this.ca.isChatEnabled()) {
            this.ca.getModel().getRequester().requestChatMessage(this.ca.getModel().getCurrentRoom().getRoomID(), string, this.scope);
        } else {
            this.updateChat(1, "System> Chat mode is currently disabled. To enable chat mode, unselect \"disable chat\" from the \"options\" menu.\n", this.scope);
        }
    }

    private class TraversableTextPane
    extends JTextPane {
        private TraversableTextPane() {
        }
    }

    private class MyHighlightPainter
    extends DefaultHighlighter.DefaultHighlightPainter {
        public MyHighlightPainter(Color color) {
            super(color);
        }
    }

    private class MouseHandler
    extends MouseAdapter {
        StringBuffer temp = new StringBuffer(20);

        private MouseHandler() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (mouseEvent.getClickCount() == 2 && ChatPanel.this.currentMode != 3) {
                int n = ChatPanel.this.chatContainer.viewToModel(new Point(mouseEvent.getX(), mouseEvent.getY()));
                Element element = ChatPanel.this.chatContainer.getStyledDocument().getCharacterElement(n);
                String string = (String)element.getAttributes().getAttribute("com.topcoder.jmaContestApplet.panels.useridentifier");
                String string2 = (String)element.getAttributes().getAttribute("com.topcoder.jmaContestApplet.panels.privateidentifier");
                if (string != null) {
                    if (ChatPanel.this.ca.isAutoEnhancedChatDisabled()) {
                        this.temp.setLength(0);
                        if (string2 == null || !string2.equals("private")) {
                            this.temp.append(string);
                            this.temp.append(": ");
                        } else {
                            this.temp.append("/msg ");
                            this.temp.append(string);
                            this.temp.append(" ");
                        }
                        ChatPanel.this.chatInputBox.setText(this.temp.toString());
                    } else {
                        ChatPanel.this.setMode(1);
                        if (string2 == null || !string2.equals("private")) {
                            ChatPanel.this.msgType.setSelectedItem("Reply To");
                        } else {
                            ChatPanel.this.msgType.setSelectedItem("Whisper");
                        }
                        JLabel jLabel = new JLabel(string);
                        jLabel.setForeground(ChatPanel.this.lookupRank(string));
                        ChatPanel.this.toWho.setSelectedItem(jLabel);
                    }
                    ChatPanel.this.setInputMode(0);
                    ChatPanel.this.setFocus(ChatPanel.this.chatInputBox);
                }
            }
        }
    }

    private class TypeSwitchHandler
    implements ActionListener {
        private TypeSwitchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = (String)ChatPanel.this.msgType.getSelectedItem();
            if (string.equals("General") || string.equals("Me") || string.equals("Admins")) {
                ChatPanel.this.toWho.setEnabled(false);
                ChatPanel.this.toWho.setSelectedItem(new JLabel(""));
            } else {
                ChatPanel.this.toWho.setEnabled(true);
            }
        }
    }

    private class KeyHandler
    extends KeyAdapter {
        private KeyHandler() {
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (ChatPanel.this.enabled) {
                if (keyEvent.getKeyCode() == 27) {
                    keyEvent.consume();
                    ChatPanel.this.setMode(0);
                    ChatPanel.this.chatInputBox.setText("");
                    ChatPanel.this.chatHistoryIndex = -1;
                }
                if (!ChatPanel.this.ca.isChatHistoryDisabled()) {
                    if (keyEvent.getKeyCode() == 38) {
                        if (ChatPanel.this.chatHistoryIndex < 0) {
                            ChatPanel.this.chatHistoryIndex = ChatPanel.this.chatHistory.size() - 1;
                        } else {
                            ChatPanel.this.chatHistoryIndex--;
                        }
                        if (ChatPanel.this.chatHistoryIndex >= 0 && ChatPanel.this.chatHistoryIndex < ChatPanel.this.chatHistory.size()) {
                            String string = (String)ChatPanel.this.chatHistory.get(ChatPanel.this.chatHistoryIndex);
                            ChatPanel.this.chatInputBox.setText(string);
                        } else {
                            ChatPanel.this.chatInputBox.setText("");
                        }
                    } else if (keyEvent.getKeyCode() == 40) {
                        if (ChatPanel.this.chatHistoryIndex >= ChatPanel.this.chatHistory.size()) {
                            ChatPanel.this.chatHistoryIndex = 0;
                        } else {
                            ChatPanel.this.chatHistoryIndex++;
                        }
                        if (ChatPanel.this.chatHistoryIndex >= 0 && ChatPanel.this.chatHistoryIndex < ChatPanel.this.chatHistory.size()) {
                            String string = (String)ChatPanel.this.chatHistory.get(ChatPanel.this.chatHistoryIndex);
                            ChatPanel.this.chatInputBox.setText(string);
                        } else {
                            ChatPanel.this.chatInputBox.setText("");
                        }
                    }
                }
            }
        }
    }

    private class ModeSwitchHandler
    implements ActionListener {
        private ModeSwitchHandler() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (ChatPanel.this.enabled) {
                if (ChatPanel.this.currentMode == 0) {
                    ChatPanel.this.setMode(1);
                } else {
                    ChatPanel.this.setMode(0);
                }
            }
        }
    }
}

