/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.frames.VotingElement;
import com.topcoder.netCommon.contestantMessages.response.VoteResultsCoder;
import com.topcoder.netCommon.contestantMessages.response.WLMyTeamInfoResponse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class WLMyTeamInfoFrame
extends JFrame {
    private static final Color BACKGROUND = Common.WPB_COLOR;
    private static final Color PANEL_BACKGROUND = Common.PB_COLOR;
    private static final GridBagConstraints GBC = Common.getDefaultConstraints();

    private WLMyTeamInfoFrame(WLMyTeamInfoResponse wLMyTeamInfoResponse) {
        super("Team Info");
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setBackground(BACKGROUND);
        container.setLayout(new GridBagLayout());
        WLMyTeamInfoFrame.GBC.insets = WLMyTeamInfoFrame.beginInsets();
        this.insertInContentPane(this.createPanel(wLMyTeamInfoResponse), 1);
        WLMyTeamInfoFrame.GBC.insets = WLMyTeamInfoFrame.endInsets();
        WLMyTeamInfoFrame.GBC.fill = 0;
        this.insertInContentPane(this.createOkButton(), 2);
        this.pack();
    }

    private JComponent createPanel(WLMyTeamInfoResponse wLMyTeamInfoResponse) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(Common.getTitledBorder("My Team Info:"));
        jPanel.setBackground(BACKGROUND);
        jPanel.setPreferredSize(new Dimension(250, 190));
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createInsidePanel(wLMyTeamInfoResponse));
        return jPanel;
    }

    private Component createInsidePanel(WLMyTeamInfoResponse wLMyTeamInfoResponse) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(PANEL_BACKGROUND);
        jPanel.setLayout(new GridBagLayout());
        WLMyTeamInfoFrame.GBC.anchor = 17;
        WLMyTeamInfoFrame.GBC.fill = 17;
        VoteResultsCoder[] voteResultsCoderArray = wLMyTeamInfoResponse.getCoders();
        for (int i = 0; i < voteResultsCoderArray.length; ++i) {
            boolean bl;
            VoteResultsCoder voteResultsCoder = voteResultsCoderArray[i];
            int n = voteResultsCoder.getRating();
            boolean bl2 = bl = i == voteResultsCoderArray.length - 1;
            if (i == 0) {
                WLMyTeamInfoFrame.GBC.insets = WLMyTeamInfoFrame.beginInsets();
            } else if (bl) {
                WLMyTeamInfoFrame.GBC.insets = WLMyTeamInfoFrame.endInsets();
            } else if (i == 1) {
                WLMyTeamInfoFrame.GBC.insets = WLMyTeamInfoFrame.middleInsets();
            }
            Color color = Common.getRankColor(n);
            double d = voteResultsCoder.getPoints();
            this.addToPanel(jPanel, voteResultsCoder.getHandle(), color, i, d);
        }
        WLMyTeamInfoFrame.GBC.anchor = 11;
        return jPanel;
    }

    private void addToPanel(Container container, String string, Color color, int n, double d) {
        VotingElement votingElement = new VotingElement(string, PANEL_BACKGROUND, color);
        WLMyTeamInfoFrame.insertInPanel(votingElement.getCoderName(), container, 0, n, 1.0);
        WLMyTeamInfoFrame.insertInPanel(WLMyTeamInfoFrame.createLabel("" + d), container, 1, n, 1.0);
    }

    private static JComponent createLabel(String string) {
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setForeground(Common.PT_COLOR);
        return jLabel;
    }

    private JComponent createOkButton() {
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WLMyTeamInfoFrame.this.dispose();
            }
        });
        return jButton;
    }

    private void insertInContentPane(JComponent jComponent, int n) {
        WLMyTeamInfoFrame.insertInPanel(jComponent, this.getContentPane(), n);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n) {
        WLMyTeamInfoFrame.insertInPanel(jComponent, container, 0, n);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n, int n2) {
        WLMyTeamInfoFrame.insertInPanel(jComponent, container, n, n2, 1.0);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n, int n2, double d) {
        Common.insertInPanel(jComponent, container, GBC, n, n2, 1, 1, d, 0.0);
    }

    private static Insets beginInsets() {
        return WLMyTeamInfoFrame.newInsets(15, 5);
    }

    private static Insets middleInsets() {
        return WLMyTeamInfoFrame.newInsets(5, 5);
    }

    private static Insets endInsets() {
        return WLMyTeamInfoFrame.newInsets(5, 15);
    }

    private static Insets newInsets(int n, int n2) {
        return new Insets(n, 15, n2, 15);
    }

    public static void showFrame(JFrame jFrame, WLMyTeamInfoResponse wLMyTeamInfoResponse) {
        WLMyTeamInfoFrame wLMyTeamInfoFrame = new WLMyTeamInfoFrame(wLMyTeamInfoResponse);
        if (jFrame != null) {
            Common.setLocationRelativeTo((Component)jFrame, wLMyTeamInfoFrame);
        }
        wLMyTeamInfoFrame.show();
    }
}

