/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.frames.VotingElement;
import com.topcoder.netCommon.contestantMessages.response.VoteResultsCoder;
import com.topcoder.netCommon.contestantMessages.response.VoteResultsResponse;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public final class VotingResultsFrame
extends JFrame {
    private static final Color BACKGROUND = Common.WPB_COLOR;
    private static final Color PANEL_BACKGROUND = Common.PB_COLOR;
    private static final GridBagConstraints GBC = Common.getDefaultConstraints();

    private VotingResultsFrame(VoteResultsResponse voteResultsResponse) {
        super("Voting Results");
        this.setDefaultCloseOperation(2);
        Container container = this.getContentPane();
        container.setBackground(BACKGROUND);
        container.setLayout(new GridBagLayout());
        VotingResultsFrame.GBC.insets = VotingResultsFrame.beginInsets();
        this.insertInContentPane(VotingResultsFrame.createLabel("Elimination Round: " + voteResultsResponse.getRoundName()), 0);
        VotingResultsFrame.GBC.insets = VotingResultsFrame.middleInsets();
        this.insertInContentPane(this.createPanel(voteResultsResponse), 1);
        VotingResultsFrame.GBC.insets = VotingResultsFrame.endInsets();
        VotingResultsFrame.GBC.fill = 0;
        this.insertInContentPane(this.createOkButton(), 2);
        this.pack();
    }

    private JComponent createPanel(VoteResultsResponse voteResultsResponse) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(Common.getTitledBorder("Results Of The Vote:"));
        jPanel.setBackground(BACKGROUND);
        jPanel.setPreferredSize(new Dimension(250, 190));
        jPanel.setLayout(new BorderLayout());
        jPanel.add(this.createInsidePanel(voteResultsResponse));
        return jPanel;
    }

    private Component createInsidePanel(VoteResultsResponse voteResultsResponse) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(PANEL_BACKGROUND);
        jPanel.setLayout(new GridBagLayout());
        VotingResultsFrame.GBC.anchor = 17;
        VotingResultsFrame.GBC.fill = 17;
        VoteResultsCoder[] voteResultsCoderArray = voteResultsResponse.getCoders();
        for (int i = 0; i < voteResultsCoderArray.length; ++i) {
            boolean bl;
            VoteResultsCoder voteResultsCoder = voteResultsCoderArray[i];
            int n = voteResultsCoder.getRating();
            boolean bl2 = bl = i == voteResultsCoderArray.length - 1;
            if (i == 0) {
                VotingResultsFrame.GBC.insets = VotingResultsFrame.beginInsets();
            } else if (bl) {
                VotingResultsFrame.GBC.insets = VotingResultsFrame.endInsets();
            } else if (i == 1) {
                VotingResultsFrame.GBC.insets = VotingResultsFrame.middleInsets();
            }
            Color color = Common.getRankColor(n);
            String string = voteResultsCoder.isTieBreakVictim() ? voteResultsCoder.getVotes() - 1 + "+1" : "" + voteResultsCoder.getVotes();
            this.addToPanel(jPanel, voteResultsCoder.getHandle(), color, i, string);
        }
        VotingResultsFrame.GBC.anchor = 11;
        return jPanel;
    }

    private void addToPanel(Container container, String string, Color color, int n, String string2) {
        VotingElement votingElement = new VotingElement(string, PANEL_BACKGROUND, color);
        VotingResultsFrame.insertInPanel(votingElement.getCoderName(), container, 0, n, 1.0);
        VotingResultsFrame.insertInPanel(VotingResultsFrame.createLabel(string2), container, 1, n, 1.0);
    }

    private JComponent createOkButton() {
        JButton jButton = new JButton("Ok");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                VotingResultsFrame.this.dispose();
            }
        });
        return jButton;
    }

    private static Insets middleInsets() {
        return VotingResultsFrame.newInsets(5, 5);
    }

    private static Insets endInsets() {
        return VotingResultsFrame.newInsets(5, 15);
    }

    private void insertInContentPane(JComponent jComponent, int n) {
        VotingResultsFrame.insertInPanel(jComponent, this.getContentPane(), n);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n) {
        VotingResultsFrame.insertInPanel(jComponent, container, 0, n);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n, int n2) {
        VotingResultsFrame.insertInPanel(jComponent, container, n, n2, 1.0);
    }

    private static void insertInPanel(JComponent jComponent, Container container, int n, int n2, double d) {
        Common.insertInPanel(jComponent, container, GBC, n, n2, 1, 1, d, 0.0);
    }

    private static JComponent createLabel(String string) {
        JLabel jLabel = new JLabel(string, 0);
        jLabel.setForeground(Common.PT_COLOR);
        return jLabel;
    }

    private static Insets beginInsets() {
        return VotingResultsFrame.newInsets(15, 5);
    }

    private static Insets newInsets(int n, int n2) {
        return new Insets(n, 15, n2, 15);
    }

    public static void showFrame(ContestApplet contestApplet, VoteResultsResponse voteResultsResponse) {
        VotingResultsFrame votingResultsFrame = new VotingResultsFrame(voteResultsResponse);
        if (contestApplet != null) {
            Common.setLocationRelativeTo((Component)contestApplet.getCurrentFrame(), votingResultsFrame);
        }
        votingResultsFrame.show();
    }
}

