/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.panels.coding.CodingTimerPanel;
import com.topcoder.client.contestApplet.panels.table.TeamListTablePanel;
import com.topcoder.client.contestApplet.panels.table.UserMapTablePanel;
import com.topcoder.client.contestApplet.widgets.MouseLessTextArea;
import com.topcoder.client.contestant.view.TeamListView;
import com.topcoder.client.contestant.view.UserListListener;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TeamManagerFrame
extends JFrame {
    private ContestApplet contestApplet = null;
    private boolean once = true;
    private int userType;
    private TeamListTablePanel tltpTeams = null;
    private CodingTimerPanel ctpTime = null;
    private UserMapTablePanel utpAvailable = null;
    private UserMapTablePanel utpMembers = null;
    private JButton btnAdd = null;
    private JButton btnRemove = null;
    private JButton btnJoin = null;
    private JButton btnLeave = null;
    private MouseLessTextArea msg = null;

    public TeamManagerFrame(ContestApplet contestApplet, int n) {
        super("TopCoder Competition Arena - Team Management");
        this.contestApplet = contestApplet;
        this.create();
        this.setUserType(n);
        this.setSize(600, 400);
    }

    public void setUserType(int n) {
        this.userType = n;
        if (this.userType == 2) {
            this.btnAdd.setVisible(true);
            this.btnRemove.setVisible(true);
            this.btnJoin.setVisible(false);
            this.btnLeave.setVisible(false);
            this.msg.setText("During registration, you can edit your team.  The 'Available' list will show members who wish to be added to your team.  The 'Members' list will show members currently selected for your team.  You can view the members on any team by selecting the team from the team list.");
        } else {
            this.btnAdd.setVisible(false);
            this.btnRemove.setVisible(false);
            this.btnJoin.setVisible(true);
            this.btnLeave.setVisible(true);
            this.msg.setText("During registration, you can join any team to make a request to be added.  You may leave a team at any time during registration.");
        }
    }

    public void show() {
        super.show();
    }

    public void hide() {
        super.hide();
    }

    public void create() {
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.msg = new MouseLessTextArea("");
        CodingTimerPanel codingTimerPanel = new CodingTimerPanel(this.contestApplet);
        JPanel jPanel = Common.createMessagePanel("Instructions", this.msg, 0, 100, Common.BG_COLOR);
        JPanel jPanel2 = this.createTeamsPanel();
        JPanel jPanel3 = this.createMemberSelectionPanel();
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.WPB_COLOR);
        jPanel2.setPreferredSize(new Dimension(350, 200));
        gridBagConstraints.insets = new Insets(25, 5, 5, 15);
        gridBagConstraints.fill = 0;
        Common.insertInPanel(codingTimerPanel, this.getContentPane(), gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        gridBagConstraints.insets = new Insets(0, 5, 0, 15);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(jPanel, this.getContentPane(), gridBagConstraints, 0, 0, 1, 2, 1.0, 0.0);
        gridBagConstraints.insets = new Insets(5, 15, 5, 15);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(jPanel2, this.getContentPane(), gridBagConstraints, 0, 2, 2, 1, 1.0, 1.0);
        gridBagConstraints.insets = new Insets(5, 15, 15, 15);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(jPanel3, this.getContentPane(), gridBagConstraints, 0, 3, 2, 1, 1.0, 1.0);
        this.ctpTime = codingTimerPanel;
    }

    private JPanel createTeamsPanel() {
        JPanel jPanel = new JPanel(new BorderLayout());
        this.tltpTeams = new TeamListTablePanel(this.contestApplet);
        jPanel.add((Component)this.tltpTeams, "Center");
        this.tltpTeams.getTable().getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                System.out.println("valueChanged");
                TeamManagerFrame.this.utpAvailable.setTeam(TeamManagerFrame.this.tltpTeams.getSelectedTeam());
                TeamManagerFrame.this.utpMembers.setTeam(TeamManagerFrame.this.tltpTeams.getSelectedTeam());
            }
        });
        JPanel jPanel2 = new JPanel(new FlowLayout(2));
        this.btnJoin = Common.getButton("Join");
        this.btnJoin.setMinimumSize(new Dimension(75, 25));
        this.btnJoin.setPreferredSize(new Dimension(75, 25));
        this.btnJoin.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TeamManagerFrame.this.joinButtonEvent();
            }
        });
        this.btnLeave = Common.getButton("Leave");
        this.btnLeave.setMinimumSize(new Dimension(75, 25));
        this.btnLeave.setPreferredSize(new Dimension(75, 25));
        this.btnLeave.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TeamManagerFrame.this.leaveButtonEvent();
            }
        });
        jPanel2.add(this.btnJoin);
        jPanel2.add(this.btnLeave);
        jPanel.add((Component)jPanel2, "South");
        return jPanel;
    }

    private JPanel createMemberSelectionPanel() {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel = new JPanel(new GridBagLayout());
        this.utpAvailable = new UserMapTablePanel(this.contestApplet, "Avaiable");
        this.utpMembers = new UserMapTablePanel(this.contestApplet, "Team Members");
        this.utpAvailable.setMinimumSize(new Dimension(160, 0));
        this.utpAvailable.setPreferredSize(new Dimension(200, 200));
        this.utpMembers.setMinimumSize(new Dimension(160, 0));
        this.utpMembers.setPreferredSize(new Dimension(200, 200));
        this.utpAvailable.setBackground(Common.WPB_COLOR);
        this.utpMembers.setBackground(Common.WPB_COLOR);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(this.utpAvailable, jPanel, gridBagConstraints, 0, 0, 1, 1, 1.0, 1.0);
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(this.utpMembers, jPanel, gridBagConstraints, 2, 0, 1, 1, 1.0, 1.0);
        BorderLayout borderLayout = new BorderLayout();
        borderLayout.setVgap(5);
        JPanel jPanel2 = new JPanel(borderLayout);
        this.btnAdd = Common.getButton("Add >>");
        this.btnAdd.setToolTipText("Add avaiable member to your team");
        this.btnAdd.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TeamManagerFrame.this.addButtonEvent();
            }
        });
        this.btnAdd.setMnemonic(65);
        this.btnRemove = Common.getButton("<< Remove");
        this.btnRemove.setToolTipText("Remove member from your team");
        this.btnRemove.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                TeamManagerFrame.this.removeButtonEvent();
            }
        });
        this.btnRemove.setMnemonic(82);
        jPanel2.add((Component)this.btnAdd, "North");
        jPanel2.add((Component)this.btnRemove, "South");
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        gridBagConstraints.fill = 0;
        Common.insertInPanel(jPanel2, jPanel, gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
        return jPanel;
    }

    private void addButtonEvent() {
        this.contestApplet.getModel().getRequester().requestAddTeamMember(this.utpAvailable.getSelectedUserHandle());
    }

    private void removeButtonEvent() {
        this.contestApplet.getModel().getRequester().requestRemoveTeamMember(this.utpMembers.getSelectedUserHandle());
    }

    private void joinButtonEvent() {
        this.contestApplet.getModel().getRequester().requestJoinTeam(this.tltpTeams.getSelectedTeam());
    }

    private void leaveButtonEvent() {
        this.contestApplet.getModel().getRequester().requestLeaveTeam(this.tltpTeams.getSelectedTeam());
    }

    public TeamListView getTeamListView() {
        return this.tltpTeams;
    }

    public UserListListener getAvailableListView() {
        return this.utpAvailable;
    }

    public UserListListener getMemberListView() {
        return this.utpMembers;
    }
}

