/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.frames;

import com.topcoder.client.contestApplet.ContestApplet;
import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.CommonData;
import com.topcoder.client.contestApplet.panels.ContestSponsorPanel;
import com.topcoder.client.contestApplet.panels.SoftwareLogoPanel;
import com.topcoder.client.contestApplet.panels.TopCoderLogoPanel;
import com.topcoder.client.contestApplet.panels.main.MainMenuPanel;
import com.topcoder.client.contestApplet.panels.main.MainStatusPanel;
import com.topcoder.client.contestant.RoomModel;
import com.topcoder.client.contestant.view.RoomViewManager;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BoxLayout;
import javax.swing.JFrame;
import javax.swing.JPanel;

public final class MainFrame
extends JFrame {
    protected ContestApplet ca = null;
    protected JPanel mainPanel = null;
    protected JPanel navPanel = new JPanel();
    protected MainMenuPanel menuPanel = null;
    protected MainStatusPanel statusPanel = null;
    protected TopCoderLogoPanel topcoderlogoPanel = null;
    private ContestSponsorPanel sponsorPanel;

    public MainFrame(ContestApplet contestApplet) {
        super("TopCoder");
        this.ca = contestApplet;
        this.create();
    }

    public void setMenuEnabled(boolean bl) {
        this.menuPanel.setMenuEnabled(bl);
    }

    private void create() {
        Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
        this.init();
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                MainFrame.this.ca.mainFrameEvent();
            }

            public void windowClosed(WindowEvent windowEvent) {
                MainFrame.this.ca.mainFrameEvent();
            }
        });
        this.setBackground(Common.BG_COLOR);
        this.getContentPane().add(this.ca);
        this.setDefaultCloseOperation(2);
        this.pack();
        this.setLocation(dimension.width / 2 - this.getWidth() / 2, dimension.height / 2 - this.getHeight() / 2);
    }

    public void init() {
        JPanel jPanel;
        JPanel jPanel2;
        GridBagConstraints gridBagConstraints = Common.getDefaultConstraints();
        this.getRootPane().setMinimumSize(new Dimension(795, 570));
        this.getRootPane().setPreferredSize(new Dimension(795, 570));
        this.getContentPane().setLayout(new GridBagLayout());
        this.getContentPane().setBackground(Common.BG_COLOR);
        this.mainPanel = new JPanel();
        JPanel jPanel3 = new JPanel(new GridBagLayout());
        JPanel jPanel4 = new JPanel(new GridBagLayout());
        MainMenuPanel mainMenuPanel = new MainMenuPanel(this.ca);
        TopCoderLogoPanel topCoderLogoPanel = new TopCoderLogoPanel(this.ca);
        SoftwareLogoPanel softwareLogoPanel = new SoftwareLogoPanel(this.ca);
        jPanel3.setBackground(Common.TOP_BACK);
        jPanel4.setBackground(Common.BG_COLOR);
        jPanel4.setRequestFocusEnabled(false);
        this.mainPanel.setLayout(new BoxLayout(this.mainPanel, 0));
        this.mainPanel.setBackground(Common.BG_COLOR);
        this.mainPanel.setRequestFocusEnabled(false);
        jPanel3.setVisible(false);
        String string = this.ca.getCompanyName();
        boolean bl = this.ca.getPoweredByView();
        this.sponsorPanel = new ContestSponsorPanel(this.ca, CommonData.getSponsorLobbyImageAddr(string, null));
        this.ca.getModel().getRoomViewManagerManager().addListener(new RoomViewManager(){

            public void setCurrentRoom(RoomModel roomModel) {
                MainFrame.this.sponsorPanel.updateURL(CommonData.getSponsorLobbyImageAddr(MainFrame.this.ca.getSponsorName(), roomModel));
            }

            public void removeRoom(RoomModel roomModel) {
            }

            public void clearRooms() {
            }

            public void addRoom(RoomModel roomModel) {
            }
        });
        if (bl) {
            jPanel2 = this.sponsorPanel;
            jPanel = topCoderLogoPanel;
        } else {
            jPanel2 = topCoderLogoPanel;
            jPanel = this.sponsorPanel;
        }
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 12;
        Common.insertInPanel(jPanel2, jPanel3, gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        if (string.equals("TopCoder")) {
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 12;
            Common.insertInPanel(softwareLogoPanel, jPanel3, gridBagConstraints, 1, 0, 1, 1, 0.0, 0.0);
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            gridBagConstraints.anchor = 12;
        }
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 12;
        Common.insertInPanel(jPanel, jPanel3, gridBagConstraints, 3, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        Common.insertInPanel(mainMenuPanel, jPanel3, gridBagConstraints, 0, 1, 4, 1, 0.1, 0.1);
        Common.insertInPanel(jPanel3, jPanel4, gridBagConstraints, 0, 0, 1, 1, 0.1, 0.1);
        gridBagConstraints.fill = 1;
        Common.insertInPanel(jPanel4, this.getContentPane(), gridBagConstraints, 0, 0, 1, 1, 0.0, 0.0);
        Common.insertInPanel(this.mainPanel, this.getContentPane(), gridBagConstraints, 0, 1, 1, 1, 1.0, 1.0);
        this.navPanel = jPanel3;
        this.menuPanel = mainMenuPanel;
    }

    public void leave() {
    }

    public JPanel getMainPanel() {
        return this.mainPanel;
    }

    public JPanel getNavPanel() {
        return this.navPanel;
    }

    public MainMenuPanel getMenuPanel() {
        return this.menuPanel;
    }

    public ContestApplet getContestApplet() {
        return this.ca;
    }
}

