/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.editors.setup;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.DynamicEditor;
import com.topcoder.client.contestApplet.editors.EditorPlugin;
import com.topcoder.client.contestApplet.editors.PluginManager;
import com.topcoder.client.contestApplet.editors.setup.AddDialog;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.table.AbstractTableModel;

public class EditorPreferencesTableModel
extends AbstractTableModel {
    private ArrayList plugins;
    private static Class[] columnClass = new Class[]{class$java$lang$Boolean == null ? (class$java$lang$Boolean = EditorPreferencesTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$Boolean == null ? (class$java$lang$Boolean = EditorPreferencesTableModel.class$("java.lang.Boolean")) : class$java$lang$Boolean, class$java$lang$String == null ? (class$java$lang$String = EditorPreferencesTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EditorPreferencesTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EditorPreferencesTableModel.class$("java.lang.String")) : class$java$lang$String, class$java$lang$String == null ? (class$java$lang$String = EditorPreferencesTableModel.class$("java.lang.String")) : class$java$lang$String};
    private static String[] columnName = new String[]{"Default", "At Startup", "Type", "Name", "EntryPoint", "ClassPath"};
    private static boolean[] columnEditable = new boolean[]{true, true, false, false, false, true};
    private boolean pending = false;
    private JFrame parent = null;
    private JLabel defaultLabel = null;
    private String defaultEditorName = "";
    public static int SAVESUCCESS = 0;
    public static int SAVEEXCEPTION = -1;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$String;

    public EditorPreferencesTableModel(JFrame jFrame) {
        this.parent = jFrame;
        this.defaultEditorName = new String(LocalPreferences.getInstance().getDefaultEditorName());
        this.plugins = new ArrayList<EditorPlugin>(Arrays.asList(PluginManager.getInstance().getEditorPlugins()));
        Collections.sort(this.plugins, new Comparator(){

            public int compare(Object object, Object object2) {
                EditorPlugin editorPlugin = (EditorPlugin)object;
                EditorPlugin editorPlugin2 = (EditorPlugin)object2;
                if (editorPlugin.getType() == editorPlugin2.getType()) {
                    return editorPlugin.getName().compareToIgnoreCase(editorPlugin2.getName());
                }
                return editorPlugin.getType() == EditorPlugin.STANDARD ? -1 : 1;
            }
        });
        this.pending = false;
    }

    public boolean isCellEditable(int n, int n2) {
        if (((EditorPlugin)this.plugins.get(n)).getType() == EditorPlugin.STANDARD && n2 > 0) {
            return false;
        }
        return columnEditable[n2];
    }

    public int getRowCount() {
        return this.plugins.size();
    }

    public int getColumnCount() {
        return columnName.length;
    }

    public Class getColumnClass(int n) {
        return columnClass[n];
    }

    public String getColumnName(int n) {
        return columnName[n];
    }

    public Object getValueAt(int n, int n2) {
        EditorPlugin editorPlugin = (EditorPlugin)this.plugins.get(n);
        if (n2 == 0) {
            return this.defaultEditorName.equals(editorPlugin.getName()) && !this.defaultEditorName.equals("") ? Boolean.TRUE : Boolean.FALSE;
        }
        switch (n2) {
            case 1: {
                return editorPlugin.getEager() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 2: {
                return editorPlugin.getType() == EditorPlugin.STANDARD ? "Standard" : "Local";
            }
            case 3: {
                return editorPlugin.getName();
            }
            case 4: {
                return editorPlugin.getEntryPoint();
            }
            case 5: {
                return editorPlugin.getClassPath();
            }
        }
        return null;
    }

    public void setValueAt(Object object, int n, int n2) {
        this.pending = true;
        EditorPlugin editorPlugin = (EditorPlugin)this.plugins.get(n);
        if (editorPlugin.getType() == EditorPlugin.STANDARD && n2 > 0) {
            return;
        }
        switch (n2) {
            case 0: {
                this.defaultEditorName = editorPlugin.getName();
                this.fireTableDataChanged();
                break;
            }
            case 1: {
                editorPlugin.setEager((Boolean)object);
                break;
            }
            case 2: {
                return;
            }
            case 3: {
                editorPlugin.setName((String)object);
                break;
            }
            case 4: {
                editorPlugin.setEntryPoint((String)object);
                break;
            }
            case 5: {
                editorPlugin.setClassPath((String)object);
            }
        }
    }

    public void deleteRow(int n) {
        if (n < 0) {
            Common.showMessage("Cannot Delete", "Please select the editor plugin to delete", this.parent);
            return;
        }
        EditorPlugin editorPlugin = (EditorPlugin)this.plugins.get(n);
        if (editorPlugin.getType() != EditorPlugin.LOCAL) {
            Common.showMessage("Cannot Delete", "You cannot delete a standard plugin", this.parent);
            return;
        }
        if (!(editorPlugin.getName().equals("") && editorPlugin.getEntryPoint().equals("") || Common.confirm("Delete", "Are you sure you wish to delete the " + editorPlugin.getName() + " editor plugin", this.parent))) {
            return;
        }
        this.pending = true;
        this.plugins.remove(n);
        if (this.defaultEditorName.equals(editorPlugin.getName())) {
            this.defaultEditorName = "";
        }
        this.fireTableRowsDeleted(n, n);
    }

    public int addRow() {
        EditorPlugin editorPlugin = new EditorPlugin("", "", "");
        new AddDialog(this.parent, editorPlugin, this.plugins);
        if (editorPlugin.getName().equals("")) {
            return -1;
        }
        this.pending = true;
        this.plugins.add(editorPlugin);
        this.fireTableRowsInserted(this.plugins.size() - 1, this.plugins.size() - 1);
        return this.plugins.size() - 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(int n) {
        if (n < 0) {
            Common.showMessage("Cannot Configure", "Please select the editor plugin to configure", this.parent);
            return;
        }
        EditorPlugin editorPlugin = (EditorPlugin)this.plugins.get(n);
        DynamicEditor dynamicEditor = null;
        try {
            dynamicEditor = PluginManager.getInstance().createEditor(editorPlugin);
            if (!dynamicEditor.configure()) {
                Common.showMessage("Configure", "No configuration available for this editor", this.parent);
            }
        }
        catch (InstantiationError instantiationError) {
            Common.showMessage("Instantiation Error", "Could not instantiate the editor " + editorPlugin.getName() + " (see the java console for details).", this.parent);
            return;
        }
        catch (NoSuchMethodError noSuchMethodError) {
            Common.showMessage("Editor Plugin Error", "The editor " + editorPlugin.getName() + " does not implement the required methods for an editor plugin.", this.parent);
            return;
        }
        finally {
            if (dynamicEditor != null) {
                dynamicEditor.dispose();
            }
        }
    }

    public int save() {
        for (int i = this.plugins.size() - 1; i >= 0; --i) {
            EditorPlugin editorPlugin = (EditorPlugin)this.plugins.get(i);
            if (editorPlugin.getType() != EditorPlugin.LOCAL || editorPlugin.getName().equals("") && editorPlugin.getEntryPoint().equals("") && editorPlugin.getClassPath().equals("")) continue;
            if (editorPlugin.getName().equals("")) {
                JOptionPane.showMessageDialog(this.parent, "You must specify the plugin name", "Validation Error", 0);
                return i;
            }
            if (!editorPlugin.getEntryPoint().equals("")) continue;
            JOptionPane.showMessageDialog(this.parent, "You must specify the entry point class for the plugin", "Validation Error", 0);
            return i;
        }
        LocalPreferences localPreferences = LocalPreferences.getInstance();
        localPreferences.setDefaultEditorName(this.defaultEditorName);
        try {
            PluginManager.getInstance().setEditorPlugins(this.plugins.toArray(new EditorPlugin[0]));
            this.pending = false;
            Common.showMessage("Save", "Local plugins were saved successfully", this.parent);
            return SAVESUCCESS;
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.parent, iOException.toString(), "Error saving preferences", 0);
            try {
                localPreferences.reload();
            }
            catch (IOException iOException2) {
                // empty catch block
            }
            return SAVEEXCEPTION;
        }
    }

    public boolean savePending() {
        return this.pending;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

