/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.editors.setup;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.editors.DynamicEditor;
import com.topcoder.client.contestApplet.editors.EditorPlugin;
import com.topcoder.client.contestApplet.editors.PluginManager;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JTextField;

public class AddDialog
implements ActionListener {
    private JFrame parent;
    private JDialog dial;
    private EditorPlugin target;
    private List existing;
    private JTextField name = AddDialog.createTextField(25);
    private JTextField entryPoint = AddDialog.createTextField(25);
    private JTextField classPath = AddDialog.createTextField(25);
    private JLabel nameLabel = AddDialog.createLabel("Name:");
    private JLabel entryPointLabel = AddDialog.createLabel("EntryPoint:");
    private JLabel classPathLabel = AddDialog.createLabel("ClassPath:");
    private JButton browse = AddDialog.createButton("Browse");
    private JButton okay = AddDialog.createButton("OK");
    private JButton cancel = AddDialog.createButton("Cancel");

    public AddDialog(JFrame jFrame, EditorPlugin editorPlugin, List list) {
        this.target = editorPlugin;
        this.parent = jFrame;
        this.existing = list;
        this.dial = new JDialog(jFrame, "Enter Plugin Information", true);
        Common.setLocationRelativeTo((Component)jFrame, this.dial);
        Container container = this.dial.getContentPane();
        container.setBackground(Common.WPB_COLOR);
        this.browse.setMaximumSize(new Dimension(100, 21));
        this.browse.addActionListener(this);
        this.okay.addActionListener(this);
        this.cancel.addActionListener(this);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.okay);
        box.add(Box.createHorizontalStrut(5));
        box.add(this.cancel);
        box.add(Box.createHorizontalStrut(5));
        Box box2 = Box.createVerticalBox();
        box2.add(Box.createVerticalStrut(15));
        box2.add(AddDialog.createHorizontalBox(this.nameLabel, this.name, null));
        box2.add(Box.createVerticalStrut(5));
        box2.add(AddDialog.createHorizontalBox(this.entryPointLabel, this.entryPoint, null));
        box2.add(Box.createVerticalStrut(5));
        box2.add(AddDialog.createHorizontalBox(this.classPathLabel, this.classPath, this.browse));
        box2.add(Box.createVerticalStrut(15));
        box2.add(Box.createVerticalGlue());
        box2.add(box);
        box2.add(Box.createVerticalStrut(15));
        Box box3 = Box.createHorizontalBox();
        box3.add(Box.createHorizontalStrut(15));
        box3.add(box2);
        box3.add(Box.createHorizontalStrut(15));
        this.dial.getContentPane().add(box3);
        this.dial.setResizable(false);
        this.dial.setSize(new Dimension(503, 180));
        this.dial.pack();
        this.dial.setVisible(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void actionPerformed(ActionEvent actionEvent) {
        Object object = actionEvent.getSource();
        if (object == this.okay) {
            if (this.name.getText().equals("")) {
                Common.showMessage("Error", "Please provide a plugin name", this.parent);
                return;
            }
            if (this.entryPoint.getText().equals("")) {
                Common.showMessage("Error", "Please provide a entry point", this.parent);
                return;
            }
            if (this.doesNameExist(this.name.getText())) {
                Common.showMessage("Error", "The plugin name already exists - choose another", this.parent);
                return;
            }
            this.target.setName(this.name.getText());
            this.target.setEntryPoint(this.entryPoint.getText());
            this.target.setClassPath(this.classPath.getText());
            DynamicEditor dynamicEditor = null;
            try {
                dynamicEditor = PluginManager.getInstance().createEditor(this.target);
            }
            catch (InstantiationError instantiationError) {
                Common.showMessage("Instantiation Error", "Could not instantiate the plugin (see the java console for details).", this.parent);
                return;
            }
            catch (NoSuchMethodError noSuchMethodError) {
                Common.showMessage("Editor Plugin Error", "The plugin does not implement the required methods for an editor plugin.", this.parent);
                return;
            }
            finally {
                if (dynamicEditor != null) {
                    dynamicEditor.dispose();
                }
            }
            this.dial.dispose();
        } else if (object == this.cancel) {
            this.target.setName("");
            this.dial.dispose();
        } else if (object == this.browse) {
            JFileChooser jFileChooser = new JFileChooser();
            jFileChooser.setFileSelectionMode(2);
            jFileChooser.setMultiSelectionEnabled(true);
            jFileChooser.setPreferredSize(new Dimension(500, 300));
            jFileChooser.setMinimumSize(new Dimension(500, 300));
            int n = jFileChooser.showOpenDialog(null);
            if (n == 0) {
                if (this.classPath.getText().equals("")) {
                    this.classPath.setText(AddDialog.getFileNames(jFileChooser.getSelectedFiles()));
                } else {
                    StringBuffer stringBuffer = new StringBuffer(this.classPath.getText());
                    stringBuffer.append(File.pathSeparator);
                    stringBuffer.append(AddDialog.getFileNames(jFileChooser.getSelectedFiles()));
                    this.classPath.setText(stringBuffer.toString());
                }
            }
        }
    }

    private boolean doesNameExist(String string) {
        for (int i = this.existing.size() - 1; i >= 0; --i) {
            if (!((EditorPlugin)this.existing.get(i)).getName().equals(string)) continue;
            return true;
        }
        return false;
    }

    private static Box createHorizontalBox(JLabel jLabel, JTextField jTextField, JButton jButton) {
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalStrut(5));
        box.add(jLabel);
        box.add(Box.createHorizontalStrut(5));
        box.add(jTextField);
        if (jButton != null) {
            box.add(Box.createHorizontalStrut(5));
            box.add(jButton);
        }
        box.add(Box.createHorizontalGlue());
        return box;
    }

    private static JTextField createTextField(int n) {
        JTextField jTextField = new JTextField(n);
        jTextField.setMaximumSize(new Dimension(200, 21));
        jTextField.setMinimumSize(new Dimension(200, 21));
        jTextField.setPreferredSize(new Dimension(200, 21));
        jTextField.setForeground(Common.FG_COLOR);
        jTextField.setCaretColor(Common.FG_COLOR);
        jTextField.setBackground(Common.BG_COLOR);
        return jTextField;
    }

    private static JLabel createLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(Common.FG_COLOR);
        jLabel.setBackground(Common.WPB_COLOR);
        jLabel.setMaximumSize(new Dimension(100, 21));
        jLabel.setMinimumSize(new Dimension(100, 21));
        jLabel.setPreferredSize(new Dimension(100, 21));
        return jLabel;
    }

    private static JButton createButton(String string) {
        JButton jButton = new JButton(string);
        return jButton;
    }

    private static String getFileNames(File[] fileArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = fileArray.length - 1; i >= 0; --i) {
            String string;
            try {
                string = fileArray[i].getCanonicalPath();
            }
            catch (IOException iOException) {
                string = fileArray[i].getAbsolutePath();
            }
            if (fileArray[i].isDirectory()) {
                string = string + File.separator;
            }
            stringBuffer.append(string);
            if (i <= 0) continue;
            stringBuffer.append(File.pathSeparator);
        }
        return stringBuffer.toString();
    }
}

