/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.editors;

import com.topcoder.client.contestApplet.common.LocalPreferences;
import com.topcoder.client.contestApplet.editors.DynamicEditor;
import com.topcoder.client.contestApplet.editors.EditorPlugin;
import com.topcoder.client.contestApplet.editors.StandardPlugins;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;

public class PluginManager {
    private LocalPreferences pref = LocalPreferences.getInstance();
    private HashMap plugins = new HashMap();
    private static PluginManager pluginManager = null;
    private HashMap cache = new HashMap();

    private PluginManager() {
        this.addPlugins(StandardPlugins.getInstance().getPlugins());
        this.addPlugins(this.pref.getPlugins());
    }

    public void finalize() {
        Iterator iterator = this.cache.values().iterator();
        while (iterator.hasNext()) {
            ((DynamicEditor)iterator.next()).dispose();
            iterator.remove();
        }
    }

    protected void addPlugins(Collection collection) {
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            EditorPlugin editorPlugin = (EditorPlugin)iterator.next();
            this.plugins.put(editorPlugin.getName(), editorPlugin);
        }
    }

    public static synchronized PluginManager getInstance() {
        if (pluginManager == null) {
            pluginManager = System.getProperty("com.topcoder.client.contestApplet.editors.NoPluginManager") != null ? new NoPluginManager() : new PluginManager();
        }
        return pluginManager;
    }

    public synchronized EditorPlugin[] getEditorPlugins() {
        EditorPlugin[] editorPluginArray = this.plugins.values().toArray(new EditorPlugin[0]);
        for (int i = editorPluginArray.length - 1; i >= 0; --i) {
            editorPluginArray[i] = (EditorPlugin)editorPluginArray[i].clone();
        }
        return editorPluginArray;
    }

    public synchronized void setEditorPlugins(EditorPlugin[] editorPluginArray) throws IOException {
        Object object;
        Object object2;
        HashSet hashSet = new HashSet(this.plugins.keySet());
        ArrayList<EditorPlugin> arrayList = new ArrayList<EditorPlugin>();
        for (int i = editorPluginArray.length - 1; i >= 0; --i) {
            object2 = (DynamicEditor)this.cache.remove(editorPluginArray[i].getName());
            if (object2 != null) {
                ((DynamicEditor)object2).dispose();
            }
            hashSet.remove(editorPluginArray[i].getName());
            object = (EditorPlugin)this.plugins.get(editorPluginArray[i].getName());
            if (object == null) {
                DynamicEditor dynamicEditor = this.createEditor(editorPluginArray[i]);
                dynamicEditor.install();
                dynamicEditor.dispose();
            }
            this.plugins.put(editorPluginArray[i].getName(), editorPluginArray[i]);
            if (editorPluginArray[i].getType() == EditorPlugin.STANDARD) continue;
            arrayList.add(editorPluginArray[i]);
        }
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object2 = (EditorPlugin)this.plugins.remove(iterator.next());
            if (object2 == null) continue;
            object = (DynamicEditor)this.cache.remove(((EditorPlugin)object2).getName());
            if (object == null) {
                object = this.createEditor((EditorPlugin)object2);
            }
            ((DynamicEditor)object).uninstall();
            ((DynamicEditor)object).dispose();
        }
        this.pref.setPlugins(arrayList);
        this.pref.savePreferences();
    }

    public synchronized DynamicEditor getEditor(EditorPlugin editorPlugin) throws InstantiationError, NoSuchMethodError {
        return this.getEditor(editorPlugin.getName());
    }

    public synchronized DynamicEditor getEditor(String string) throws InstantiationError, NoSuchMethodError {
        DynamicEditor dynamicEditor = (DynamicEditor)this.cache.remove(string);
        if (dynamicEditor == null) {
            dynamicEditor = this.createEditor(string);
        }
        dynamicEditor.startUsing();
        return dynamicEditor;
    }

    public synchronized void disposeEditor(DynamicEditor dynamicEditor) {
        boolean bl;
        dynamicEditor.stopUsing();
        EditorPlugin editorPlugin = (EditorPlugin)this.plugins.get(dynamicEditor.getPlugin().getName());
        boolean bl2 = editorPlugin == null ? true : (bl = !editorPlugin.equals(dynamicEditor.getPlugin()));
        if (!bl && dynamicEditor.isCacheable()) {
            this.cache.put(dynamicEditor.getPlugin().getName(), dynamicEditor);
        } else {
            dynamicEditor.dispose();
        }
    }

    public String getDefaultEditorName() {
        String string = LocalPreferences.getInstance().getDefaultEditorName();
        if (string == null || string.equals("") || this.plugins.get(string) == null) {
            string = "Standard";
        }
        return string;
    }

    public synchronized DynamicEditor createEditor(String string) throws InstantiationError, NoSuchMethodError {
        EditorPlugin editorPlugin = (EditorPlugin)this.plugins.get(string);
        if (editorPlugin == null) {
            throw new InstantiationError("Unknown plugin name: " + string);
        }
        return this.createEditor(editorPlugin);
    }

    public DynamicEditor createEditor(EditorPlugin editorPlugin) throws InstantiationError, NoSuchMethodError {
        DynamicEditor dynamicEditor = new DynamicEditor(editorPlugin);
        dynamicEditor.setName(editorPlugin.getName());
        return dynamicEditor;
    }

    private static class NoPluginManager
    extends PluginManager {
        private NoPluginManager() {
            super.addPlugins(StandardPlugins.getInstance().getPlugins());
        }

        protected void addPlugins(Collection collection) {
        }

        public synchronized void setEditorPlugins(EditorPlugin[] editorPluginArray) throws IOException {
            throw new IOException("Plugins have been disabled");
        }
    }
}

