/*
 * Decompiled with CFR 0.152.
 */
package com.topcoder.client.contestApplet.common;

import com.topcoder.client.contestApplet.common.Common;
import com.topcoder.client.contestApplet.editors.EditorPlugin;
import com.topcoder.client.ui.UIFactory;
import com.topcoder.client.ui.UIManager;
import com.topcoder.util.config.ConfigManager;
import com.topcoder.util.config.ConfigManagerException;
import com.topcoder.util.config.Property;
import com.topcoder.util.config.UnknownNamespaceException;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Point;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JOptionPane;

public final class LocalPreferences {
    private static LocalPreferences localPref = null;
    private ConfigManager configManager = null;
    private PrefObservable saveObserver = new PrefObservable();
    private UIManager[] managers = null;
    private Vector propertiesList;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyFile(File file, File file2) throws IOException {
        InputStream inputStream = null;
        OutputStream outputStream = null;
        try {
            int n;
            inputStream = new BufferedInputStream(new FileInputStream(file));
            outputStream = new BufferedOutputStream(new FileOutputStream(file2));
            byte[] byArray = new byte[1024];
            while ((n = inputStream.read(byArray)) != -1) {
                outputStream.write(byArray, 0, n);
            }
        }
        finally {
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private LocalPreferences() {
        try {
            this.reload();
            try {
                File file = LocalPreferences.getPreferencesBackupFile();
                File file2 = LocalPreferences.getPreferencesFile();
                LocalPreferences.copyFile(file2, file);
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            block8: {
                File file = null;
                File file3 = null;
                try {
                    file = LocalPreferences.getPreferencesBackupFile();
                    file3 = LocalPreferences.getPreferencesFile();
                    if (file.isFile() && JOptionPane.showConfirmDialog(null, "The preference file is corrupted. Do you want to restore the backup file?", "Confirm", 0) == 0) {
                        LocalPreferences.copyFile(file, file3);
                        this.reload();
                    }
                }
                catch (IOException iOException2) {
                    if (file3 != null) {
                        file3.delete();
                    }
                    if (file == null) break block8;
                    file.delete();
                }
            }
            LocalPreferences.printError(iOException.toString());
        }
    }

    public final void reload() throws IOException {
        File file = LocalPreferences.getPreferencesFile();
        this.configManager = ConfigManager.getInstance();
        if (!file.exists()) {
            BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, "ISO-8859-1"));
            printWriter.println("#TopCoder ContestApplet Preferences File");
            printWriter.println("#" + Calendar.getInstance().getTime());
            printWriter.println("com.topcoder.client.contestApplet.common.LocalPreferences.menufont=Arial");
            printWriter.println("com.topcoder.client.contestApplet.common.LocalPreferences.menufontsize=10");
            printWriter.flush();
        }
        this.configManager.add("contestapplet.conf", file.getPath(), ".properties");
    }

    private final void setNestedProperties(String string) {
        try {
            Property property = this.configManager.getPropertyObject("contestapplet.conf", string);
            if (property.getValue() != null) {
                this.propertiesList.add(string);
            }
            Enumeration enumeration = property.propertyNames();
            while (enumeration.hasMoreElements()) {
                String string2 = (String)enumeration.nextElement();
                String string3 = string + "." + string2;
                if (string.equals("")) {
                    string3 = string2;
                }
                this.setNestedProperties(string3);
            }
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            unknownNamespaceException.printStackTrace();
        }
    }

    private final Vector getNestedProperties(String string) {
        this.propertiesList = new Vector();
        this.setNestedProperties(string);
        return this.propertiesList;
    }

    public static final synchronized LocalPreferences getInstance() {
        if (localPref != null) {
            return localPref;
        }
        localPref = new LocalPreferences();
        return localPref;
    }

    public final ConfigManager getConfigManager() {
        return this.configManager;
    }

    public final void addSaveObserver(Observer observer) {
        this.saveObserver.addObserver(observer);
    }

    public final void removeSaveObserver(Observer observer) {
        this.saveObserver.deleteObserver(observer);
    }

    public final void savePreferences() throws IOException {
        File file = LocalPreferences.getPreferencesFile();
        BufferedOutputStream bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)bufferedOutputStream, "ISO-8859-1"));
        printWriter.println("#TopCoder ContestApplet Preferences File");
        printWriter.println("#" + Calendar.getInstance().getTime());
        Enumeration enumeration = this.getNestedProperties("").elements();
        StringBuffer stringBuffer = new StringBuffer();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = this.configManager.getString("contestapplet.conf", string);
            if (string2 == null) continue;
            this.formatForOutput(string, stringBuffer, true);
            stringBuffer.append('=');
            this.formatForOutput(string2, stringBuffer, false);
            printWriter.println(stringBuffer);
        }
        printWriter.flush();
        this.saveObserver.fireIt();
    }

    public final void saveColors(HashMap hashMap) {
        Iterator iterator = hashMap.keySet().iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            Color color = (Color)hashMap.get(string);
            this.setProperty(string, String.valueOf(color.getRGB()));
        }
        try {
            this.savePreferences();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public final void setColor(String string, Color color) {
        this.setProperty(string, String.valueOf(color.getRGB()));
    }

    public final String getFont(String string) {
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefont")) {
            return this.getFont(string, "Arial");
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfont")) {
            return this.getFont(string, "Arial");
        }
        return this.getFont(string, "Monospaced");
    }

    public final String getFont(String string, String string2) {
        String string3 = this.getProperty(string, string2);
        if (string3 == null || string3.equals("")) {
            return string2;
        }
        return string3;
    }

    public final void setFont(String string, String string2) {
        this.setProperty(string, string2);
    }

    public final int getFontSize(String string) {
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.usertablefontsize")) {
            return this.getFontSize(string, 12);
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.summaryfontsize")) {
            return this.getFontSize(string, 12);
        }
        return this.getFontSize(string, 12);
    }

    public final int getFontSize(String string, int n) {
        String string2 = this.getProperty(string);
        if (string2 == null || string2.equals("")) {
            return n;
        }
        return Integer.parseInt(string2);
    }

    public final void setFontSize(String string, String string2) {
        this.setProperty(string, string2);
    }

    public final Color getColor(String string) {
        return this.getColor(string, Color.black);
    }

    public final Color getColor(String string, Color color) {
        Object object;
        try {
            object = this.getProperty(string);
            if (object != null) {
                return new Color(Integer.parseInt((String)object));
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.systemfore")) {
            return Color.green;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.systemback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemfore")) {
            return Color.green;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.emphsystemback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.generalfore")) {
            return Color.white;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.generalback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.generaltofore")) {
            return Color.white;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.generaltoback")) {
            return Color.red;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.mefore")) {
            return Common.LIGHT_GREY;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.meback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.whisperfore")) {
            return Common.LIGHT_GREY;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.whisperback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.whispertofore")) {
            return Common.LIGHT_GREY;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.whispertoback")) {
            return Color.red;
        }
        if (string.equals("com.topcoder.client.contestApplet.panels.ChatPanel.handleback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindback")) {
            return Color.BLUE;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.chatfindhighlight")) {
            return Color.GRAY;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.edstdfore")) {
            return Color.white;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.edstdback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselt")) {
            return Common.HF_COLOR;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.edstdselb")) {
            return Common.LIGHT_GREEN;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxcomments")) {
            return Color.decode("0x00CC00");
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxliterals")) {
            return Color.decode("0xFF00FF");
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxkeywords")) {
            return Color.decode("0x9999FF");
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxdefault")) {
            return Color.decode("0xFFFFFF");
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.problemfore")) {
            return Color.white;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.problemback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.problemfixedfore")) {
            return Color.white;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.problemfixedback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.messagefore")) {
            return Color.white;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.messageback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcfore")) {
            return Color.white;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobfore")) {
            return Color.white;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.chalprobback")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionFore")) {
            return Color.green;
        }
        if (string.equals("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatQuestionBack")) {
            return Color.black;
        }
        if (string.equals("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerFore")) {
            return Color.white;
        }
        if (string.equals("com.topcoder.client.contentApplet.panels.ChatPanel.moderatedChatSpeakerBack")) {
            return Color.black;
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryunopened")) {
            return new Color(255, 255, 255);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryopened")) {
            return new Color(255, 255, 255);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycompiled")) {
            return new Color(255, 255, 255);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavapoints")) {
            return new Color(0, 255, 0);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlpassed")) {
            return new Color(0, 255, 0);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlfailed")) {
            return new Color(0, 255, 0);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasyspassed")) {
            return new Color(0, 255, 0);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasysfailed")) {
            return new Color(255, 0, 51);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycpppoints")) {
            return new Color(255, 255, 153);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlpassed")) {
            return new Color(255, 255, 153);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlfailed")) {
            return new Color(255, 255, 153);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsyspassed")) {
            return new Color(255, 255, 153);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsysfailed")) {
            return new Color(255, 0, 51);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharppoints")) {
            return new Color(102, 102, 255);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlpassed")) {
            return new Color(102, 102, 255);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlfailed")) {
            return new Color(102, 102, 255);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsyspassed")) {
            return new Color(102, 102, 255);
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsysfailed")) {
            return new Color(255, 0, 51);
        }
        object = new Color(129, 217, 255);
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbpoints")) {
            return object;
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlpassed")) {
            return object;
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlfailed")) {
            return object;
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsyspassed")) {
            return object;
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsysfailed")) {
            return new Color(255, 0, 51);
        }
        Color color2 = new Color(255, 102, 255);
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonpoints")) {
            return color2;
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlpassed")) {
            return color2;
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlfailed")) {
            return color2;
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsyspassed")) {
            return color2;
        }
        if (string.startsWith("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsysfailed")) {
            return new Color(255, 0, 51);
        }
        return color;
    }

    public final boolean isTrue(String string) {
        String string2 = this.getProperty(string);
        if (string2 != null) {
            return new Boolean(string2);
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlpassed", "bold"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasyspassed", "bold"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlpassed", "bold"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsyspassed", "bold"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlpassed", "bold"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsyspassed", "bold"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavachlpassed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasyspassed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summaryjavasysfailed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppchlpassed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsyspassed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarycppsysfailed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpchlpassed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsyspassed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarycsharpsysfailed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlpassed", "bold"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsyspassed", "bold"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbchlpassed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsyspassed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summaryvbsysfailed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlpassed", "bold"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsyspassed", "bold"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonchlpassed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsyspassed", "italic"))) {
            return true;
        }
        if (string.equals(LocalPreferences.getKeyAttribute("com.topcoder.client.contestApplet.common.LocalPreferences.summarypythonsysfailed", "italic"))) {
            return true;
        }
        if (string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.edstdindent")) {
            return true;
        }
        return string.equals("com.topcoder.client.contestApplet.common.LocalPreferences.UnusedCodeCheckEnabled");
    }

    public final void setTrue(String string, boolean bl) {
        this.setProperty(string, bl ? "true" : "false");
    }

    public final List getPlugins() {
        ArrayList<EditorPlugin> arrayList = new ArrayList<EditorPlugin>();
        int n = 0;
        try {
            String string = this.getProperty("editor.numplugins");
            if (string != null) {
                n = Integer.parseInt(string);
            }
        }
        catch (NumberFormatException numberFormatException) {
            LocalPreferences.printError("editor.numplugins is not a valid number");
        }
        for (int i = n; i > 0; --i) {
            String string = this.getProperty(LocalPreferences.getPluginKey(i, "name"));
            String string2 = this.getProperty(LocalPreferences.getPluginKey(i, "entrypoint"));
            String string3 = this.getProperty(LocalPreferences.getPluginKey(i, "classpath"));
            String string4 = this.getProperty(LocalPreferences.getPluginKey(i, "eager"));
            if (string == null) {
                LocalPreferences.printError(LocalPreferences.getPluginKey(i, "name") + " is not defined");
                continue;
            }
            if (string2 == null) {
                LocalPreferences.printError(LocalPreferences.getPluginKey(i, "entrypoint") + " is not defined");
                continue;
            }
            if (string3 == null) {
                LocalPreferences.printError(LocalPreferences.getPluginKey(i, "classpath") + " is not defined");
                continue;
            }
            if (string4 == null) {
                string4 = "0";
            }
            arrayList.add(new EditorPlugin(string, string2, string3, string4.equals("1")));
        }
        return arrayList;
    }

    public final void setPluginCommonPath(String string) {
        this.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.commonclasspath", string);
    }

    public final String getPluginCommonPath() {
        return this.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.commonclasspath");
    }

    public final void setPlugins(List list) {
        int n = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            EditorPlugin editorPlugin;
            try {
                editorPlugin = (EditorPlugin)iterator.next();
            }
            catch (ClassCastException classCastException) {
                LocalPreferences.printError("Plugins list contained a non-plugin!");
                continue;
            }
            this.setProperty(LocalPreferences.getPluginKey(++n, "name"), editorPlugin.getName());
            this.setProperty(LocalPreferences.getPluginKey(n, "entrypoint"), editorPlugin.getEntryPoint());
            this.setProperty(LocalPreferences.getPluginKey(n, "classpath"), editorPlugin.getClassPath());
            this.setProperty(LocalPreferences.getPluginKey(n, "eager"), editorPlugin.getEager() ? "1" : "0");
        }
        this.setProperty("editor.numplugins", String.valueOf(n));
    }

    public final HashSet getIgnoreList() {
        HashSet<String> hashSet = new HashSet<String>();
        String string = this.getProperty("com.topcoder.jmaContesntApplet.ContestApplet.ignoreNumber");
        if (string == null) {
            string = "0";
        }
        int n = Integer.parseInt(string);
        for (int i = 0; i < n; ++i) {
            String string2 = this.getProperty("com.topcoder.jmaContesntApplet.ContestApplet.ignoreList." + i);
            if (string2 == null) continue;
            hashSet.add(string2);
        }
        return hashSet;
    }

    public final void addToIgnoreList(String string) {
        String string2 = this.getProperty("com.topcoder.jmaContesntApplet.ContestApplet.ignoreNumber");
        if (string2 == null) {
            string2 = "0";
        }
        int n = Integer.parseInt(string2);
        this.setProperty("com.topcoder.jmaContesntApplet.ContestApplet.ignoreList." + n++, string);
        this.setProperty("com.topcoder.jmaContesntApplet.ContestApplet.ignoreNumber", "" + n);
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public final void clearIgnore() {
        this.setProperty("com.topcoder.jmaContesntApplet.ContestApplet.ignoreNumber", "0");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public final void removeFromIgnoreList(String string) {
        String string2 = this.getProperty("com.topcoder.jmaContesntApplet.ContestApplet.ignoreNumber");
        if (string2 == null) {
            string2 = "0";
        }
        int n = Integer.parseInt(string2);
        boolean bl = false;
        for (int i = 0; i < n; ++i) {
            String string3 = this.getProperty("com.topcoder.jmaContesntApplet.ContestApplet.ignoreList." + i);
            if (bl) {
                this.setProperty("com.topcoder.jmaContesntApplet.ContestApplet.ignoreList." + (i - 1), string3);
            }
            if (!string3.equals(string)) continue;
            bl = true;
        }
        this.setProperty("com.topcoder.jmaContesntApplet.ContestApplet.ignoreNumber", "" + (n - (bl ? 1 : 0)));
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public void setProperty(String string, String string2) {
        if (string.equals("popsedit.config.javatemplate")) {
            System.out.println(string2);
        }
        try {
            this.configManager.createTemporaryProperties("contestapplet.conf");
            this.configManager.setProperty("contestapplet.conf", string, string2);
            this.configManager.commit("contestapplet.conf", "user");
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            unknownNamespaceException.printStackTrace();
        }
        catch (ConfigManagerException configManagerException) {
            configManagerException.printStackTrace();
        }
    }

    public String getProperty(String string) {
        try {
            String string2 = this.configManager.getString("contestapplet.conf", string);
            if (string2 == null) {
                return null;
            }
            return string2.replaceAll("\\\\;", ";");
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            unknownNamespaceException.printStackTrace();
            return "";
        }
    }

    public String getHotKey(String string) {
        if (string == "com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyfind") {
            return this.getProperty(string, "Alt+F");
        }
        if (string == "com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeygoto") {
            return this.getProperty(string, "Alt+G");
        }
        if (string == "com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyundo") {
            return this.getProperty(string, "Ctrl+Z");
        }
        if (string == "com.topcoder.client.contestApplet.common.LocalPreferences.edstdkeyredo") {
            return this.getProperty(string, "Ctrl+Y");
        }
        if (string == "com.topcoder.client.contestApplet.common.LocalPreferences.keysave") {
            return this.getProperty(string, "Alt+S");
        }
        if (string == "com.topcoder.client.contestApplet.common.LocalPreferences.keycompile") {
            return this.getProperty(string, "Alt+C");
        }
        if (string == "com.topcoder.client.contestApplet.common.LocalPreferences.keytest") {
            return this.getProperty(string, "Alt+T");
        }
        if (string == "com.topcoder.client.contestApplet.common.LocalPreferences.keysubmit") {
            return this.getProperty(string, "Alt+U");
        }
        return this.getProperty(string);
    }

    public String getProperty(String string, String string2) {
        try {
            String string3 = this.configManager.getString("contestapplet.conf", string);
            if (string3 == null || string3.equals("")) {
                return string2;
            }
            return string3.replaceAll("\\\\;", ";");
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            unknownNamespaceException.printStackTrace();
            return string2;
        }
    }

    public boolean getBoolean(String string, boolean bl) {
        return new Boolean(this.getProperty(string, "" + bl));
    }

    public final Enumeration getKeys() {
        return this.getNestedProperties("com").elements();
    }

    public final String removeProperty(String string) {
        String string2 = "";
        try {
            this.configManager.createTemporaryProperties("contestapplet.conf");
            string2 = this.getProperty(string);
            this.configManager.removeProperty("contestapplet.conf", string);
            this.configManager.commit("contestapplet.conf", "user");
        }
        catch (UnknownNamespaceException unknownNamespaceException) {
            unknownNamespaceException.printStackTrace();
        }
        catch (ConfigManagerException configManagerException) {
            configManagerException.printStackTrace();
        }
        return string2;
    }

    private static final String getPluginKey(int n, String string) {
        StringBuffer stringBuffer = new StringBuffer("editor.");
        stringBuffer.append(n);
        stringBuffer.append(".");
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public final int getTabSize() {
        String string = this.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdtabsize");
        return string == null ? 4 : Integer.parseInt(string);
    }

    public final boolean isEditorCache() {
        String string = this.getProperty("editor.cache");
        return string == null ? true : !string.equals("false");
    }

    public final boolean isEditorDebug() {
        String string = this.getProperty("editor.debug");
        return string == null ? false : string.equals("true");
    }

    public final boolean isSyntaxHighlight() {
        String string = this.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxhighlight");
        return string == null ? true : !string.equals("false");
    }

    public final void setSyntaxHighlight(boolean bl) {
        this.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.edstdsyntaxhighlight", String.valueOf(bl));
    }

    public final boolean isViewerSyntaxHighlight() {
        String string = this.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcsyntaxhighlight");
        return string == null ? true : !string.equals("false");
    }

    public final void setViewerSyntaxHighlight(boolean bl) {
        this.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.chalsrcsyntaxhighlight", String.valueOf(bl));
    }

    public final String getDefaultEditorName() {
        String string = this.getProperty("editor.defaultname");
        return string == null ? "" : string;
    }

    public final void setDefaultEditorName(String string) {
        this.setProperty("editor.defaultname", string);
    }

    public final Dimension getSize(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(":");
        if (n < 0) {
            return null;
        }
        try {
            return new Dimension(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public final void setSize(String string, Dimension dimension) {
        this.setProperty(string, (int)dimension.getWidth() + ":" + (int)dimension.getHeight());
    }

    public final Point getLocation(String string) {
        String string2 = this.getProperty(string);
        if (string2 == null) {
            return null;
        }
        int n = string2.indexOf(":");
        if (n < 0) {
            return null;
        }
        try {
            return new Point(Integer.parseInt(string2.substring(0, n)), Integer.parseInt(string2.substring(n + 1)));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
    }

    public final void setLocation(String string, Point point) {
        this.setProperty(string, (int)point.getX() + ":" + (int)point.getY());
    }

    private static final void printError(String string) {
        System.err.println("LocalPreferences: " + string);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final UIManager[] getAllUIManagers() {
        if (this.managers != null) {
            return this.managers;
        }
        LocalPreferences localPreferences = this;
        synchronized (localPreferences) {
            if (this.managers == null) {
                try {
                    File file = new File(LocalPreferences.getPreferencesFile().getParent(), "arenaui");
                    this.managers = UIFactory.getAllUIManagers(file);
                }
                catch (IOException iOException) {
                    this.managers = new UIManager[0];
                }
            }
        }
        return this.managers;
    }

    private static final File getPreferencesFile() throws IOException {
        try {
            String string;
            String string2 = System.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.filelocation");
            if (string2 == null) {
                string2 = System.getProperty("user.home");
            }
            if (string2 == null) {
                string2 = System.getProperty("java.home");
            }
            if ((string = System.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.filename")) == null) {
                string = "contestapplet.conf";
            }
            return new File(string2, string);
        }
        catch (Exception exception) {
            throw new IOException("Cannot access local properties file");
        }
    }

    private static final File getPreferencesBackupFile() throws IOException {
        try {
            String string;
            String string2 = System.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.filelocation");
            if (string2 == null) {
                string2 = System.getProperty("user.home");
            }
            if (string2 == null) {
                string2 = System.getProperty("java.home");
            }
            if ((string = System.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.filename")) == null) {
                string = "contestapplet.conf";
            }
            string = string + ".bak";
            return new File(string2, string);
        }
        catch (Exception exception) {
            throw new IOException("Cannot access local properties file");
        }
    }

    public void toggleBroadcastPopup() {
        String string = this.getProperty("com.topcoder.jmaContesntApplet.ContestApplet.disableBroadcastPopup");
        if (string == null) {
            string = "false";
        }
        this.setProperty("com.topcoder.jmaContesntApplet.ContestApplet.disableBroadcastPopup", string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public void toggleLeaderTicker() {
        String string = this.getProperty("com.topcoder.client.contestApplet.panels.main.FaderPanel.enabled");
        if (string == null) {
            string = "false";
        }
        this.setProperty("com.topcoder.client.contestApplet.panels.main.FaderPanel.enabled", string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void toggleBroadcastBeep() {
        String string = this.getProperty("com.topcoder.jmaContesntApplet.ContestApplet.disableBroadcastBeep");
        if (string == null) {
            string = "false";
        }
        this.setProperty("com.topcoder.jmaContesntApplet.ContestApplet.disableBroadcastBeep", string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public void toggleEnableTimestamps() {
        String string = this.getProperty("com.topcoder.jmaContesntApplet.ContestApplet.enableTimestamps");
        if (string == null) {
            string = "false";
        }
        this.setProperty("com.topcoder.jmaContesntApplet.ContestApplet.enableTimestamps", string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public void toggleEnableUnusedCodeCheck() {
        String string = this.getProperty("com.topcoder.client.contestApplet.common.LocalPreferences.UnusedCodeCheckEnabled");
        if (string == null) {
            string = "true";
        }
        this.setProperty("com.topcoder.client.contestApplet.common.LocalPreferences.UnusedCodeCheckEnabled", string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public void toggleDisableChatScrolling() {
        String string = this.getProperty("com.topcoder.jmaContesntApplet.ContestApplet.disableChatScrolling");
        if (string == null) {
            string = "false";
        }
        this.setProperty("com.topcoder.jmaContesntApplet.ContestApplet.disableChatScrolling", string.equals("true") ? "false" : "true");
        try {
            this.savePreferences();
        }
        catch (Exception exception) {
            System.err.println("Error saving preferences file");
            exception.printStackTrace();
        }
    }

    public static String getKeyAttribute(String string, String string2) {
        return string + "." + string2;
    }

    private void formatForOutput(String string, StringBuffer stringBuffer, boolean bl) {
        string = string.replaceAll("\\\\;", ";");
        if (bl) {
            stringBuffer.setLength(0);
            stringBuffer.ensureCapacity(string.length());
        } else {
            stringBuffer.ensureCapacity(stringBuffer.length() + string.length());
        }
        boolean bl2 = true;
        int n = string.length();
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            switch (c) {
                case '\n': {
                    stringBuffer.append("\\n");
                    break;
                }
                case '\r': {
                    stringBuffer.append("\\r");
                    break;
                }
                case '\t': {
                    stringBuffer.append("\\t");
                    break;
                }
                case ' ': {
                    stringBuffer.append(bl2 ? "\\ " : " ");
                    break;
                }
                case '!': 
                case '#': 
                case ':': 
                case '=': 
                case '\\': {
                    stringBuffer.append('\\').append(c);
                    break;
                }
                default: {
                    if (c < ' ' || c > '~') {
                        String string2 = Integer.toHexString(c);
                        stringBuffer.append("\\u0000".substring(0, 6 - string2.length()));
                        stringBuffer.append(string2);
                        break;
                    }
                    stringBuffer.append(c);
                }
            }
            if (c == ' ') continue;
            bl2 = bl;
        }
    }

    public static String resolveStatusPropertyFormat(int n, int n2) {
        String string;
        String string2;
        switch (n) {
            case 1: {
                string2 = "java";
                break;
            }
            case 3: {
                string2 = "cpp";
                break;
            }
            case 4: {
                string2 = "csharp";
                break;
            }
            case 5: {
                string2 = "vb";
                break;
            }
            case 6: {
                string2 = "python";
                break;
            }
            default: {
                string2 = "";
            }
        }
        switch (n2) {
            case 110: {
                string2 = "";
                string = "unopened";
                break;
            }
            case 120: {
                string = "opened";
                string2 = "";
                break;
            }
            case 121: {
                string = "compiled";
                string2 = "";
                break;
            }
            case 130: {
                string = "";
                string2 = string2 + "points";
                break;
            }
            case 131: {
                string = "chlfailed";
                break;
            }
            case 140: {
                string = "chlpassed";
                break;
            }
            case 150: {
                string = "syspassed";
                break;
            }
            case 160: {
                string = "sysfailed";
                break;
            }
            default: {
                throw new IllegalArgumentException("Unknown component status " + n2);
            }
        }
        String string3 = "com.topcoder.client.contestApplet.common.LocalPreferences.summary" + string2 + string;
        return string3;
    }

    private static class PrefObservable
    extends Observable {
        private PrefObservable() {
        }

        public void fireIt() {
            this.setChanged();
            this.notifyObservers();
        }
    }
}

