/*
 * Decompiled with CFR 0.152.
 */
package moj;

import java.util.TreeMap;
import java.util.regex.Pattern;

public class LanguageAutoDetection {
    static final String[] CPLUSPLUS_MARKERS = new String[]{"#\\s*include", "#\\s*define", "private:", "public:", "protected:", "struct\\s", "using\\s+namespace", "template\\s*<", "inline\\s*", "vector\\s*<", "::"};
    static final String[] JAVA_MARKERS = new String[]{"import\\s+java\\.", "public \\w", "String\\s*\\[\\]", "int\\s*\\[\\]", "long\\s*\\[\\]", "HashMap", "TreeMap"};
    static final String[] CSHARP_MARKERS = new String[]{"using\\s+System", "string\\s*\\[\\]", "\\[,\\]", "\\[,,\\]", "\\[,,,\\]", "\\[,,,,\\]"};

    static String filterComments(String source) {
        StringBuilder sb = new StringBuilder();
        int i = 0;
        while (i < source.length()) {
            if (i + 2 <= source.length()) {
                int nextpos;
                if (source.substring(i, i + 2).equals("//")) {
                    nextpos = source.indexOf("\n", i + 2);
                    if (nextpos == -1) break;
                    i = nextpos;
                    continue;
                }
                if (source.substring(i, i + 2).equals("/*")) {
                    nextpos = source.indexOf("*/", i + 2);
                    if (nextpos == -1) break;
                    sb.append(' ');
                    i = nextpos + 2;
                    continue;
                }
            }
            sb.append(source.charAt(i++));
        }
        return sb.toString();
    }

    static boolean isMostLikely(String source, String candidate) {
        source = LanguageAutoDetection.filterComments(source);
        TreeMap<String, String[]> markers = new TreeMap<String, String[]>();
        markers.put("C++", CPLUSPLUS_MARKERS);
        markers.put("Java", JAVA_MARKERS);
        markers.put("C#", CSHARP_MARKERS);
        System.err.printf("moj language auto detection:", new Object[0]);
        int best = 0;
        String ret = "C++";
        boolean first = true;
        for (String language : markers.keySet()) {
            int matched = 0;
            int total = 0;
            String[] stringArray = (String[])markers.get(language);
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String m = stringArray[n2];
                if (Pattern.compile(m, 8).matcher(source).find()) {
                    ++matched;
                }
                ++total;
                ++n2;
            }
            if (matched > best || matched == best && language.equals(candidate)) {
                best = matched;
                ret = language;
            }
            if (!first) {
                System.err.printf(",", new Object[0]);
            }
            first = false;
            System.err.printf(" %s %d markers", language, matched);
        }
        System.err.printf("\n", new Object[0]);
        return ret.equals(candidate);
    }
}

