/*
 * Decompiled with CFR 0.152.
 */
package moj;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.LayoutManager;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.text.JTextComponent;

class Common {
    public static final Color FG_COLOR = Color.white;
    public static final Color BG_COLOR = Color.black;
    public static final Color WPB_COLOR = Color.decode("0x333333");
    public static final Color TF_COLOR = Color.white;
    public static final Color TB_COLOR = Color.black;
    public static final Color HF_COLOR = Color.white;
    public static final Color HB_COLOR = Color.decode("0x003300");
    public static final Font DEFAULTFONT = new Font("SansSerif", 0, 12);

    Common() {
    }

    public static final Box createHorizontalBox(Component[] a) {
        return Common.createHorizontalBox(a, true);
    }

    public static final Box createHorizontalBox(Component[] a, boolean endGlue) {
        Box temp = Box.createHorizontalBox();
        if (a.length == 0) {
            return temp;
        }
        int x = 0;
        while (x < a.length - 1) {
            temp.add(a[x]);
            temp.add(Box.createHorizontalStrut(5));
            ++x;
        }
        temp.add(a[a.length - 1]);
        if (endGlue) {
            temp.add(Box.createHorizontalGlue());
        }
        return temp;
    }

    public static final JTable createJTable() {
        JTable table = new JTable();
        table.setBackground(TB_COLOR);
        table.setForeground(TF_COLOR);
        table.setSelectionBackground(HB_COLOR);
        table.setSelectionForeground(HF_COLOR);
        table.setShowGrid(false);
        return table;
    }

    public static final JLabel createJLabel(String text) {
        return Common.createJLabel(text, DEFAULTFONT);
    }

    public static final JLabel createJLabel(String text, Font font) {
        return Common.createJLabel(text, null, 2, font);
    }

    public static final JLabel createJLabel(String text, Dimension size) {
        return Common.createJLabel(text, size, 2, DEFAULTFONT);
    }

    public static final JLabel createJLabel(String text, Dimension size, int alignment) {
        return Common.createJLabel(text, size, alignment, DEFAULTFONT);
    }

    public static final JLabel createJLabel(String text, Dimension size, int alignment, Font font) {
        JLabel temp = new JLabel(text);
        temp.setForeground(FG_COLOR);
        temp.setBackground(WPB_COLOR);
        temp.setFont(font);
        temp.setHorizontalAlignment(alignment);
        if (size != null) {
            temp.setMinimumSize(size);
            temp.setPreferredSize(size);
            temp.setMaximumSize(size);
        }
        return temp;
    }

    public static final JTextField createJTextField(int size, Dimension max) {
        return Common.createJTextField(size, max, DEFAULTFONT);
    }

    public static final JTextField createJTextField(int size, Dimension max, Font font) {
        JTextField temp = new JTextField(size);
        temp.setForeground(FG_COLOR);
        temp.setBackground(BG_COLOR);
        temp.setCaretColor(FG_COLOR);
        temp.setFont(font);
        temp.setBorder(BorderFactory.createLineBorder(FG_COLOR, 1));
        temp.setMaximumSize(max);
        temp.addFocusListener(new SelectAll(temp));
        return temp;
    }

    public static final JScrollPane createJScrollPane(Component a) {
        return Common.createJScrollPane(a, null, null);
    }

    public static final JScrollPane createJScrollPane(Component a, Dimension size) {
        return Common.createJScrollPane(a, size, null);
    }

    public static final JScrollPane createJScrollPane(Component a, Dimension size, Border border) {
        JScrollPane temp = new JScrollPane(a);
        temp.setBackground(WPB_COLOR);
        temp.getViewport().setBackground(WPB_COLOR);
        if (size != null) {
            temp.getViewport().setPreferredSize(size);
        }
        if (border != null) {
            temp.setBorder(border);
        }
        return temp;
    }

    public static final void setDefaultAttributes(Container panel) {
        Common.setDefaultAttributes(panel, new BorderLayout());
    }

    public static final void setDefaultAttributes(Container panel, LayoutManager layout) {
        panel.setLayout(layout);
        panel.setBackground(WPB_COLOR);
    }

    public static final JButton createJButton(String text) {
        return Common.createJButton(text, null, DEFAULTFONT);
    }

    public static final JButton createJButton(String text, Dimension size) {
        return Common.createJButton(text, size, DEFAULTFONT);
    }

    public static final JButton createJButton(String text, Font font) {
        return Common.createJButton(text, null, font);
    }

    public static final JButton createJButton(String text, Dimension size, Font font) {
        JButton temp = new JButton(text);
        temp.setFont(font);
        if (size != null) {
            temp.setMinimumSize(size);
            temp.setPreferredSize(size);
            temp.setMaximumSize(size);
        }
        return temp;
    }

    public static void showMessage(String title, String msg, Component comp) {
        JOptionPane.showMessageDialog(comp, msg, title, 1);
    }

    public static void showError(String title, String msg, Component comp) {
        JOptionPane.showMessageDialog(comp, msg, title, 1);
    }

    public static boolean confirm(String title, String msg, Component comp) {
        int choice = JOptionPane.showConfirmDialog(comp, msg, title, 0, 2);
        return choice == 0;
    }

    public static String input(String title, String msg, Component comp) {
        String value = JOptionPane.showInputDialog(comp, msg, title, 3);
        return value;
    }

    private static class SelectAll
    extends FocusAdapter {
        JTextComponent parent;

        public SelectAll(JTextComponent parent) {
            this.parent = parent;
        }

        public void focusGained(FocusEvent e) {
            this.parent.selectAll();
        }
    }
}

