/*
 * Decompiled with CFR 0.152.
 */
package fileedit;

import com.topcoder.client.contestant.ProblemComponentModel;
import com.topcoder.shared.language.Language;
import com.topcoder.shared.problem.Renderer;
import fileedit.Common;
import fileedit.ConfigurationDialog;
import fileedit.FileEditorPanel;
import fileedit.Preferences;
import fileedit.Utilities;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JPanel;
import javax.swing.JTextArea;

public class EntryPoint
implements Observer {
    JPanel panel;
    JTextArea log = new JTextArea();
    boolean overridefname;
    File directory;
    File fullPath = null;
    String fileName;
    String beginCut;
    String endCut;
    String initialSrc = null;
    Preferences pref = new Preferences(this);
    Map userDefinedTags = new HashMap();
    Language language;
    ProblemComponentModel component = null;
    Renderer renderer;
    private static final String POWEREDBY = "// Powered by FileEdit";

    public EntryPoint() {
        this.log.setForeground(Common.FG_COLOR);
        this.log.setBackground(Common.BG_COLOR);
        this.loadPreferences();
        this.panel = new FileEditorPanel(this.log);
    }

    public void configure() {
        new ConfigurationDialog().show();
    }

    public void setUserDefinedTags(Map userDefinedTags) {
        this.userDefinedTags = userDefinedTags;
    }

    public void setProblemComponent(ProblemComponentModel component, Language lang, Renderer renderer) {
        this.component = component;
        this.language = lang;
        this.renderer = renderer;
    }

    public JPanel getEditorPanel() {
        return this.panel;
    }

    public String getSource() {
        if (this.fullPath == null) {
            this.writeLog("Trying to read source but file isn't initialized!.  Returning nothing.");
            return "";
        }
        if (!this.fullPath.exists()) {
            this.writeLog("Trying to read File " + this.fullPath + " but it does not exist!.  Returning nothing.");
            return "";
        }
        int len = (int)this.fullPath.length();
        StringBuffer sourceComments = new StringBuffer(len);
        StringBuffer source = new StringBuffer(len);
        BufferedReader in = null;
        boolean ignoreLine = false;
        try {
            try {
                String line;
                in = new BufferedReader(new FileReader(this.fullPath));
                while ((line = in.readLine()) != null) {
                    sourceComments.append(line);
                    sourceComments.append(Utilities.lineEnding);
                    if (line.trim().equals(this.beginCut.trim())) {
                        ignoreLine = true;
                        continue;
                    }
                    if (line.trim().equals(this.endCut.trim())) {
                        ignoreLine = false;
                        continue;
                    }
                    if (ignoreLine) continue;
                    source.append(line);
                    source.append(Utilities.lineEnding);
                }
            }
            catch (IOException e) {
                this.writeLog("Error reading source code from file " + this.fullPath + ": " + e.toString() + Utilities.lineEnding + "Returning nothing.");
                Object var7_8 = null;
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (IOException e2) {
                        // empty catch block
                    }
                }
                return "";
            }
        }
        catch (Throwable throwable) {
            Object var7_9 = null;
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
            throw throwable;
        }
        Object var7_10 = null;
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException e2) {
                // empty catch block
            }
        }
        this.writeLog("Source read from file " + this.fullPath);
        if (this.initialSrc != null && this.initialSrc.equals(sourceComments.toString())) {
            this.writeLog("No changes to initial source - returning nothing");
            return "";
        }
        if (this.pref.isPoweredBy() && !source.toString().endsWith(POWEREDBY) && source.length() != 0) {
            source.append(Utilities.lineEnding);
            source.append(Utilities.lineEnding);
            source.append(POWEREDBY);
        }
        String sig = this.getSignature();
        if (!source.toString().startsWith(sig) && source.length() != 0) {
            source.insert(0, sig);
        }
        return source.toString();
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected String getSignature() {
        block11: {
            sigFileName = this.pref.getSignatureFileName().trim();
            if (sigFileName.equals("") != false) return "";
            sigFile = new File(sigFileName);
            if (sigFile.exists() == false) return "";
            sig = new StringBuffer((int)sigFile.length());
            in = null;
            try {
                try {
                    in = new BufferedReader(new FileReader(sigFile));
                    while (true) {
                        if ((line = in.readLine()) == null) {
                            var8_7 = sig.toString();
                            var6_8 = null;
                            if (in == null) return var8_7;
                            break;
                        }
                        sig.append(line);
                        sig.append(Utilities.lineEnding);
                    }
                }
                catch (IOException e) {
                    this.writeLog("Error reading the signature file " + sigFileName + ":" + e.toString() + Utilities.lineEnding + "SigFile ignored");
                    break block11;
                }
            }
            catch (Throwable var7_14) {
                var6_9 = null;
                if (in == null) throw var7_14;
                try {
                    in.close();
                    throw var7_14;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw var7_14;
            }
            ** try [egrp 2[TRYBLOCK] [2 : 184->192)] { 
lbl37:
            // 1 sources

            in.close();
            return var8_7;
lbl39:
            // 1 sources

            catch (IOException e) {
                // empty catch block
            }
            return var8_7;
        }
        var6_10 = null;
        if (in == null) return "";
        try {}
        catch (IOException e) {
            return "";
        }
        in.close();
        return "";
    }

    public void setSource(String source) {
        block40: {
            String problemDescription;
            String className = this.component.getClassName();
            String tFileName = (this.overridefname ? this.fileName : className) + "." + (this.language.getId() == 3 ? this.pref.getCPPExtension() : (this.language.getId() == 1 ? this.pref.getJAVAExtension() : this.pref.getCSHARPExtension()));
            try {
                problemDescription = this.pref.isHTMLDesc() ? this.renderer.toHTML(this.language) : this.renderer.toPlainText(this.language);
            }
            catch (Exception e) {
                System.err.println("Exception happened during rendering: " + e);
                problemDescription = this.pref.isHTMLDesc() ? "<html><body>Error happened - see applet for problem text</body></html>" : "Error happened - see applet for problem text";
            }
            String string = problemDescription = this.pref.isHTMLDesc() ? problemDescription : Utilities.parseProblem(problemDescription);
            if (source == null || source.equals("") || source.equals(this.component.getDefaultSolution())) {
                source = Utilities.getSource(this.language, this.component, tFileName, this.pref.isHTMLDesc() ? "" : problemDescription);
            }
            source = Utilities.replaceUserDefined(source, this.userDefinedTags);
            this.fullPath = new File(this.directory, tFileName);
            if (this.fullPath.exists()) {
                File renameIt;
                if (!this.pref.isBackup()) {
                    this.writeLog("File '" + this.fullPath + "' already exists - not overwriting due to config option");
                    return;
                }
                File backup = new File(this.directory, String.valueOf(tFileName) + ".bak");
                if (backup.exists()) {
                    if (backup.delete()) {
                        this.writeLog("Backup file " + backup + " exists and was deleted");
                    } else {
                        this.writeLog("Error deleting backup file " + backup);
                    }
                }
                if ((renameIt = new File(this.directory, tFileName)).renameTo(backup)) {
                    this.writeLog("File " + this.fullPath + " is being backed up to " + backup);
                } else {
                    this.writeLog("Error backing up file " + this.fullPath);
                    this.writeLog("No Backup exists for the file - be careful");
                }
            }
            BufferedReader in = null;
            BufferedWriter out = null;
            try {
                try {
                    String line;
                    if (this.directory.mkdirs()) {
                        this.writeLog("Directory " + this.directory + " was created");
                    }
                    if (this.fullPath.createNewFile()) {
                        this.writeLog("File " + this.fullPath + " was created");
                    }
                    out = new BufferedWriter(new FileWriter(this.fullPath));
                    in = new BufferedReader(new StringReader(source));
                    while ((line = in.readLine()) != null) {
                        out.write(line);
                        out.write(Utilities.lineEnding);
                    }
                    this.writeLog("Source successfully written to " + this.fullPath);
                }
                catch (IOException e) {
                    this.writeLog("Error writing to file " + this.fullPath + ": " + e.toString());
                }
            }
            catch (Throwable throwable) {
                Object var8_13 = null;
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    this.writeLog("Error closing the file " + this.fullPath + ": " + e.toString());
                }
                throw throwable;
            }
            Object var8_14 = null;
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                out.flush();
                out.close();
            }
            catch (IOException e) {
                this.writeLog("Error closing the file " + this.fullPath + ": " + e.toString());
            }
            if (!this.pref.isWriteProblemDescFile()) break block40;
            String pFileName = (this.overridefname ? this.fileName : className) + "." + this.pref.getProblemDescExtension();
            File pFullPath = new File(this.directory, pFileName);
            try {
                try {
                    String line;
                    if (this.directory.mkdirs()) {
                        this.writeLog("Directory " + this.directory + " was created");
                    }
                    if (pFullPath.createNewFile()) {
                        this.writeLog("File " + pFullPath + " was created");
                    }
                    out = new BufferedWriter(new FileWriter(pFullPath));
                    in = new BufferedReader(new StringReader(problemDescription));
                    while ((line = in.readLine()) != null) {
                        out.write(line);
                        out.write(Utilities.lineEnding);
                    }
                    this.writeLog("Problem Description successfully written to " + pFullPath);
                }
                catch (IOException e) {
                    this.writeLog("Error writing to file " + pFullPath + ": " + e.toString());
                }
            }
            catch (Throwable throwable) {
                iOException = null;
                try {
                    in.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                try {
                    out.flush();
                    out.close();
                }
                catch (IOException e) {
                    this.writeLog("Error closing the file " + pFullPath + ": " + e.toString());
                }
                throw throwable;
            }
            iOException = null;
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            try {
                out.flush();
                out.close();
            }
            catch (IOException e) {
                this.writeLog("Error closing the file " + pFullPath + ": " + e.toString());
            }
        }
    }

    public void update(Observable o, Object a) {
        this.loadPreferences();
    }

    private final void loadPreferences() {
        String dirName = this.pref.getDirectoryName();
        this.directory = new File(dirName.trim());
        this.fileName = this.pref.getFileName();
        this.beginCut = this.pref.getBeginCut();
        this.endCut = this.pref.getEndCut();
        this.overridefname = this.pref.isOverrideFileName();
    }

    private final void writeLog(String text) {
        this.log.append(text);
        this.log.append("\n");
        this.log.setCaretPosition(this.log.getDocument().getLength() - 1);
    }

    public static void main(String[] args) {
        ArrayList<String> parms = new ArrayList<String>();
        parms.add("String");
        parms.add("String");
        parms.add("int");
        EntryPoint en = new EntryPoint();
        System.out.println(en.getSource());
    }
}

