/*
 * Decompiled with CFR 0.152.
 */
package fileedit;

import fileedit.CodeTemplatePanel;
import fileedit.Common;
import fileedit.ConfigurationInterface;
import fileedit.FileEditorConfiguration;
import fileedit.Preferences;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JTabbedPane;

public class ConfigurationDialog
extends JDialog
implements ActionListener {
    private Preferences pref = new Preferences();
    private JTabbedPane tab = new JTabbedPane();
    private JButton saveButton = new JButton("Save");
    private JButton closeButton = new JButton("Close");
    private ConfigurationInterface[] config = new ConfigurationInterface[]{new FileEditorConfiguration(this.pref), new CodeTemplatePanel(this.pref)};
    private WindowHandler windowHandler = new WindowHandler();

    public ConfigurationDialog() {
        super((Frame)null, "FileEdit Configuration", true);
        ((Component)this).setSize(new Dimension(600, 400));
        Container contentPane = this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 0));
        contentPane.setForeground(Common.FG_COLOR);
        contentPane.setBackground(Common.WPB_COLOR);
        this.tab.setForeground(Common.FG_COLOR);
        this.tab.setBackground(Common.WPB_COLOR);
        int x = 0;
        while (x < this.config.length) {
            this.tab.addTab(this.config[x].getTabTitle(), this.config[x].getTabIcon(), (Component)((Object)this.config[x]), this.config[x].getTabToolTip());
            ++x;
        }
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(this.saveButton);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(this.closeButton);
        Box mainPanel = Box.createVerticalBox();
        mainPanel.add(Box.createVerticalStrut(10));
        mainPanel.add(this.tab);
        mainPanel.add(Box.createVerticalStrut(10));
        mainPanel.add(buttonPanel);
        mainPanel.add(Box.createVerticalStrut(10));
        contentPane.add(Box.createHorizontalStrut(10));
        contentPane.add(mainPanel);
        contentPane.add(Box.createHorizontalStrut(10));
        this.saveButton.addActionListener(this);
        this.closeButton.addActionListener(this);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowHandler);
        this.pack();
    }

    public void actionPerformed(ActionEvent e) {
        Object src = e.getSource();
        if (src == this.saveButton) {
            this.save();
        } else if (src == this.closeButton) {
            this.windowHandler.windowClosing(new WindowEvent(this, 201));
        }
    }

    public boolean save() {
        int x = 0;
        while (x < this.config.length) {
            if (!this.config[x].savePreferences()) {
                this.tab.setSelectedIndex(x);
                return false;
            }
            ++x;
        }
        try {
            this.pref.save();
            x = 0;
            while (x < this.config.length) {
                this.config[x].resetSavePending();
                ++x;
            }
            Common.showMessage("Save", "Preferences were saved successfully", null);
            return true;
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(null, e.toString(), "Error saving preferences", 0);
            return false;
        }
    }

    public static void main(String[] args) {
        ConfigurationDialog ff = new ConfigurationDialog();
        ff.show();
    }

    private class WindowHandler
    extends WindowAdapter {
        WindowHandler() {
        }

        public void windowClosing(WindowEvent e) {
            boolean savePending = false;
            int x = 0;
            while (x < ConfigurationDialog.this.config.length) {
                if (ConfigurationDialog.this.config[x].isSavePending()) {
                    savePending = true;
                    break;
                }
                ++x;
            }
            if (savePending && Common.confirm("Save Pending", "Changes are pending.  Do you want to save before closing?", null) && !ConfigurationDialog.this.save()) {
                return;
            }
            ConfigurationDialog.this.dispose();
        }
    }
}

