simulate.exp <- function( n, rep.no ){
	
	
	m = (n + (n-1)*n/2 )*rep.no
	E = matrix(0, ncol = n, nrow= m)
	colnames(E) = letters[1:n]
	e.double = rep.no*n + 1
	
	for( i in seq(1, n-1)){
		for (j in seq(i+1, n)){
			for (r in seq(1, rep.no)){
				E[e.double, i ] = 1
				E[e.double, j ] = 1
				e.double = e.double+1
			}
			
		}
	}
	
	e.single = 1
	for( i in seq(1, n) ){
		for ( r.s in seq( 1, rep.no ) ){
			E[e.single, i] = 1
			e.single = e.single+1
		}
	}

	E
}


simulate.lem <- function( G, E, b, sigma, Y.no){
	
	n = ncol(G)
	m = nrow(E)
	betas =	sapply(1:Y.no, function(i){	be = abs(rnorm(n, 0, sd = sqrt(1/b))); names(be) = colnames(G); be } )
	
	epsilon = matrix( rnorm( m*Y.no, 0, sigma), ncol=Y.no)
	X = ( (E%*%G)>0)
	
	Y = X%*%betas + epsilon
	
	return( list( Y = Y, betas = betas, E = E, G=G))
}