score1 <- function( coll.model, Y, verbose){
	model=coll.model$G
	E=coll.model$E
	if (verbose)
		print(model)
	if (is.vector(Y) ){
		Y = matrix(Y, ncol = 1)
	}
	scores <- apply(Y, 2, mLL, G = model, E = E, verbose  =verbose )
	mLL = NULL
	beta = NULL
	c.vector = NULL
	b = NULL

	for (score in scores){
		mLL = c(mLL, score$mLL)
		beta = cbind(beta, score$beta)
		c.vector = c(c.vector, score$c)
		b  = c( b, score$b )
		
	}
	mLL.all = sum(mLL)
	
	list(mLL=mLL.all, beta=beta, sigma=sqrt(1/c.vector), b=b, c=c.vector, mLL.ys = mLL)
}


score <- function(coll.models, Y, verbose=TRUE, graphClass="graphNEL") {
	   
	
	results <- sapply(coll.models, score1, Y,  verbose) 
	
  	s <- unlist(results["mLL",])
  	beta  <- results["beta",]
	sigma     <- results["sigma",] 	  
	b = results["b",]
	cs = results["c",]
  	mLLs = results["mLL.ys",]
  	mLL.diff = NULL
	if(length(s) > 1){		
			mLL.sorted = sort(s, decreasing=TRUE)
			mLL.diff = mLL.sorted[1] - mLL.sorted[2]
			if(verbose){
				cat("(Marginal likelihood difference of best vs. second best model:", mLL.diff,")\n")
			}
  	}  
  	
 	# winning model
  	best <- which.max(s)       
  	winner <- coll.models[[best]]$G
  	diag(winner) <- 1  
  	beta.winner <- beta[[best]]
  	rownames(beta.winner)=colnames(winner)
  	sigma.winner <- sigma[[best]]
  	b.winner <- b[[best]]
  	c.winner <- cs[[best]]
  	mLLs.winner <- mLLs[[best]]
  	if(graphClass == "graphNEL"){
	  	gR <- new("graphAM",adjMat=winner,edgemode="directed")  
  		gR <- as(gR,"graphNEL")    
  	}else
  		gR = winner

	res <- list(graph = gR, mLL=s, beta = beta.winner, sigma = sigma.winner, b = b.winner, c = c.winner,  mLL.diff = mLL.diff, mLLs = mLLs.winner)
  	
  	return(res)  
}
 