
lem <- function(Y, E, Gs=NULL, inference="greedy", verbose=FALSE, collapse = TRUE){

#------------------------------
# Sanity checks               
if (!(inference %in% c( "exhaustive", "greedy","search") )) 
    stop("\nlem> argument 'inference' is not valid\n")

#------------------------------
# GREEDY                    
if(inference == "greedy"){
	# lem greedy works over uncollapsed models
    result <- lem.greedy(Y, E, initial=Gs[[1]], verbose=verbose)
    if (collapse){
		#the final result needs to be collapsed
		res.col = collapse.cycles(G=as( result$graph, "matrix"), beta=result$beta )
        result$graph = as(res.col$G,"graphNEL")
        result$beta = res.col$beta
     }	
}

#------------------------------
# EXHAUSTIVE SEARCH                       

else if (inference == "exhaustive"){ 
        GEs <- enumerateGEs(  E, verbose=verbose, collapse=collapse)		
        result <- score(GEs, Y,  verbose)	
}

#------------------------------
# Score all given models
else if (inference == "search"){    
        if (is.null(Gs)){
        		GEs <- enumerateGEs(E, verbose=verbose, collapse=collapse)
        }else{
        	
        		GEs = makeGEs(Gs, E, verbose= verbose, collapse=collapse)
        }
        if (length(GEs)>0){
        	result <- score(GEs, Y, verbose)
        }else{
        	result <-  list(graph = NULL, mLL=-Inf, beta = NULL, sigma = NULL, b = NULL, c = NULL,  mLL.diff = NULL, mLLs = NULL)
        }		
}


#------------------------------
# OUTPUT                       
return(result)

}
