#include <stdlib.h>
#include <stdio.h>
#include "../utilities/openglheader.h"
#include <GLFW/glfw3.h>

#include "../utilities/utilities.h"
#include "myheader.h"

GLFWwindow *mywindow;
char       redraw;

void myGLFWErrorHandler ( int error, const char *description )
{
  fprintf ( stderr, "GLFW error: %s\n", description );
  exit ( 1 );
} /*myGLFWErrorHandler*/

void ReshapeFunc ( GLFWwindow *win, int width, int height )
{
  ResizeMyWorld ( width, height );
  redraw = true;;
} /*ReshapeFunc*/

void DisplayFunc ( GLFWwindow *win )
{
  redraw = true;
} /*DisplayFunc*/

void Redraw ( GLFWwindow *win )
{
  RedrawMyWorld ();
  redraw = false;
  glfwSwapBuffers ( win );
} /*Redraw*/

void KeyboardFunc ( GLFWwindow *win, int key, int scancode, int action, int mods )
{
  if ( action == GLFW_PRESS || action == GLFW_REPEAT ) {
    switch ( key ) {
  case GLFW_KEY_ESCAPE:
      glfwSetWindowShouldClose ( win, 1 );
      break;
  default:
      break;
    }
  }
} /*KeyboardFunc*/

void CharFunc ( GLFWwindow *win, unsigned int charcode )
{
} /*CharFunc*/

void MouseFunc ( GLFWwindow *win, int button, int action, int mods )
{
} /*MouseFunc*/

void MotionFunc ( GLFWwindow *win, double x, double y )
{
} /*MotionFunc*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  glfwDestroyWindow ( mywindow );
} /*Cleanup*/

void Initialise ( int argc, char **argv )
{
  glfwSetErrorCallback ( myGLFWErrorHandler );
  if ( !glfwInit () )
    ExitOnError ( "glfwInit failed." );
  if ( !(mywindow = glfwCreateWindow ( 480, 360,
                                       "Aplikacja GLFW", NULL, NULL )) ) {
    glfwTerminate ();
    ExitOnError ( "glfwCreateWindow failed." );
  }
  glfwMakeContextCurrent ( mywindow );
  GetGLProcAddresses ( 4, 2 );
  glfwSetFramebufferSizeCallback ( mywindow, ReshapeFunc );
  glfwSetWindowRefreshCallback ( mywindow, DisplayFunc );
  glfwSetKeyCallback ( mywindow, KeyboardFunc );
  glfwSetCharCallback ( mywindow, CharFunc );
  glfwSetMouseButtonCallback ( mywindow, MouseFunc );
  glfwSetCursorPosCallback ( mywindow, MotionFunc );
  InitMyWorld ( argc, argv, 480, 360 );
  redraw = true;
} /*Initialise*/

void MessageLoop ( void )
{
  while ( !glfwWindowShouldClose ( mywindow ) ) {
    glfwWaitEvents ();
    if ( redraw )
      Redraw ( mywindow );
  }
} /*MessageLoop*/

int main ( int argc, char **argv )
{
  Initialise ( argc, argv );
  MessageLoop ();
  Cleanup ();
  glfwTerminate ();
  exit ( 0 );
} /*main*/
