#version 450 core

layout(local_size_x=1) in;

layout (std430,binding = 0) buffer RowsCols { uint  rc[]; } rc;
layout (std430,binding = 1) buffer Coeff    { float a[]; } a;
layout (std430,binding = 2) buffer Xvec     { float x[]; } x;
layout (std430,binding = 3) buffer Yvec     { float y[]; } y;

uniform uint m, dim;

#define r(i) rc.rc[i]
#define c(i) rc.rc[m+1+(i)]

void main ( void )
{
  uint  xi, yi, j, k, l;
  float s;

  xi = gl_GlobalInvocationID.x;
  yi = gl_GlobalInvocationID.y;
  k = xi*dim + yi;
  for ( j = r(xi), s = 0.0;  j < r(xi+1);  j++ ) {
    l = c(j);
    s += a.a[j] * x.x[l*dim + yi];
  }
  y.y[k] = s;
} /*main*/

