#version 450 core

layout(triangles) in;
layout(triangle_strip,max_vertices=3) out;

in GVertex {
    vec3 Position;
    vec2 TxtCoord;
    vec2 IrrTxtCoord;
  } In[];

out FVertex {
    vec3      Position;
    vec2      TxtCoord;
    vec2      IrrTxtCoord;
    vec3      Normal;
    flat vec3 TNormal;
  } Out;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse, opt;
    float C;
    vec3  colour;
  } ctl;

const vec2 txtc[3] = {vec2(1.0,0.0),vec2(0.0,1.0),vec2(0.0,0.0)};

void main ( void )
{
  int  i;
  vec3 v1, v2, nv;

  v1 = In[1].Position - In[0].Position;
  v2 = In[2].Position - In[0].Position;
  nv = normalize ( cross ( v1, v2 ) );
  for ( i = 0; i < 3; i++ ) {
    gl_PrimitiveID = ctl.first + gl_PrimitiveIDIn;
    gl_Position = gl_in[i].gl_Position;
    Out.Position = In[i].Position;
    if ( ctl.txts == 0 )
      Out.TxtCoord = In[i].TxtCoord;
    else
      Out.TxtCoord = txtc[i];
    Out.IrrTxtCoord = In[i].IrrTxtCoord;
    Out.Normal = Out.TNormal = nv;
    EmitVertex ();
  }
  EndPrimitive ();
} /*main*/

