#version 450 core

#define MAX_MATERIALS 20

layout(local_size_x=1) in;

layout(rgba32f,binding=1) uniform image2D  normal;
layout(r8i,binding=4)     uniform iimage2D matnum;

layout(rgba32f,binding=6) uniform image2D  glow0;
layout(rgba32f,binding=7) uniform image2D  glow1;

struct Material {
    vec4  emission0, emission1;
    vec4  diffref;
    vec4  specref;
    float shininess, wa, we;
    int   txtnum;
  };

uniform MatBlock {
    int mtn;
    Material mat[MAX_MATERIALS];
  } mat;

uniform int pass = 0;
uniform int ngf = 0;

const float mgf[663] =
  { /* sigma = 1 */
    0.3831031644, 0.2418428568, 0.0606257426, 0.0059798184,
    /* sigma = sqrt(2) */
    0.2763541975, 0.2174365006, 0.1058829014, 0.0318889802, 0.0059334031,
    0.0006811159,
    /* sigma = 2 */
    0.1976407387, 0.1748681285, 0.1211173542, 0.0656663991, 0.0278668439,
    0.0092553906, 0.0024055143,
    /* sigma = 2*sqrt(2) */
    0.1404261498, 0.1320037031, 0.1096478339, 0.0804801004, 0.0521974527,
    0.0299143416, 0.0151486907, 0.0067784693, 0.0026800548, 0.0009362786,
    /* sigma = 4 */
    0.0996536389, 0.0966033074, 0.0880011748, 0.0753325212, 0.0606001859,
    0.0458102477, 0.0325423048, 0.0217235432, 0.0136272853, 0.0080331146,
    0.0044499389, 0.0023164296, 0.0011331269,
    /* sigma = 4*sqrt(2) */
    0.0705715323, 0.0694802462, 0.0663065989, 0.0613360426, 0.0549969164,
    0.0477996265, 0.0402693136, 0.0328842160, 0.0260294071, 0.0199712181,
    0.0148527987, 0.0107071890, 0.0074817991, 0.0050675725, 0.0033270338,
    0.0021172772, 0.0013060550, 0.0007809232,
    /* sigma = 8 */
    0.0499449655, 0.0495567945, 0.0484102892, 0.0465580868, 0.0440834478,
    0.0410940514, 0.0377142385, 0.0340764781, 0.0303128686, 0.0265474214,
    0.0228897274, 0.0194304057, 0.0162385064, 0.0133608245, 0.0108228939,
    0.0086313057, 0.0067769230, 0.0052385556, 0.0039866996, 0.0029870220,
    0.0022033640, 0.0016001365, 0.0011440651, 0.0008053180, 0.0005580935,
    /* sigma = 8*sqrt(2) */
    0.0353313889, 0.0351937344, 0.0347839802, 0.0341116308, 0.0331921185,
    0.0320462151, 0.0306992523, 0.0291801914, 0.0275205909, 0.0257535236,
    0.0239124922, 0.0220303962, 0.0201385897, 0.0182660686, 0.0164388107,
    0.0146792879, 0.0130061531, 0.0114341008, 0.0099738872, 0.0086324917,
    0.0074133954, 0.0063169500, 0.0053408084, 0.0044803901, 0.0037293569,
    0.0030800754, 0.0025240503, 0.0020523147, 0.0016557669, 0.0013254511,
    0.0010527796, 0.0008296989, 0.0006488030, 0.0005034015, 0.0003875479,
    /* sigma = 16 */
    0.0249906981, 0.0249419516, 0.0247962820, 0.0245553874, 0.0242220615,
    0.0238001396, 0.0232944251, 0.0227105984, 0.0220551109, 0.0213350668,
    0.0205580943, 0.0197322129, 0.0188656955, 0.0179669325, 0.0170442989,
    0.0161060275, 0.0151600915, 0.0142140977, 0.0132751934, 0.0123499873,
    0.0114444849, 0.0105640411, 0.0097133268, 0.0088963121, 0.0081162629,
    0.0073757518, 0.0066766801, 0.0060203111, 0.0054073115, 0.0048378002,
    0.0043114024, 0.0038273069, 0.0033843253, 0.0029809521, 0.0026154233,
    0.0022857728, 0.0019898861, 0.0017255497, 0.0014904960, 0.0012824435,
    0.0010991318, 0.0009383511, 0.0007979673, 0.0006759411, 0.0005703438,
    0.0004793676, 0.0004013329, 0.0003346917, 0.0002780284,
    /* sigma = 16*sqrt(2) */
    0.0176730978, 0.0176558502, 0.0176042081, 0.0175184735, 0.0173991461,
    0.0172469186, 0.0170626704, 0.0168474585, 0.0166025078, 0.0163291997,
    0.0160290585, 0.0157037377, 0.0153550049, 0.0149847255, 0.0145948465,
    0.0141873793, 0.0137643825, 0.0133279450, 0.0128801689, 0.0124231529,
    0.0119589764, 0.0114896843, 0.0110172724, 0.0105436744, 0.0100707495,
    0.0096002713, 0.0091339183, 0.0086732657, 0.0082197779, 0.0077748035,
    0.0073395709, 0.0069151853, 0.0065026275, 0.0061027537, 0.0057162961,
    0.0053438652, 0.0049859530, 0.0046429368, 0.0043150842, 0.0040025584,
    0.0037054247, 0.0034236567, 0.0031571436, 0.0029056972, 0.0026690598,
    0.0024469108, 0.0022388753, 0.0020445303, 0.0018634130, 0.0016950269,
    0.0015388489, 0.0013943354, 0.0012609284, 0.0011380610, 0.0010251621,
    0.0009216615, 0.0008269938, 0.0007406022, 0.0006619415, 0.0005904813,
    0.0005257080, 0.0004671270, 0.0004142640, 0.0003666666, 0.0003239048,
    0.0002855719, 0.0002512843, 0.0002206821, 0.0001934286,
    /* sigma = 32 */
    0.0124984914, 0.0124923906, 0.0124741061, 0.0124436914, 0.0124012353,
    0.0123468616, 0.0122807286, 0.0122030280, 0.0121139841, 0.0120138528,
    0.0119029206, 0.0117815026, 0.0116499417, 0.0115086063, 0.0113578895,
    0.0111982062, 0.0110299922, 0.0108537013, 0.0106698040, 0.0104787853,
    0.0102811420, 0.0100773813, 0.0098680183, 0.0096535738, 0.0094345722,
    0.0092115396, 0.0089850015, 0.0087554808, 0.0085234961, 0.0082895595,
    0.0080541750, 0.0078178365, 0.0075810267, 0.0073442151, 0.0071078568,
    0.0068723911, 0.0066382405, 0.0064058095, 0.0061754836, 0.0059476287,
    0.0057225901, 0.0055006923, 0.0052822382, 0.0050675091, 0.0048567640,
    0.0046502402, 0.0044481528, 0.0042506948, 0.0040580376, 0.0038703311,
    0.0036877044, 0.0035102658, 0.0033381037, 0.0031712871, 0.0030098664,
    0.0028538740, 0.0027033252, 0.0025582189, 0.0024185386, 0.0022842534,
    0.0021553185, 0.0020316764, 0.0019132580, 0.0017999833, 0.0016917622,
    0.0015884958, 0.0014900772, 0.0013963920, 0.0013073199, 0.0012227349,
    0.0011425065, 0.0010665002, 0.0009945787, 0.0009266021, 0.0008624289,
    0.0008019167, 0.0007449225, 0.0006913037, 0.0006409182, 0.0005936251,
    0.0005492850, 0.0005077609, 0.0004689177, 0.0004326233, 0.0003987486,
    0.0003671675, 0.0003377578, 0.0003104004, 0.0002849805, 0.0002613870,
    0.0002395128, 0.0002192550, 0.0002005146, 0.0001831970, 0.0001672118,
    0.0001524724, 0.0001388965,
    /* sigma = 32*sqrt(2) */
    0.0088379009, 0.0088357435, 0.0088292747, 0.0088185038, 0.0088034466,
    0.0087841251, 0.0087605675, 0.0087328082, 0.0087008874, 0.0086648517,
    0.0086247530, 0.0085806492, 0.0085326038, 0.0084806857, 0.0084249688,
    0.0083655324, 0.0083024606, 0.0082358421, 0.0081657702, 0.0080923422,
    0.0080156599, 0.0079358285, 0.0078529569, 0.0077671574, 0.0076785453,
    0.0075872386, 0.0074933581, 0.0073970267, 0.0072983692, 0.0071975125,
    0.0070945847, 0.0069897151, 0.0068830341, 0.0067746728, 0.0066647624,
    0.0065534347, 0.0064408210, 0.0063270524, 0.0062122595, 0.0060965718,
    0.0059801179, 0.0058630251, 0.0057454191, 0.0056274237, 0.0055091612,
    0.0053907512, 0.0052723113, 0.0051539566, 0.0050357994, 0.0049179491,
    0.0048005124, 0.0046835926, 0.0045672899, 0.0044517010, 0.0043369195,
    0.0042230349, 0.0041101336, 0.0039982980, 0.0038876068, 0.0037781348,
    0.0036699532, 0.0035631290, 0.0034577255, 0.0033538022, 0.0032514143,
    0.0031506136, 0.0030514476, 0.0029539602, 0.0028581915, 0.0027641776,
    0.0026719512, 0.0025815412, 0.0024929728, 0.0024062678, 0.0023214447,
    0.0022385185, 0.0021575008, 0.0020784003, 0.0020012225, 0.0019259700,
    0.0018526424, 0.0017812367, 0.0017117472, 0.0016441657, 0.0015784814,
    0.0015146814, 0.0014527507, 0.0013926720, 0.0013344261, 0.0012779921,
    0.0012233473, 0.0011704674, 0.0011193266, 0.0010698977, 0.0010221524,
    0.0009760611, 0.0009315932, 0.0008887171, 0.0008474006, 0.0008076104,
    0.0007693129, 0.0007324737, 0.0006970582, 0.0006630313, 0.0006303575,
    0.0005990013, 0.0005689271, 0.0005400990, 0.0005124813, 0.0004860385,
    0.0004607351, 0.0004365358, 0.0004134056, 0.0003913099, 0.0003702144,
    0.0003500851, 0.0003308887, 0.0003125923, 0.0002951633, 0.0002785702,
    0.0002627815, 0.0002477666, 0.0002334957, 0.0002199393, 0.0002070688,
    0.0001948563, 0.0001832746, 0.0001722972, 0.0001618981, 0.0001520525,
    0.0001427359, 0.0001339247, 0.0001255961, 0.0001177280, 0.0001102989,
    0.0001032882, 0.0000966758,
    /* sigma = 64 */
    0.0062498553, 0.0062490924, 0.0062468044, 0.0062429929, 0.0062376607,
    0.0062308117, 0.0062224509, 0.0062125845, 0.0062012195, 0.0061883644,
    0.0061740284, 0.0061582220, 0.0061409567, 0.0061222449, 0.0061021003,
    0.0060805372, 0.0060575713, 0.0060332191, 0.0060074979, 0.0059804261,
    0.0059520231, 0.0059223090, 0.0058913047, 0.0058590322, 0.0058255140,
    0.0057907738, 0.0057548355, 0.0057177242, 0.0056794655, 0.0056400857,
    0.0055996118, 0.0055580711, 0.0055154920, 0.0054719030, 0.0054273333,
    0.0053818125, 0.0053353709, 0.0052880389, 0.0052398474, 0.0051908276,
    0.0051410112, 0.0050904299, 0.0050391160, 0.0049871016, 0.0049344193,
    0.0048811017, 0.0048271816, 0.0047726919, 0.0047176653, 0.0046621348,
    0.0046061333, 0.0045496936, 0.0044928485, 0.0044356305, 0.0043780723,
    0.0043202062, 0.0042620642, 0.0042036783, 0.0041450802, 0.0040863012,
    0.0040273723, 0.0039683243, 0.0039091876, 0.0038499921, 0.0037907674,
    0.0037315427, 0.0036723466, 0.0036132073, 0.0035541526, 0.0034952097,
    0.0034364053, 0.0033777655, 0.0033193158, 0.0032610814, 0.0032030865,
    0.0031453550, 0.0030879101, 0.0030307744, 0.0029739696, 0.0029175172,
    0.0028614377, 0.0028057511, 0.0027504767, 0.0026956330, 0.0026412379,
    0.0025873088, 0.0025338621, 0.0024809137, 0.0024284788, 0.0023765718,
    0.0023252066, 0.0022743962, 0.0022241531, 0.0021744889, 0.0021254148,
    0.0020769410, 0.0020290774, 0.0019818329, 0.0019352159, 0.0018892341,
    0.0018438947, 0.0017992041, 0.0017551681, 0.0017117919, 0.0016690802,
    0.0016270369, 0.0015856655, 0.0015449688, 0.0015049492, 0.0014656084,
    0.0014269475, 0.0013889674, 0.0013516681, 0.0013150494, 0.0012791104,
    0.0012438498, 0.0012092660, 0.0011753568, 0.0011421196, 0.0011095514,
    0.0010776487, 0.0010464079, 0.0010158246, 0.0009858946, 0.0009566127,
    0.0009279740, 0.0008999730, 0.0008726038, 0.0008458604, 0.0008197364,
    0.0007942254, 0.0007693204, 0.0007450145, 0.0007213005, 0.0006981707,
    0.0006756177, 0.0006536336, 0.0006322106, 0.0006113404, 0.0005910148,
    0.0005712256, 0.0005519641, 0.0005332220, 0.0005149906, 0.0004972610,
    0.0004800247, 0.0004632726, 0.0004469961, 0.0004311861, 0.0004158338,
    0.0004009302, 0.0003864664, 0.0003724335, 0.0003588225, 0.0003456245,
    0.0003328307, 0.0003204323, 0.0003084204, 0.0002967863, 0.0002855213,
    0.0002746169, 0.0002640645, 0.0002538556, 0.0002439818, 0.0002344347,
    0.0002252063, 0.0002162884, 0.0002076728, 0.0001993518, 0.0001913175,
    0.0001835622, 0.0001760782, 0.0001688581, 0.0001618946, 0.0001551804,
    0.0001487082, 0.0001424713, 0.0001364626, 0.0001306754, 0.0001251031,
    0.0001197392, 0.0001145773, 0.0001096111, 0.0001048346, 0.0001002418,
    0.0000958268, 0.0000915839, 0.0000875074, 0.0000835920, 0.0000798323,
    0.0000762231, 0.0000727593, 0.0000694360};

const int mgfi[14] =
    { 0, 4, 10, 17, 27, 40, 58, 83, 118, 167, 236, 333, 470, 663 };

ivec2 wh;

vec4 GetInputColour ( ivec2 xy )
{
  int   mtn;
  float depth;
  vec3  em;

  if ( xy.x < 0 || xy.x >= wh.x || xy.y < 0 || xy.y >= wh.y )
    return vec4 ( 0.0, 0.0, 0.0, 1.0 );
  if ( pass <= 0 ) {
    depth = imageLoad ( normal, xy ).w;
    if ( (mtn = imageLoad ( matnum, xy ).x) < 0 )
      return vec4 ( 0.0, 0.0, 0.0, 1.0 );
    else {
      em = mat.mat[mtn].emission0.rgb;
      if ( em.r > 0.0 || em.g > 0.0 || em.b > 0.0 )
        return vec4 ( mat.mat[mtn].emission0.rgb, depth );
      else
        return vec4 ( 0.0, 0.0, 0.0, 1.0 );
    }
  }
  else if ( (pass & 0x01) == 0 )
    return imageLoad ( glow0, xy );
  else
    return imageLoad ( glow1, xy );
} /*GetInputColour*/

void main ( void )
{
  ivec2 xy;
  vec4  Colour, c1, c2;
  int   i, j;
  float depth;

  wh = imageSize ( matnum );
  xy = ivec2 ( int(gl_GlobalInvocationID.x), int(gl_GlobalInvocationID.y) );
  Colour = GetInputColour ( xy );
  depth = Colour.w;
  if ( pass < 0 ) {
    imageStore ( glow1, xy, Colour );
    imageStore ( glow0, xy, Colour );
    return;
  }
  Colour.rgb *= mgf[mgfi[ngf]];
  if ( (pass & 0x01) == 0 ) {
    for ( i = 1, j = mgfi[ngf]+1;  j < mgfi[ngf+1];  i++, j++ ) {
      c1 = GetInputColour ( xy + ivec2(i,0) );
      if ( c1.w < depth ) depth = c1.w;
      c2 = GetInputColour ( xy - ivec2(i,0) );
      if ( c2.w < depth ) depth = c2.w;
      Colour.rgb += mgf[j] * ( c1.rgb + c2.rgb );
    }
    Colour.w = depth;
    imageStore ( glow1, xy, Colour );
  }
  else {
    for ( i = 1, j = mgfi[ngf]+1;  j < mgfi[ngf+1];  i++, j++ ) {
      c1 = GetInputColour ( xy + ivec2(0,i) );
      if ( c1.w < depth ) depth = c1.w;
      c2 = GetInputColour ( xy - ivec2(0,i) );
      if ( c2.w < depth ) depth = c2.w;
      Colour.rgb += mgf[j] * ( c1.rgb + c2.rgb );
    }
    Colour.w = depth;
    imageStore ( glow0, xy, Colour );
  }
} /*main*/

