#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "../utilities/openglheader.h"
#include "../utilities/utilities.h"
#include "trans.h"
#include "lights.h"
#include "balance.h"
#include "scanner.h"
#include "readsmf.h"
#include "myscene.h"
#include "candle.h"

/*#define fn  "candle0.smf"*/
#define fn1 "../smf/candle1.smf"
#define fn2 "../smf/flame.smf"

#define SCF 0.1

static const float diffr0[4] = { 0.48, 0.36, 0.1, 1.0 };
static const float specr0[4] = { 0.2, 0.2, 0.2, 1.0 };
static const float diffr1[4] = { 0.8, 0.8, 0.8, 1.0 };
static const float specr1[4] = { 0.2, 0.2, 0.2, 1.0 };
static const float emission[4] = { 1.0, 1.0, 0.9, 1.0 };

void EnterCandle ( BalanceElements *belem, SceneObject *obj, MatBl *matbl )
{
  GLfloat  *vc;
  GLint    *trv;
  GLushort *trvs;
  GLubyte  *trvb;
  int      i;
  size_t   s;

  if ( ReadSMFFile ( fn1, &obj->nvert, &vc, &obj->ntr, &trv ) ) {
    strcpy ( obj->name, "candle" );
    printf ( "%s: nvert = %d, ntr = %d\n", fn1, obj->nvert, obj->ntr );
    obj->mat0 = SetupMaterial ( matbl, -1, diffr0, specr0,
                                10.0, 1.0, 1.0, GL_INVALID_INDEX );
    SetupMaterial ( matbl, -1, diffr1, specr1,
                    10.0, 1.0, 1.0, GL_INVALID_INDEX );
    glGenVertexArrays ( 1, &obj->vao );
    glBindVertexArray ( obj->vao );
    glGenBuffers ( 2, obj->vbo );
    glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
    glBufferData ( GL_ARRAY_BUFFER, obj->nvert*3*sizeof(GLfloat),
                   vc, GL_STATIC_DRAW );
    glEnableVertexAttribArray ( 0 );
    glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                            3*sizeof(GLfloat), (GLvoid*)0 );
    glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, obj->vbo[1] );
    trvb = (GLubyte*)trv;
    if ( obj->nvert < RESTART_IND_UBYTE ) {
      obj->index_type = GL_UNSIGNED_BYTE;
      for ( i = 0; i < 3*obj->ntr; i++ )
        trvb[i] = (GLubyte)trv[i];
    }
    else if ( obj->nvert < RESTART_IND_USHORT ) {
      obj->index_type = GL_UNSIGNED_SHORT;
      trvs = (GLushort*)trv;
      for ( i = 0; i < 3*obj->ntr; i++ )
        trvs[i] = (GLushort)trv[i];
    }
    else
      obj->index_type = GL_UNSIGNED_INT;
    s = INDSIZE(obj->index_type);
    glBufferData ( GL_ELEMENT_ARRAY_BUFFER, 3*obj->ntr*s, trv, GL_STATIC_DRAW );
    glDisableVertexAttribArray ( 1 );
    glDisableVertexAttribArray ( 2 );
    glBindVertexArray ( 0 );
    obj->redraw = DrawCandle;
    obj->destroy = DestroySceneObject;
    obj->active = true;
    BeginEnteringObjTriangles ( belem, obj, 0, obj->nvert, obj->ntr,
                                CANDLE_ELD/SCF );
    EnterTriangles ( belem, GL_TRIANGLES, obj->nvert, (GLfloat(*)[3])vc,
                     NULL, 3*(obj->ntr-80), obj->index_type,
                     (GLvoid*)&trvb[3*140*s], obj->mat0, false );
    EnterTriangles ( belem, GL_TRIANGLES, 0, NULL, NULL,
                     3*80, obj->index_type,
                     (GLvoid*)&trvb[3*60*s], obj->mat0+1, false );
    EndEnteringObjTriangles ( belem );
    free ( trv );
    free ( vc );
    ExitIfGLError ( "EnterCandle" );
  }
  else
    ExitOnError ( "EnterCandle" );
} /*EnterCandle*/

void SetCandlePosition ( SceneObject *obj, float x, float y, float z )
{
  M4x4Scalef ( obj->mm, SCF, SCF, SCF );
  M4x4TranslateMf ( obj->mm, x, y, z );
} /*SetCandlePosition*/

void DrawCandle ( GLuint prog_id, SceneObject *obj,
                  TransBl *trans, MatBl *mat )
{
  LoadMMatrix ( trans, obj->mm );
  glUseProgram ( prog_id );
  glVertexAttrib2f ( 1, 0.0, 0.0 );
  glBindVertexArray ( obj->vao );
  ChooseMaterial ( mat, obj->mat0 );
  glDrawElements ( GL_TRIANGLES, 3*(obj->ntr-80), obj->index_type,
                   (GLvoid*)(3*80*INDSIZE(obj->index_type)) );
  ChooseMaterial ( mat, obj->mat0+1 );
  glDrawElements ( GL_TRIANGLES, 3*80, obj->index_type,
                   (GLvoid*)(3*60*INDSIZE(obj->index_type)) );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawCandle" );
} /*DrawCandle*/

/* ////////////////////////////////////////////////////////////////////////// */
void EnterCandleFlame ( BalanceElements *belem, SceneObject *obj, MatBl *matbl )
{
  GLfloat  *vc;
  GLint    *trv;
  GLushort *trvs;
  GLubyte  *trvb;
  int      i;
  size_t   s;

  if ( ReadSMFFile ( fn2, &obj->nvert, &vc, &obj->ntr, &trv ) ) {
    strcpy ( obj->name, "flame" );
    printf ( "%s: nv = %d, ntr = %d\n", fn2, obj->nvert, obj->ntr );
    obj->mat0 = SetupMaterial ( matbl, -1, diffr1, specr1,
                    10.0, 1.0, 1.0, GL_INVALID_INDEX );
    SetMaterialEmission ( matbl, obj->mat0, emission, emission );
    glGenVertexArrays ( 1, &obj->vao );
    glBindVertexArray ( obj->vao );
    glGenBuffers ( 2, obj->vbo );
    glBindBuffer ( GL_ARRAY_BUFFER, obj->vbo[0] );
    glBufferData ( GL_ARRAY_BUFFER, obj->nvert*3*sizeof(GLfloat),
                   vc, GL_STATIC_DRAW );
    glEnableVertexAttribArray ( 0 );
    glVertexAttribPointer ( 0, 3, GL_FLOAT, GL_FALSE,
                            3*sizeof(GLfloat), (GLvoid*)0 );
    glBindBuffer ( GL_ELEMENT_ARRAY_BUFFER, obj->vbo[1] );
    trvb = (GLubyte*)trv;
    if ( obj->nvert < RESTART_IND_UBYTE ) {
      obj->index_type = GL_UNSIGNED_BYTE;
      for ( i = 0; i < 3*obj->ntr; i++ )
        trvb[i] = (GLubyte)trv[i];
    }
    else if ( obj->nvert < RESTART_IND_USHORT ) {
      obj->index_type = GL_UNSIGNED_SHORT;
      trvs = (GLushort*)trv;
      for ( i = 0; i < 3*obj->ntr; i++ )
        trvs[i] = (GLushort)trv[i];
    }
    else
      obj->index_type = GL_UNSIGNED_INT;
    s = INDSIZE(obj->index_type);
    glBufferData ( GL_ELEMENT_ARRAY_BUFFER, 3*obj->ntr*s, trv, GL_STATIC_DRAW );
    glDisableVertexAttribArray ( 1 );
    glDisableVertexAttribArray ( 2 );
    glBindVertexArray ( 0 );
    obj->redraw = DrawCandleFlame;
    obj->destroy = DestroySceneObject;
    obj->active = true;
    free ( trv );
    free ( vc );
    ExitIfGLError ( "EnterCandleFlame" );
  }
  else
    ExitOnError ( "EnterCandleFlame" );
} /*EnterCandleFlame*/

void DrawCandleFlame ( GLuint prog_id, SceneObject *obj,
                       TransBl *trans, MatBl *mat )
{
  LoadMMatrix ( trans, obj->mm );
  glUseProgram ( prog_id );
  glVertexAttrib2f ( 1, 0.0, 0.0 );
  glBindVertexArray ( obj->vao );
  ChooseMaterial ( mat, obj->mat0 );
  glDrawElements ( GL_TRIANGLES, 3*60, obj->index_type, (GLvoid*)0 );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawCandleFlame" );
} /*DrawCandleFlame*/

void GetCandleFlamePosition ( SceneObject *obj, GLfloat *pos )
{
  GLfloat p0[4] = {0.0, 0.0, 1.41, 1.0};

  M4x4MultMVf ( pos, obj->mm, p0 );
} /*GetCandleFlamePosition*/

static GLfloat amb1[4] = { 0.003, 0.003, 0.0025, 0.0 },
               dir1[4] = { 0.6, 0.6, 0.52, 0.0 },
               atn1[3] = { 0.2, 0.0, 1.0 };
        
void SetCandleFlameOnOff ( SceneObject *obj, TransBl *trans, MatBl *mat,
                           LightBl *light, int l, char on )
{
  GLfloat pos[4], zero[4] = { 0.0, 0.0, 0.0, 0.0 };

  if ( on ) {
    GetCandleFlamePosition ( obj, pos );
    SetLightAmbient ( light, l, amb1 );
    SetLightDiffuse ( light, l, dir1 );
    SetLightAttenuation ( light, l, atn1 );
    SetLightPosition ( light, l, pos );
    SetupShadowTxtTransformations ( light, l, pos, RS );
    SetMaterialEmission ( mat, obj->mat0, emission, emission );
  }
  else
    SetMaterialEmission ( mat, obj->mat0, zero, zero );
} /*SetCandleFlameOnOff*/

