#version 450 core

layout(local_size_x=1) in;

layout(std430,binding=1) buffer FFBlockRCi{ uint rc[]; } rci;
layout(std430,binding=2) buffer FFBlockAi { float a[]; } ai;
layout(std430,binding=3) buffer FFBlockRC { uint rc[]; } rc;
layout(std430,binding=4) buffer FFBlockA  { float a[]; } a;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

void main ( void )
{
  uint i;

  i = gl_GlobalInvocationID.x;
  switch ( ctl.stage ) {
case 0:
    rc.rc[ctl.H+i] = rci.rc[i] + ctl.nnz;
    return;
case 1:
    rc.rc[ctl.H+1+ctl.nnz+i] = rci.rc[ctl.mi+1+i];
    a.a[ctl.nnz+i] = ai.a[i];
    return;
default:
    return;
  }
} /*main*/

