#version 450 core

#define RESTART_IND_UINT 0xFFFFFFFF

layout(local_size_x=1) in;

layout(binding=0,r32ui) uniform uimage2D fftxt;

layout(std430,binding=7) buffer FFPixBuf { uint pix[]; } pxbuf;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

void main ( void )
{
  ivec2 xy;
  uint z, m;

  xy = ivec2 ( gl_GlobalInvocationID.xy );
  z = uint ( xy.y*gl_NumWorkGroups.x + xy.x );
  m = imageLoad ( fftxt, xy ).x;
  pxbuf.pix[ctl.p0+z] = m != RESTART_IND_UINT ?
          m : imageLoad ( fftxt, xy + ivec2(0,gl_NumWorkGroups.y) ).x;
} /*main*/

