#version 450 core

layout(triangles) in;
layout(triangle_strip,max_vertices=3) out;

in GVertex {
    vec3 WPosition;  
    vec2 TexCoord;  
  } In[];

out FVertex {
    vec3      WPosition;
    vec2      TxtCoord;
    vec3      Normal;
    flat vec3 TNormal;
  } Out;

void main ( void )
{
  int  i;
  vec3 v1, v2, nv;

  v1 = In[1].WPosition - In[0].WPosition;
  v2 = In[2].WPosition - In[0].WPosition;
  nv = normalize ( cross ( v1, v2 ) );
  for ( i = 0; i < 3; i++ ) {
    gl_Position = gl_in[i].gl_Position;
    gl_PrimitiveID = gl_PrimitiveIDIn;
    Out.WPosition = In[i].WPosition;
    Out.TxtCoord = In[i].TexCoord;
    Out.Normal = Out.TNormal = nv;
    EmitVertex ();
  }
  EndPrimitive ();
} /*main*/

