
/* Makrodefinicja HIRES powoduje wybranie wiekszej rozdzielczosci    */
/* obrazow uzywanych do obliczania wspolczynnikow ksztaltu - 36 x 36 */
/* i 36 x 18, zamiast 32 x 32 i 32 x 16. Jej wprowadzenie lub        */
/* usuniecie musi byc dokonane jednoczesnie z wprowadzeniem lub      */
/* usunieciem w szaderach bff0.comp, bff3.comp i bff4.comp.          */

#define HIRES

#ifdef HIRES
#define FFTXTSIZE     36
#define FFHSIZE       18
#define CF             1.54294            /* wynik optymalizacji */
#else
#define FFTXTSIZE     32
#define FFHSIZE       16
#define CF             1.54278            /* wynik optymalizacji */
#endif
#define FFTXTPIX       (3*FFTXTSIZE*FFTXTSIZE)
#define FS             ((float)FFTXTSIZE)  /* FFTXSIZE float */
#define HS             (0.5*FS)            /* polowa FFTXTSIZE */
#define NFFTRUOFFS     2
#define FFBLOCKSIZE 1024

#define NCTLNAMES   17
#define CTL_STAGE    0
#define CTL_STEP     1
#define CTL_WIDTH    2
#define CTL_HEIGHT   3
#define CTL_N        4
#define CTL_H        5
#define CTL_NROWS    6
#define CTL_NCOLS    7
#define CTL_FIRST    8
#define CTL_TXTS     9
#define CTL_P0      10
#define CTL_NELEM   11
#define CTL_MI      12
#define CTL_NNZ     13
#define CTL_REVERSE 14
#define CTL_C       15
#define CTL_COLOUR  16

#define BUF_VERTPOS belem->tvbo[0]
#define BUF_ELIND   belem->tvbo[1]
#define BUF_TXB     belem->tvbo[2]
#define BUF_TXC     belem->tvbo[3]
#define BUF_VARBUF  belem->tvbo[4]
#define BUF_CP      belem->tvbo[5]
#define BUF_PRS     belem->tvbo[6]
#define BUF_UCTL    belem->tvbo[7]
#define BUF_ABUF    belem->tvbo[8]
#define BUF_OBJID   belem->tvbo[9]
#define BUF_TRNV    belem->tvbo[10]
#define BUF_MATBUF  belem->tvbo[11]
#define BUF_ALBMAT  belem->tvbo[12]
#define BUF_LE      belem->tvbo[13]
#define BUF_L0      belem->tvbo[14]
#define BUF_L1      belem->tvbo[15]
#define BUF_VMAP    belem->tvbo[16]
#define BUF_TBUF    belem->tvbo[17]

#define MACROEL_DSIZE 5

/*#define DEBUG_IMAGE*/

void CTLUniformi ( BalanceElements *belem, int n, GLint value );
void CTLUniformui ( BalanceElements *belem, int n, GLuint value );
void CTLUniformf ( BalanceElements *belem, int n, GLfloat value );
void CTLUniform3fv ( BalanceElements *belem, int n, const GLfloat value[3] );

