
#include "../utilities/GPUsparsemat.h"

/* takie same jak w app4struct.h */
#define ROPT_TRCLASS1   6
#define ROPT_TRCLASS2   7
#define ROPT_TRCLASS3   8
#define ROPT_ELEMCP     9
#define ROPT_MACROEL   10

#define MAX_OBJECTS 20

#define MNNVECT 1.0e-10

#define RESTART_IND_UBYTE        0xFF
#define RESTART_IND_USHORT     0xFFFF
#define RESTART_IND_UINT   0xFFFFFFFF

#define INDSIZE(it) (it == GL_UNSIGNED_BYTE ? sizeof(GLubyte) :\
  (GL_UNSIGNED_SHORT ? sizeof(GLushort) : sizeof(GLuint)))

#define NFFVP       5
#define NVIEWPORTS  2*NFFVP

typedef struct SceneObject *SceneObjPtr;
typedef struct BalanceObject *BalanceObjPtr;

typedef void (*RedrawObject)( GLuint prog_id, SceneObjPtr obj,
                              TransBl *trans, MatBl *mat );
typedef void (*DestroyObject)( SceneObjPtr obj );

typedef struct FFTransBl {
    GLuint  fftrbuf;
    GLfloat mm[16], pm[NVIEWPORTS][16], vpm[NVIEWPORTS][16];
  } FFTransBl;

typedef struct TriangDesc {
    GLuint  ind[3];
    GLint   matnum, trp;
    GLfloat nvect[3];
  } TriangDesc;

typedef struct TriangPatch {
    int   objid;
    int   nvclass, nvert, ftr, ntr;
    float x0, y0, w, h;
  } TriangPatch;

typedef struct SceneObject {
    SceneObjPtr   previnst;
    BalanceObjPtr bobj;
    char          name[20];
    GLuint        vao, vbo[3];
    int           nvert, ntr;
    GLenum        index_type;
    GLfloat       mm[16];
    int           mat0, nmat, txt0;
    RedrawObject  redraw;
    DestroyObject destroy;
    char          active;
  } SceneObject;

typedef struct BalanceObject {
    SceneObjPtr obj;
    int         cnvert, ftrdesc, cntr, ntrpatch;
    GLint       txts;
    GLfloat     *vertpos, *txc, *txb;
    TriangDesc  *trdesc;
    TriangPatch *trpatch;
    float       eld;
    GLfloat     mmti[16];
  } BalanceObject;

#define NBEBUFFERS 18

typedef struct {
    BalanceObject   objtab[MAX_OBJECTS], *current;
    int             nobj, ntrpatch, ntr, nvert, nelem, nmacroelem;
    float           ffnear, fffar;
    GLfloat         *vertpos, *txc, *txb;
    TriangDesc      *trdesc;
    TriangPatch     *trpatch;
    GLuint          tvao, tvbo[NBEBUFFERS];
    GLuint          irrtxt, fftxt[2];
    GLsizei         irrtxt_width, irrtxt_height;
    FFTransBl       fftr;
    GPUSparseMatrix avgmat, ffmat;
    GLuint          *VarMap, *VarBuf, *ObjIdBuf;
  } BalanceElements;

/* ////////////////////////////////////////////////////////////////////////// */
void LoadBalanceShaders ( void );
void DeleteBalancePrograms ( void );

/* ////////////////////////////////////////////////////////////////////////// */
void BeginEnteringBalanceElements ( BalanceElements *belem,
                                    float fffar, float ffnear );
void EndEnteringBalanceElements ( BalanceElements *belem );

BalanceObject *BeginEnteringObjTriangles ( BalanceElements *belem,
                                           SceneObject *obj, GLint txts,
                                           int nvert, int ntr, float eld );
void EnterTriangles ( BalanceElements *belem, GLenum mode,
                      int nvert, GLfloat vpos[][3], GLfloat txc[][2],
                      int nind, GLenum itype, GLvoid *index, GLint matnum,
                      char onepatch );
void EndEnteringObjTriangles ( BalanceElements *belem );

void EnterNewObjElemInstance ( BalanceElements *belem, SceneObject *inst );

void EnterObjectCopy ( BalanceElements *belem,
                       SceneObject *object, SceneObject *copy );

void DestroySceneObject ( SceneObject *obj );
void DeleteBalanceElements ( BalanceElements *belem );

/* ////////////////////////////////////////////////////////////////////////// */
void ComputeFormFactors ( BalanceElements *belem );

char ComputeLightBalance ( BalanceElements *belem, TransBl *trans, int niter );
void DrawRadianceElements ( BalanceElements *belem, TransBl *trans );

/* ////////////////////////////////////////////////////////////////////////// */
void DrawTrClass ( BalanceElements *belem, TransBl *trans, char ropt );
void DebugDrawTrClass ( BalanceElements *belem, BalanceObject *obj, TransBl *trans,      
                       GLuint program_id, GLint colourloc, int t );
void DrawElemCPoints ( BalanceElements *belem, TransBl *trans, int el );

void BindElemTextures ( BalanceElements *belem );
void _GetElCPNV ( BalanceElements *belem, int i,
                  GLfloat cp[3], GLfloat nv[3] );

