#version 450 core

#define LGT 0.02

layout(std430,binding=0) buffer VarBuf { uvec4 tvar[]; } vbuf;
layout(std430,binding=4) buffer CPointBuf { vec4 cp[]; } cpbuf;
layout(std430,binding=10) buffer TrNormal { vec3 nv[]; } nvbuf;

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm, vpmi;
    vec4 eyepos;
    vec4 viewport;
  } trb;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

void main ( void )
{
  int  i;
  vec4 p;
  vec3 nv;

  i = ctl.first + gl_InstanceID;
  p = trb.mm * vec4(cpbuf.cp[i].xyz,1.0);
  if ( gl_VertexID == 0 )
    gl_Position = trb.vpm * p;
  else {
    i = int(vbuf.tvar[i].y);
    nv = normalize(mat3(trb.mmti) * nvbuf.nv[i]);
    gl_Position = trb.vpm * (p + vec4(LGT*nv,0));
  }
} /*main*/

