#version 450 core

#define MAX_TEXTURES   4
#define MAX_MATERIALS 20

in vec2 TxtCoord;

layout(std430,binding=0) buffer VarBuf { uvec4 tvar[]; } vbuf;
layout(std430,binding=6) buffer AlBuf { vec4 a[]; } abuf;
layout(std430,binding=11) buffer MatBuf { int matnum[]; } mbuf;

layout(binding=0) uniform sampler2D tex[MAX_TEXTURES];

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

struct Material {
    vec4  emission0, emission1;
    vec4  diffref;
    vec4  specref;
    float shininess, wa, we;
    int   txtnum;
  };

uniform MatBlock {
    int mtn;
    Material mat[MAX_MATERIALS];
  } mat;

void main ( void )
{
  int x, y, z, n;
  
  x = int(gl_FragCoord.x);  y = int(gl_FragCoord.y);
  z = y*ctl.width + x;
  vbuf.tvar[z] = uvec4 ( 1, ctl.first+gl_PrimitiveID, 0, 0 );
  n = mbuf.matnum[ctl.first+gl_PrimitiveID];
  if ( mat.mat[n].txtnum >= 0 )
    abuf.a[z] = texture ( tex[mat.mat[n].txtnum], TxtCoord );
  else
    abuf.a[z] = mat.mat[n].diffref;
  discard;
} /*main*/

