#version 450 core

#define MAX_NLIGHTS    8

in FVertex {
  vec3      Position;
/*  vec2      TxtCoord;*/
  vec2      BTxtCoord;
  vec3      Normal;
  flat vec3 TNormal;
} In;

out vec4 out_Colour;

layout(std430,binding=0) buffer VarBuf { uvec4 tvar[]; } vbuf;
layout(std430,binding=9) buffer VMap { uvec2 px[]; } vmap;

struct LSPar {
    vec3 ambient;
    vec3 direct;
    vec4 position;
    vec3 attenuation;
    mat4 shadow_vpm;
  };

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm, vpmi;
    vec4 eyepos;
    vec4 viewport;
  } trb;

uniform LSBlock {
    uint  nls;              /* liczba zrodel swiatla */
    uint  mask, slmask;     /* maska wlaczonych zrodel i maska zrodel powierzchniowych */
    uint  shmask, cshmask;
    float max_depth;
    int   lightn;
    LSPar ls[MAX_NLIGHTS];  /* poszczegolne zrodla swiatla */
  } light;

uniform CtlBlock {
    int   stage, step, width, height, N, H, nrows, ncols, first, txts;
    uint  nelem, p0, mi, nnz;
    bool  reverse;
    float C;
    vec3  colour;
  } ctl;

struct Material {
    vec4  emission0, emission1;
    vec4  diffref;
    vec4  specref;
    float shininess, wa, we;
    int   txtnum;
  };

Material mm;

vec3 posDifference ( vec4 p, vec3 pos, out float dist )
{
  vec3 v;

  if ( p.w != 0.0 ) {
    v = p.xyz/p.w-pos.xyz;
    dist = sqrt ( dot ( v, v ) );
  }
  else
    v = p.xyz;
  return normalize ( v );
} /*posDifference*/

float attFactor ( vec3 att, float dist )
{
  return 1.0/(((att.z*dist)+att.y)*dist+att.x);
} /*attFactor*/

vec3 LambertLighting ( void )
{
  vec3  normal, tnormal, lv, vv, Colour;
  float d, e, dist;
  uint  i, mask;

  normal = normalize ( In.Normal );
  tnormal = In.TNormal;
  vv = posDifference ( trb.eyepos, In.Position, dist );
  e = dot ( vv, tnormal );

  Colour = vec3(0.0);
  for ( i = 0, mask = 0x00000001;  i < light.nls;  i++, mask <<= 1 )
    if ( (light.mask & mask) != 0 ) {
      Colour += light.ls[i].ambient * mm.diffref.xyz;
      lv = posDifference ( light.ls[i].position, In.Position, dist );
      d = dot ( lv, normal );
      if ( e > 0.0 ) {
        if ( d > 0.0 ) {
          if ( light.ls[i].position.w != 0.0 )
            d *= attFactor ( light.ls[i].attenuation, dist );
          Colour += (d * light.ls[i].direct) * mm.diffref.xyz;
        }
      }
      else {
        if ( d < 0.0 ) {
          if ( light.ls[i].position.w != 0.0 )
            d *= attFactor ( light.ls[i].attenuation, dist );
          Colour -= (d * light.ls[i].direct) * mm.diffref.xyz;
        }
      }
    }
  return clamp ( Colour, 0.0, 1.0 );
} /*LambertLighting*/

#define AGamma(colour) pow ( colour, vec3(256.0/563.0) )

void main ( void )
{
  int  ix, iy;
  uint z;

  ix = int(In.BTxtCoord.x);  iy = int(In.BTxtCoord.y);
  mm.diffref = vec4 ( ctl.colour, 1.0 );
  switch ( ctl.txts ) {
case 0:
    if ( ix % 2 == iy % 2 )
      mm.diffref.rgb *= 0.2;
    break;
case 1:
    z = vmap.px[iy*ctl.width + ix].x;
    if ( (vbuf.tvar[z].z & 0x01) != 0 )
      mm.diffref.rgb *= 0.5;
    break;
case 2:
case 3:
    mm.diffref.rgb = ctl.colour;
    break;
  }
  out_Colour = vec4 ( AGamma ( LambertLighting () ), 1.0 );
} /*main*/

