
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <ctype.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/util-debug.h"
#include "../utilities/utilities.h"
#include "trans.h"
#include "lights.h"
#include "balance.h"
#include "app4proc.h"
#include "app4struct.h"
/*
#include "room.h"
#include "table.h"
#include "chair.h"
#include "bookcase.h"
#include "galleon.h"
*/
#include "candle.h"

#define NSHADERS 16

void LoadMyShaders ( AppData *ad )
{
  static const char *filename[NSHADERS] =
    { "d0.vert.glsl", "d0.geom.glsl", "d0.frag.glsl",
      "d1.vert.glsl", "d1.geom.glsl", "d1.frag.glsl",
      "sh.vert.glsl", "sh.frag.glsl",
      "cubesh.vert.glsl", "cubesh.geom.glsl", "cubesh.frag.glsl",
      "d2.comp.glsl", "d3.comp.glsl", "d4.comp.glsl",
      "d5.comp.glsl", "b0.frag.glsl" };
  static const GLuint shtype[NSHADERS] =
    { GL_VERTEX_SHADER, GL_GEOMETRY_SHADER, GL_FRAGMENT_SHADER,
      GL_VERTEX_SHADER, GL_GEOMETRY_SHADER, GL_FRAGMENT_SHADER,
      GL_VERTEX_SHADER, GL_FRAGMENT_SHADER,
      GL_VERTEX_SHADER, GL_GEOMETRY_SHADER, GL_FRAGMENT_SHADER,
      GL_COMPUTE_SHADER, GL_COMPUTE_SHADER, GL_COMPUTE_SHADER,
      GL_COMPUTE_SHADER, GL_FRAGMENT_SHADER };
  static const char *name[NPROGRAMS] =
    { "0", "1", "2", "3", "4", "5", "6", "7", "8", "9" };
  GLuint sh_id[NSHADERS], shid[3], *prog_id;
  int    i;

  prog_id = ad->program_id;
  for ( i = 0; i < NSHADERS; i++ )
    sh_id[i] = CompileShaderFiles ( shtype[i], 1, &filename[i] );
  prog_id[0] = LinkShaderProgram ( 3, sh_id, name[i] );
  shid[0] = sh_id[3];  shid[1] = sh_id[4];  shid[2] = sh_id[2];
  prog_id[1] = LinkShaderProgram ( 3, shid, name[1] );
  shid[0] = sh_id[0];  shid[1] = sh_id[1];  shid[2] = sh_id[5];
  prog_id[2] = LinkShaderProgram ( 3, shid, name[2] );
  shid[0] = sh_id[3];  shid[1] = sh_id[4];
  prog_id[3] = LinkShaderProgram ( 3, shid, name[3] );
  prog_id[4] = LinkShaderProgram ( 2, &sh_id[6], name[4] );
  prog_id[5] = LinkShaderProgram ( 3, &sh_id[8], name[5] );
  prog_id[6] = LinkShaderProgram ( 1, &sh_id[11], name[6] );
  prog_id[7] = LinkShaderProgram ( 1, &sh_id[12], name[7] );
  prog_id[8] = LinkShaderProgram ( 1, &sh_id[13], name[8] );
  prog_id[9] = LinkShaderProgram ( 1, &sh_id[14], name[9] );
  for ( i = 0; i < NSHADERS; i++ )
    glDeleteShader ( sh_id[i] );
  GetAccessToTransBlockUniform ( prog_id[0] );
  for ( i = 1; i < 8; i++ )
    AttachUniformTransBlockToBP ( prog_id[i] );
  for ( i = 9; i < 10; i++ )
    AttachUniformTransBlockToBP ( prog_id[i] );
  GetAccessToLightBlockUniform ( prog_id[0] );
  AttachUniformLightBlockToBP ( prog_id[1] );
  AttachUniformLightBlockToBP ( prog_id[5] );
  AttachUniformLightBlockToBP ( prog_id[6] );
  AttachUniformLightBlockToBP ( prog_id[7] );
  AttachUniformLightBlockToBP ( prog_id[9] );
  GetAccessToMatBlockUniform ( prog_id[0] );
  for ( i = 1; i < 4; i++ )
    AttachUniformMatBlockToBP ( prog_id[i] );
  for ( i = 6; i < 10; i++ )
    AttachUniformMatBlockToBP ( prog_id[i] );
  ad->prog7glowfctloc = glGetUniformLocation ( prog_id[7], "glowfct" );
  ad->prog7obscglloc = glGetUniformLocation ( prog_id[7], "obscgl" );
  ad->prog8passloc = glGetUniformLocation ( prog_id[8], "pass" );
  ad->prog8ngfloc = glGetUniformLocation ( prog_id[8], "ngf" );
  ad->prog9glowfctloc = glGetUniformLocation ( prog_id[9], "glowfct" );
  ad->prog9obscglloc = glGetUniformLocation ( prog_id[9], "obscgl" );
  ad->prog9ssaorloc = glGetUniformLocation ( prog_id[9], "ssao_radius" );
  ad->prog9debugloc = glGetUniformLocation ( prog_id[9], "debug" );
  ad->prog9stageloc = glGetUniformLocation ( prog_id[9], "stage" );
  ExitIfGLError ( "CompileMyShaders" );
} /*LoadMyShaders*/

/* ////////////////////////////////////////////////////////////////////////// */
static GLenum internf[DFB_TEXTURES] =
  { GL_RGBA32F, GL_RGBA32F, GL_RGBA32F, GL_RG32F, GL_R8I,
    GL_DEPTH_COMPONENT32F, GL_RGBA32F, GL_RGBA32F, GL_RGBA32F };

static void AllocDFBOTextures ( DeferredFB *dfb, int w, int h )
{
  static const GLenum buffers[6] = { GL_COLOR_ATTACHMENT0, GL_COLOR_ATTACHMENT1,
    GL_COLOR_ATTACHMENT2, GL_COLOR_ATTACHMENT3, GL_COLOR_ATTACHMENT4,
    GL_DEPTH_ATTACHMENT };
  int i;

  glGenTextures ( DFB_TEXTURES, dfb->dtxt );
  for ( i = 0; i < DFB_TEXTURES; i++ ) {
    glBindTexture ( GL_TEXTURE_2D, dfb->dtxt[i] );
    glTexStorage2D ( GL_TEXTURE_2D, 1, internf[i], w, h );
  }
  glBindTexture ( GL_TEXTURE_2D, 0 );
  glBindFramebuffer ( GL_FRAMEBUFFER, dfb->dfbo[0] );
  for ( i = 0; i < 6; i++ )
    glFramebufferTexture ( GL_FRAMEBUFFER, buffers[i], dfb->dtxt[i], 0 );
  if ( glCheckFramebufferStatus ( GL_FRAMEBUFFER ) !=
       GL_FRAMEBUFFER_COMPLETE )
    ExitOnError ( "AllocDFBOTextures 0" );
  glDrawBuffers ( 5, buffers );
  glBindFramebuffer ( GL_FRAMEBUFFER, dfb->dfbo[1] );
  glFramebufferTexture ( GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0,
                         dfb->dtxt[6], 0 );
  if ( glCheckFramebufferStatus ( GL_FRAMEBUFFER ) !=
       GL_FRAMEBUFFER_COMPLETE )
    ExitOnError ( "AllocDFBOTextures 1" );
  dfb->width = w;  dfb->height = h;
  glBindFramebuffer ( GL_FRAMEBUFFER, 0 );
} /*AllocDFBOTextures*/

void SetupDFBO ( DeferredFB *dfb, int w, int h )
{

  glGenFramebuffers ( 2, dfb->dfbo );
  AllocDFBOTextures ( dfb, w, h );
  ExitIfGLError ( "SetupDFBO" );
} /*SetupDFBO*/

void ResizeDFBO ( DeferredFB *dfb, int w, int h )
{
  glDeleteTextures ( DFB_TEXTURES, dfb->dtxt );
  AllocDFBOTextures ( dfb, w, h );
  ExitIfGLError ( "ResizeDFBO" );
} /*ResizeDFBO*/

void DeleteDFBO ( DeferredFB *dfb )
{
  glBindFramebuffer ( GL_FRAMEBUFFER, 0 );
  glDeleteFramebuffers ( 2, dfb->dfbo );
  glDeleteTextures ( DFB_TEXTURES, dfb->dtxt );
  ExitIfGLError ( "DeleteDFBO" );
} /*DeleteDFBO*/

/* ////////////////////////////////////////////////////////////////////////// */
static void DrawMyScene ( AppData *ad, char ropt )
{
  int    i;
  GLuint p0, p1;
  char   final;

  switch ( ropt ) {
case ROPT_DIRECT:
    final = true;
    p0 = ad->program_id[0];  p1 = ad->program_id[1];  break;
case ROPT_DEFERRED:
    final = true;
    p0 = ad->program_id[2];  p1 = ad->program_id[3];  break;
    break;
case ROPT_SHADOW:
    final = false;
    p0 = p1 = ad->program_id[4];
    break;
case ROPT_CUBESHADOW:
    final = false;
    p0 = p1 = ad->program_id[5];
    break;
case ROPT_TRCLASS1:
case ROPT_TRCLASS2:
case ROPT_TRCLASS3:
case ROPT_MACROEL:
    DrawTrClass ( &ad->belem, &ad->trans, ropt );
    return;
case ROPT_ELEMCP:
    DrawElemCPoints ( &ad->belem, &ad->trans, -1 );
    return;
case ROPT_RADIANCE:
    DrawRadianceElements ( &ad->belem, &ad->trans );
    if ( !ad->mainlamp_on )  /* plomien swiecy osobno */
      DrawCandleFlame ( ad->program_id[0], &ad->obj[ad->nobjects-1],
                        &ad->trans, &ad->mat );
    return;
  }
  for ( i = 0; i < ad->nobjects-2; i++ )
    ad->obj[i].redraw ( p0, &ad->obj[i], &ad->trans, &ad->mat );
  if ( final ) {
    if ( !ad->mainlamp_on )
      DrawCandleFlame ( p0, &ad->obj[ad->nobjects-1], &ad->trans, &ad->mat );
    ad->obj[ad->nobjects-2].redraw ( p1, &ad->obj[ad->nobjects-2],
                                 &ad->trans, &ad->mat );
  }
  else if ( !ad->mainlamp_on )
    ad->obj[ad->nobjects-2].redraw ( p1, &ad->obj[ad->nobjects-2],
                                 &ad->trans, &ad->mat );
} /*DrawMyScene*/

void DrawSceneToShadows ( AppData *ad )
{
  TransBl *trans;
  LightBl *light;
  int     l;
  GLuint  mask;

  glEnable ( GL_DEPTH_TEST );
  trans = &ad->trans;
  light = &ad->light;
  if ( !ad->shadows_ok ) {
    LoadViewport ( &ad->trans, 0, 0, SHADOW_MAP_SIZE, SHADOW_MAP_SIZE );
    glEnable ( GL_POLYGON_OFFSET_FILL );
    glPolygonOffset ( 2.0f, 4.0f );
    glEnable ( GL_TEXTURE_CUBE_MAP_SEAMLESS );
    for ( l = 0, mask = 0x00000001;  l < light->nls;  l++, mask <<= 1 )
      if ( (light->mask & mask) &&light->ls[l].shadow_fbo ) {
        BindShadowTxtFBO ( light, trans, l );
        glClear ( GL_DEPTH_BUFFER_BIT );
        if ( light->shmask & mask )
          DrawMyScene ( ad, ROPT_SHADOW );
        else if ( light->cshmask & mask )
          DrawMyScene ( ad, ROPT_CUBESHADOW );
      }
    glBindFramebuffer ( GL_FRAMEBUFFER, 0 );
    glDisable ( GL_POLYGON_OFFSET_FILL );
    ad->shadows_ok = true;
  }
  for ( l = 0, mask = 0x00000001;  l < light->nls;  l++, mask <<= 1 ) {
    if ( light->shmask & mask ) {
      glActiveTexture ( GL_TEXTURE0+MAX_TEXTURES+l );
      glBindTexture ( GL_TEXTURE_2D, light->ls[l].shadow_txt );
    }
    else if ( light->cshmask & mask ) {
      glActiveTexture ( GL_TEXTURE0+MAX_TEXTURES+l );
      glBindTexture ( GL_TEXTURE_CUBE_MAP, light->ls[l].shadow_txt );
    }
  }
} /*DrawSceneToShadows*/

static void _GBufferBegin ( AppData *ad )
{
  int i;
  const GLint mo[4] = {-1,-1,-1,-1};

  glBindFramebuffer ( GL_DRAW_FRAMEBUFFER, ad->dfb.dfbo[0] );
  glClear ( GL_DEPTH_BUFFER_BIT );
  glClearBufferiv ( GL_COLOR, 4, mo );
  DrawMyScene ( ad, ROPT_DEFERRED );
  for ( i = 0; i < 5; i++ )
    glBindImageTexture ( i, ad->dfb.dtxt[i], 0, GL_FALSE, 0,
                         GL_READ_ONLY, internf[i] );
  glBindImageTexture ( 5, ad->dfb.dtxt[6], 0, GL_FALSE, 0,
                       GL_WRITE_ONLY, internf[6] );
} /*_GBufferBegin*/

static void _GBufferEnd ( AppData *ad )
{
  glBindFramebuffer ( GL_READ_FRAMEBUFFER, ad->dfb.dfbo[1] );
  glBindFramebuffer ( GL_DRAW_FRAMEBUFFER, 0 );
  glBlitFramebuffer ( 0, 0, ad->dfb.width, ad->dfb.height,
                      0, 0, ad->dfb.width, ad->dfb.height,
                      GL_COLOR_BUFFER_BIT, GL_NEAREST );
} /*_GBufferEnd*/

void BlurLightEmission ( AppData *ad )
{
  int i, p;

  glBindImageTexture ( 6, ad->dfb.dtxt[7], 0, GL_FALSE, 0,
                       GL_READ_WRITE, GL_RGBA32F );
  glBindImageTexture ( 7, ad->dfb.dtxt[8], 0, GL_FALSE, 0,
                       GL_READ_WRITE, GL_RGBA32F );
  glUseProgram ( ad->program_id[8] );
  glUniform1i ( ad->prog8ngfloc, ad->ngf );
  if ( ad->ngf < 0 ) {
    glUniform1i ( ad->prog8passloc, -1 );
    glDispatchCompute ( ad->dfb.width, ad->dfb.height, 1 );
    glMemoryBarrier (  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT );
  }
  else {
    for ( i = p = 0;  i < 1;  i++ ) {
      glUniform1i ( ad->prog8passloc, p++ );
      glDispatchCompute ( ad->dfb.width, ad->dfb.height, 1 );
      glMemoryBarrier (  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT );
      glUniform1i ( ad->prog8passloc, p++ );
      glDispatchCompute ( ad->dfb.width, ad->dfb.height, 1 );
      glMemoryBarrier (  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT );
    }
  }
} /*BlurLightEmission*/

void LoadFFVPMatrices ( FFTransBl *fftrans, GLfloat cp[3], GLfloat nv[3] );

static void _RedrawMyWorldView ( AppData *ad )
{
  int i;

  LoadVPMatrix ( &ad->trans );
  switch ( ad->render_option ) {
case ROPT_DIRECT:
case ROPT_TRCLASS1:
case ROPT_TRCLASS2:
    DrawMyScene ( ad, ad->render_option );
    break;
case ROPT_RADIANCE:
    if ( !ad->radiance_ok ) {
      DrawSceneToShadows ( ad );
      ad->radiance_ok = ComputeLightBalance ( &ad->belem, &ad->trans, ad->niter );
      LoadViewport ( &ad->trans,
                     ad->trans.viewport[0], ad->trans.viewport[1],
                     ad->trans.viewport[2], ad->trans.viewport[3] );
      LoadVPMatrix ( &ad->trans );
    }
    DrawMyScene ( ad, ad->render_option );
    break;
case ROPT_DEFERRED1:
    _GBufferBegin ( ad );
    glUseProgram ( ad->program_id[6] );
    glDispatchCompute ( ad->dfb.width, ad->dfb.height, 1 );
    glMemoryBarrier (  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT );
    _GBufferEnd ( ad );
    break;
case ROPT_DEFERRED2:
    _GBufferBegin ( ad );
    BlurLightEmission ( ad );
    glUseProgram ( ad->program_id[7] );
    glUniform1f ( ad->prog7glowfctloc, ad->glowfct );
    glUniform1i ( ad->prog7obscglloc, ad->obscgl );
    glDispatchCompute ( ad->dfb.width, ad->dfb.height, 1 );
    glMemoryBarrier (  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT );
    _GBufferEnd ( ad );
    break;
case ROPT_DEFERRED3:
    _GBufferBegin ( ad );
    BlurLightEmission ( ad );
    glActiveTexture ( GL_TEXTURE0+MAX_TEXTURES+MAX_NLIGHTS );
    glBindTexture ( GL_TEXTURE_2D, ad->dfb.dtxt[1] );
    glActiveTexture ( GL_TEXTURE0+MAX_TEXTURES+MAX_NLIGHTS+1 );
    glBindTexture ( GL_TEXTURE_2D, ad->dfb.dtxt[6] );
    glUseProgram ( ad->program_id[9] );
    glUniform1f ( ad->prog9glowfctloc, ad->glowfct );
    glUniform1i ( ad->prog9obscglloc, ad->obscgl );
    glUniform1i ( ad->prog9debugloc, ad->debug );
    glUniform1f ( ad->prog9ssaorloc, ad->ssao_radius );
    for ( i = 0; i < 3; i++ ) {
      glUniform1i ( ad->prog9stageloc, i );
      glDispatchCompute ( ad->dfb.width, ad->dfb.height, 1 );
      glMemoryBarrier (  GL_SHADER_IMAGE_ACCESS_BARRIER_BIT );
    }
    _GBufferEnd ( ad );
    break;
case ROPT_TRCLASS3:
    glPolygonOffset ( 2.0f, 4.0f );
    glEnable ( GL_POLYGON_OFFSET_FILL );
    DrawMyScene ( ad, ad->render_option );
    glDisable ( GL_POLYGON_OFFSET_FILL );
    break;
case ROPT_ELEMCP:
    glPolygonOffset ( 2.0f, 4.0f );
    glEnable ( GL_POLYGON_OFFSET_FILL );
    DrawMyScene ( ad, ROPT_TRCLASS3 );
    glDisable ( GL_POLYGON_OFFSET_FILL );
    DrawMyScene ( ad, ad->render_option );
    break;
case ROPT_MACROEL:
    DrawMyScene ( ad, ad->render_option );
    break;
default:
    break;
  }
  glUseProgram ( 0 );
  glFlush ();
  ExitIfGLError("RedrawMyWorld");
} /*_RedrawMyWorldView*/

extern int debug_elem;

void _RedrawMyWorld ( AppData *ad )
{
  glEnable ( GL_DEPTH_TEST );
  DrawSceneToShadows ( ad );
  LoadViewport ( &ad->trans,
                 0, 0, ad->camera.win_width, ad->camera.win_height );
  glClearColor ( 0.0, 0.0, 0.0, 1.0 );
  glClear ( GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT );
  glEnable ( GL_DEPTH_CLAMP );
  _RedrawMyWorldView ( ad );
} /*_RedrawMyWorld*/

