
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>

#include "../utilities/openglheader.h"

#include "app3d.h"
#include "../utilities/utilities.h"
#include "../utilities/bezpatches.h"
#include "../utilities/GPUsparsemat.h"
#include "../utilities/meshes.h"
#include "../utilities/linkage.h"
#include "trans.h"
#include "lights.h"
#include "knotswidget.h"
#include "app3dproc.h"
#include "app3dstruct.h"

static GLuint LinkMyShaderProgram ( const int *shn, const GLuint *shaders,
                                    const char *name )
{
  GLuint sh[5], i;

  for ( i = 0; i < shn[0]; i++ )
    sh[i] = shaders[shn[i+1]];
  return LinkShaderProgram ( shn[0], sh, name );
} /*LinkMyShaderProgram*/

void LoadRenderingShaders ( GLuint *shid )
{
  static const GLchar *filename[] =
    { "app3C0.vert.glsl", "app3C1.vert.glsl", "app3C2.vert.glsl", "app3C3.vert.glsl",
      "app3C4.vert.glsl", "app2.tesc.glsl", "app3C0.tese.glsl", "app3C1.tese.glsl",
      "app3C0.geom.glsl", "app3C1.geom.glsl", "app3C2.geom.glsl", "app3C0.frag.glsl",
      "app3C1.frag.glsl" };
  static const GLuint shtype[] =
    { GL_VERTEX_SHADER, GL_VERTEX_SHADER, GL_VERTEX_SHADER, GL_VERTEX_SHADER,
      GL_VERTEX_SHADER, GL_TESS_CONTROL_SHADER, GL_TESS_EVALUATION_SHADER,
      GL_TESS_EVALUATION_SHADER, GL_GEOMETRY_SHADER, GL_GEOMETRY_SHADER,
      GL_GEOMETRY_SHADER, GL_FRAGMENT_SHADER, GL_FRAGMENT_SHADER };
  int i;

  for ( i = 0; i < 13; i++ )
    shid[i] = CompileShaderFiles ( shtype[i], 1, &filename[i] );
} /*LoadRenderingShaders*/

static const GLchar *UVNames[] = { "LightingModel" };

void LinkMeshRenderingPrograms ( MeshRenderPrograms *prog, GLuint *shid )
{
  static const int p0sh[] = {3,0,8,11};
  static const int p1sh[] = {3,1,9,12};
  static const int p2sh[] = {2,2,11};
  int i;

  prog->progid[0] = LinkMyShaderProgram ( p0sh, shid, "0" );
  prog->progid[1] = LinkMyShaderProgram ( p1sh, shid, "1" );
  prog->progid[2] = LinkMyShaderProgram ( p2sh, shid, "2" );
/*PrintProgramResources ( prog->progid[1], "1" );*/
  GetAccessToMeshSurfBlock ( prog->progid[1] );
  prog->LightingModelLoc = glGetUniformLocation ( prog->progid[1], UVNames[0] );
  GetAccessToTransBlockUniform ( prog->progid[0] );
  GetAccessToLightMatUniformBlocks ( prog->progid[1] );
  for ( i = 1; i < 3; i++ )
    AttachUniformTransBlockToBP ( prog->progid[i] );
  ExitIfGLError ( "LinkMeshRenderingShaders" );
} /*LinkMeshRenderingPrograms*/

void DeleteMeshRenderingPrograms ( MeshRenderPrograms *prog )
{
  int i;

  glUseProgram ( 0 );
  for ( i = 0; i < 2; i++ )
    glDeleteProgram ( prog->progid[i] );
  ExitIfGLError ( "DeleteMeshRenderingPrograms" );
} /*DeleteMeshRenderingPrograms*/

void DrawMeshEdges ( MeshRenderPrograms *prog,
                     GPUmesh *mesh, GLfloat colour[3] )
{
  int i;

  glUseProgram ( prog->progid[0] );
  for ( i = 0; i < 4; i++ )
    glBindBufferBase ( GL_SHADER_STORAGE_BUFFER, i, mesh->mbuf[i] );
  SetMeshColour ( mesh, colour );
  glBindVertexArray ( empty_vao );
  glDrawArraysInstanced ( GL_LINES, 0, 2, mesh->nhe );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawMeshEdges" );
} /*DrawMeshEdges*/

void DrawMeshFacets ( MeshRenderPrograms *prog, GPUmesh *mesh,
                      MatBl *mat, GLint mtn, char nvs, char final )
{
  int i;

  for ( i = 0; i < 4; i++ )
    glBindBufferBase ( GL_SHADER_STORAGE_BUFFER, i, mesh->mbuf[i] );
  if ( final ) {
    glUseProgram ( prog->progid[1] );
    SetMeshNVS ( mesh, (GLint)nvs );
    ChooseMaterial ( mat, mtn );
  }
  else
    glUseProgram ( prog->progid[2] );
  glBindVertexArray ( empty_vao );
  glDrawArraysInstanced ( GL_TRIANGLE_FAN, 0, 4, mesh->nfac );
  glBindVertexArray ( 0 );
  ExitIfGLError ( "DrawMeshFacets" );
} /*DrawMeshFacets*/

/* ////////////////////////////////////////////////////////////////////////// */
void LinkBPRenderingPrograms ( BPRenderPrograms *prog, GLuint *shid )
{
  static const int p3sh[] = {2,4,11};
  static const int p4sh[] = {5,3,5,6,10,12};
  static const int p5sh[] = {4,3,5,7,11};
  int i;

  prog->progid[0] = LinkMyShaderProgram ( p3sh, shid, "3" );
  prog->progid[1] = LinkMyShaderProgram ( p4sh, shid, "4" );
  prog->progid[2] = LinkMyShaderProgram ( p5sh, shid, "5" );
  prog->LightingModelLoc = glGetUniformLocation ( prog->progid[1], UVNames[0] );
  GetAccessToBezPatchStorageBlocks ( prog->progid[1], false, false );
  GetAccessToTransBlockUniform ( prog->progid[0] );
  for ( i = 1; i < 3; i++ )
    AttachUniformTransBlockToBP ( prog->progid[i] );
  GetAccessToLightMatUniformBlocks ( prog->progid[1] );
  ExitIfGLError ( "LoadBPRenderingPrograms" );
} /*LinkBPRenderingPrograms*/

void DeleteBPRenderingPrograms ( BPRenderPrograms *prog )
{
  int i;

  glUseProgram ( 0 );
  for ( i = 0; i < 2; i++ )
    glDeleteProgram ( prog->progid[i] );
  ExitIfGLError ( "DeleteBPRenderingPrograms" );
} /*DeleteBPRenderingPrograms*/

