
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "../utilities/openglheader.h"

#include "app3d.h"
#include "../utilities/utilities.h"
#include "../utilities/quaternions.h"
#include "../utilities/linkage.h"
#include "../utilities/GPUsparsemat.h"
#include "../utilities/meshes.h"
#include "../utilities/bezpatches.h"
#include "../utilities/ispline.h"
#include "trans.h"
#include "lights.h"
#include "knotswidget.h"
#include "app3dproc.h"
#include "app3dstruct.h"

void UpdateKeyInterpSpline ( AppData *ad )
{
  ad->bs_ok = ConstructCubicInterpBSplinef ( &ad->lastbsknot,
                 ad->bsknots, ad->bsparams, ad->lastkeyframe,
                 ad->keyknots, NKLARTPARAMS, ad->keyparams );
} /*UpdateKeyInterpSpline*/

void UpdateKeyInterpQSpline ( AppData *ad )
{
  int i, j, k;

  for ( i = 1, k = 4;  i <= ad->lastkeyframe;  i++, k += 4 )
    if ( V4DotProductf ( &ad->qparams[k-4], &ad->qparams[k] ) < 0.0 )
      for ( j = k; j < k+4; j++ )
        ad->qparams[j] = -ad->qparams[j];
  ad->qs_ok = ConstructQuaternionInterpSplinef ( &ad->lastbsknot,
                   ad->bsknots, ad->qbsparams, ad->lastkeyframe,
                   ad->keyknots, ad->qparams );
} /*UpdateKeyInterpQSpline*/

void CleanupKeyFrames ( AppData *ad )
{
  if ( ad->keyknots )  free ( ad->keyknots );
  if ( ad->keyparams ) free ( ad->keyparams );
  if ( ad->qparams )   free ( ad->qparams );
  if ( ad->bsknots )   free ( ad->bsknots );
  if ( ad->bsparams )  free ( ad->bsparams );
  if ( ad->qbsparams ) free ( ad->qbsparams );
} /*CleanupKeyFrames*/

char InitKeyFrames ( AppData *ad )
{
  int i;

  ad->keyknots = malloc ( MAXKEYFRAMES*sizeof(float) );
  ad->keyparams = malloc ( MAXKEYFRAMES*NKLARTPARAMS*sizeof(float) );
  ad->bsknots = malloc ( (MAXKEYFRAMES+6)*sizeof(float) );
  ad->bsparams = malloc ( (MAXKEYFRAMES+2)*NKLARTPARAMS*sizeof(float) );
  ad->qparams = malloc ( MAXKEYFRAMES*4*sizeof(float) );
  ad->qbsparams = malloc ( (MAXKEYFRAMES+2)*4*sizeof(float) );
  if ( ad->keyknots && ad->keyparams && ad->qparams &&
       ad->bsknots && ad->bsparams && ad->qbsparams ) {
    ad->keyknots[0] = 0.0;
    ad->keyknots[1] = 10.0/3.0;
    ad->keyknots[2] = 20.0/3.0;
    ad->keyknots[3] = 10.0;
    ad->wdg.kw.nknots = (ad->lastkeyframe = 3) + 1;
    ad->wdg.kw.knots = ad->keyknots;
    for ( i = 0; i <= ad->lastkeyframe; i++ )
      memcpy ( &ad->keyparams[i*NKLARTPARAMS], ad->wdg.artp,
               NKLARTPARAMS*sizeof(float) );
    memset ( ad->qparams, 0, (ad->lastkeyframe+1)*4*sizeof(float) );
    for ( i = 0; i <= ad->lastkeyframe; i++ )
      ad->qparams[4*i] = 1.0;
    UpdateKeyInterpSpline ( ad );
    UpdateKeyInterpQSpline ( ad );
    ad->wdg.animate_mm = ad->wdg.animate_kl = true;
    ad->wdg.animate_vp = false;
    return true;
  }
  else {
    CleanupKeyFrames ( ad );
    return false;
  }
} /*InitKeyFrames*/

void FindKeyFrame ( AppData *ad, char right )
{
  AppWidgets   *aw;
  KnotsWidgetf *kw;
  int          c;
  float        v[3];
  double       a;

  aw = &ad->wdg;
  kw = &aw->kw;
  c = FindKnotInterval ( kw->nknots, ad->keyknots, kw->xc );
  if ( c < 0 )
    c = 0;
  else if ( c >= kw->nknots )
    c = kw->nknots-1;
  if ( !right && c > 0 && kw->xc == ad->keyknots[c] )
    c --;
  else if ( right && c < kw->nknots-1 )
    c ++;
  kw->current = c;
  kw->curxi = KnotsWidgetXtoXi ( kw, kw->xc = ad->keyknots[c] );
  memcpy ( aw->artp, &ad->keyparams[c*NKLARTPARAMS],
           NKLARTPARAMS*sizeof(float) );
  ArticulatePalmLinkage ( ad );
  RotVQuatf ( v, &a, &ad->qparams[c*4] );
  SetupViewMatrix ( ad, v, a );
} /*FindKeyFrame*/

void SetKeyFrame ( AppData *ad )
{
  AppWidgets   *aw;
  KnotsWidgetf *kw;
  int          c;

  aw = &ad->wdg;
  kw = &aw->kw;
  c = kw->current;
  if ( (c = kw->current) >= 0 && c < kw->nknots ) {
    memcpy ( &ad->keyparams[c*NKLARTPARAMS], aw->artp,
             NKLARTPARAMS*sizeof(float) );
    UpdateKeyInterpSpline ( ad );
    QuatRotVf ( &ad->qparams[c*4],
                ad->camera.viewer_rvec, ad->camera.viewer_rangle );
    UpdateKeyInterpQSpline ( ad );
  }
} /*SetKeyFrame*/

void ClampArtParams ( float *params )
{
  int i;

  for ( i = 0; i < NKLARTPARAMS; i++ )
    if ( params[i] < 0.0 ) params[i] = 0.0;
    else if ( params[i] > 1.0 ) params[i] = 1.0;
} /*ClampArtParams*/

void InsertKeyFrame ( AppData *ad )
{
  AppWidgets   *aw;
  KnotsWidgetf *kw;
  int          c, n;

  aw = &ad->wdg;
  kw = &aw->kw;
  ad->lastkeyframe = kw->nknots-1;
  if ( (c = kw->current) < (n = kw->nknots)-1 ) {
    memmove ( &ad->keyparams[(c+1)*NKLARTPARAMS],
              &ad->keyparams[c*NKLARTPARAMS],
              (n-c-1)*NKLARTPARAMS*sizeof(float) );
    BSCdeBoorf ( 3, ad->lastbsknot, ad->bsknots, NKLARTPARAMS,
                 ad->bsparams, ad->keyknots[c], aw->artp );
    ClampArtParams ( aw->artp );
    memcpy ( &ad->keyparams[c*NKLARTPARAMS], aw->artp,
             NKLARTPARAMS*sizeof(float) );
    memmove ( &ad->qparams[(c+1)*4], &ad->qparams[c*4],
              (n-c-1)*4*sizeof(float) );
    if ( ad->qs_ok )
      QuatSlerpdeBoorf ( 3, ad->lastbsknot, ad->bsknots, ad->qbsparams,
                         ad->keyknots[c], &ad->qparams[c*4] );
  }
  else {
    memcpy ( &ad->keyparams[c*NKLARTPARAMS],
             &ad->keyparams[(c-1)*NKLARTPARAMS], NKLARTPARAMS*sizeof(float) );
    memcpy ( &ad->qparams[c*4], &ad->qparams[(c-1)*4], 4*sizeof(float) );
  }
  UpdateKeyInterpSpline ( ad );
  ArticulatePalmLinkage ( ad );
  QuatRotVf ( &ad->qparams[c*4],
              ad->camera.viewer_rvec, ad->camera.viewer_rangle );
  UpdateKeyInterpQSpline ( ad );
} /*InsertKeyFrame*/

void SwapKeyFrames ( AppData *ad, int i, int j )
{
  int   k, l, m;
  float *kp, a;

  kp = ad->keyparams;
  for ( l = i*NKLARTPARAMS, m = j*NKLARTPARAMS, k = 0;  k < NKLARTPARAMS; k++ )
    { a = kp[l+k];  kp[l+k] = kp[m+k];  kp[m+k] = a; }
  kp = ad->qparams;
  for ( l = i*4, m = j*4, k = 0;  k < 4; k++ )
    { a = kp[l+k];  kp[l+k] = kp[m+k];  kp[m+k] = a; }
} /*SwapKeyFrames*/

void ChangeKeyFrame ( AppData *ad )
{
  AppWidgets   *aw;
  KnotsWidgetf *kw;
  int          i, p, c;

  aw = &ad->wdg;
  kw = &aw->kw;
  if ( (p = kw->prevc) < (c = kw->current) ) {
    for ( i = p; i < c; i++ )
      SwapKeyFrames ( ad, i, i+1 );
  }
  else if ( p > c ) {
    for ( i = p; i > c; i-- )
      SwapKeyFrames ( ad, i, i-1 );
  }
  UpdateKeyInterpSpline ( ad );
  UpdateKeyInterpQSpline ( ad );
} /*ChangeKeyFrame*/

void DeleteKeyFrame ( AppData *ad )
{
  AppWidgets   *aw;
  KnotsWidgetf *kw;
  int          c, n;

  aw = &ad->wdg;
  kw = &aw->kw;
  ad->lastkeyframe = kw->nknots-1;
  if ( (c = kw->current) < (n = kw->nknots)-1 ) {
    memmove ( &ad->keyparams[c*NKLARTPARAMS],
              &ad->keyparams[(c+1)*NKLARTPARAMS],
              (n-c-1)*NKLARTPARAMS*sizeof(float) );
    memmove ( &ad->qparams[c*4], &ad->qparams[(c+1)*4],
              (n-c-1)*4*sizeof(float) );
  }
   UpdateKeyInterpSpline ( ad );
   UpdateKeyInterpQSpline ( ad );
} /*DeleteKeyFrame*/

void ArticulateKLAtX ( AppData *ad, float x )
{
  AppWidgets *aw;

  aw = &ad->wdg;
  if ( x <= ad->keyknots[0] || !ad->bs_ok )
    memcpy ( aw->artp, ad->keyparams, NKLARTPARAMS*sizeof(float) );
  else if ( x >= ad->keyknots[ad->lastkeyframe] )
    memcpy ( aw->artp, &ad->keyparams[(ad->lastkeyframe)*NKLARTPARAMS],
             NKLARTPARAMS*sizeof(float) );
  else {
    BSCdeBoorf ( 3, ad->lastbsknot, ad->bsknots, NKLARTPARAMS,
                 ad->bsparams, x, aw->artp );
    ClampArtParams ( aw->artp );
  }
  ArticulatePalmLinkage ( ad );
} /*ArticulateKLAtX*/

void ArticulateVPosAtX ( AppData *ad, float x )
{
  float      q[4], v[3];
  double     a;

  if ( x <= ad->keyknots[0] || !ad->qs_ok )
    memcpy ( q, ad->qparams, 4*sizeof(float) );
  else if ( x >= ad->keyknots[ad->lastkeyframe] )
    memcpy ( q, &ad->qparams[4*ad->lastkeyframe], 4*sizeof(float) );
  else
    QuatSlerpdeBoorf ( 3, ad->lastbsknot, ad->bsknots,
                       ad->qbsparams, x, q );
  RotVQuatf ( v, &a, q );
  SetupViewMatrix ( ad, v, a );
} /*ArticulateVPosAtX*/

void KnotWidgetPoint ( AppData *ad, int xi )
{
  AppWidgets *aw;
  float      x;

  aw = &ad->wdg;
  x = KnotsWidgetXitoX ( &aw->kw, xi );
  ArticulateKLAtX ( ad, x );
  if ( aw->animate_vp )
    ArticulateVPosAtX ( ad, x );
} /*KnotWidgetPoint*/

