#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "../utilities/initwglctx.h"
#include "../utilities/xwidgets.h"
#include "knotswidget.h"
#include "xknotswidget.h"
#include "app3d.h"
#include "app3dproc.h"

#define WIN0_WIDTH   560
#define WIN0_HEIGHT  420
#define MENU1_WIDTH  120
#define MENU3_HEIGHT  60

#define WDGSTATE_VIEW_TURNING 1

typedef struct {
    int  last_x, last_y;
    char opti;
  } widget3d;

static HWND       window[4];
static HDC        gldc;
static HGLRC      wglcontext;
static MSG        msg;
static char       redraw;

static int           window0_width, window0_height;
static xwinmenu      *wm1 = NULL, *wm2 = NULL, *wm3 = NULL;
static xwidget       *mywdg = NULL, *playbtn = NULL;
static AppWidgets    *appwdg = NULL;
static xKnotsWidgetf *myknotwdg = NULL;

static char str_EXIT[]    = "Exit";
static char str_SET[]     = "Set";
static char str_LEFT[]    = "<-";
static char str_RIGHT[]   = "->";
static char str_PANZOOM[] = "pan/zoom";
static char str_EDIT[]    = "edit";

static void (*idlefunc)(void) = NULL;

void Win1Callback ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  switch ( msg ) {
case WDGMSG_BUTTON_PRESS:
    switch ( wdg->id ) {
  case BTN_ID_EXIT:
      PostQuitMessage (0);
      break;
  default:
      break;
    }
    break;

case WDGMSG_SWITCH_CHANGE:
    if ( ProcessSwitchCommand ( wdg->id ) )
      goto redraw_win2;

case WDGMSG_SLIDEBAR_CHANGE:
    ProcessSlidebarCommand ( wdg->id );
redraw_win2:
    wm2->changed = redraw = true;
    PostMenuExposeEvent ( wm2 );
    break;

case XWMSG_KEY_PRESS:
    mywdg->input ( mywdg, msg, key, x, y );
    if ( wm2->changed )
      PostMenuExposeEvent ( wm2 );
    break;

default:
    break;
  }
} /*Win1CallBack*/

xwinmenu *SetupApp3dMenu ( void )
{
  xwinmenu *wm;
  int      i;

  if ( !(wm = NewWinMenu ( window[1], MENU1_WIDTH, WIN0_HEIGHT-MENU3_HEIGHT,
                           0, 0, NULL, NULL, Win1Callback )) )
    ExitOnError ( "SetupApp3dMenu" );
  NewButton ( wm, BTN_ID_EXIT, 60, 18, 2, 2, str_EXIT );
  for ( i = 0; i <= NPALMMESHES; i++ )
    NewSwitch ( wm, SW_ID_MESH0+i, 16, 16, 2+20*i, 22, NULL, &appwdg->sw[i] );
  for ( i = 0; i < NKLARTPARAMS; i++ )
    NewSlidebarf ( wm, SL_ID_ARTP0+i, 116, 10, 2, 46+15*i, &appwdg->artp[i] );
  return wm;
} /*SetupApp3dMenu*/

LRESULT CALLBACK Win1MessageProc ( HWND window, UINT msg, WPARAM wParam, LPARAM lParam )
{
  LRESULT result = 0;

  if ( !wm1 )
    return DefWindowProcA ( window, msg, wParam, lParam );
  switch ( msg ) {
case WM_PAINT:
    WinMenuRedraw ( wm1 );
    break;
default:
    result = WinMenuInput ( wm1, msg, wParam, lParam );
    if ( wm1->changed )
      wm2->changed = redraw = true;
    break;
  }
  return result;
} /*Win1MessageProc*/

  /* ////////////////////////////////////////////////////////////////////////// */
void MyWinResizeFunc ( HWND wind, int width, int height )
{
  window0_width = width;
  window0_height = height;
  MoveWindow ( window[1], 0, 0, MENU1_WIDTH, height-MENU3_HEIGHT, TRUE );
  MoveWindow ( window[2], MENU1_WIDTH, 0, width-MENU1_WIDTH, height-MENU3_HEIGHT, TRUE );
  MoveWindow ( window[3], 0, height-MENU3_HEIGHT, width, MENU3_HEIGHT, TRUE );
  wm2->changed = redraw = true;
} /*MyWinResizeFunc*/

LRESULT CALLBACK Win0MessageProc ( HWND window, UINT msg, WPARAM wParam, LPARAM lParam )
{
  LRESULT result = 0;

  switch ( msg ) {
case WM_CLOSE:
case WM_DESTROY:
    PostQuitMessage ( 0 );
    break;
case WM_SIZE:
    if ( wParam != SIZE_MINIMIZED )
      MyWinResizeFunc ( window, LOWORD(lParam), HIWORD(lParam) );
    break;
case WM_CHAR:
case WM_KEYDOWN:
case WM_KEYUP:
case WM_SYSKEYDOWN:
case WM_SYSKEYUP:
case WM_MOUSEMOVE:
case WM_LBUTTONDOWN:
case WM_LBUTTONUP:
    if ( IsCursorInMenu ( wm1 ) )
      SendMessage ( wm1->window, msg, wParam, lParam );
    else if ( IsCursorInMenu ( wm2 ) )
      SendMessage ( wm2->window, msg, wParam, lParam );
    else if ( IsCursorInMenu ( wm3 ) )
      SendMessage ( wm3->window, msg, wParam, lParam );
    else
      result = DefWindowProcA ( window, msg, wParam, lParam );
    break;
default:
    result = DefWindowProcA ( window, msg, wParam, lParam );
    break;
  }
  return result;
} /*Win0MessageProc*/

/* ////////////////////////////////////////////////////////////////////////// */
void MyIdleFunc ( void )
{
  if ( MoveOn () ) {
    wm1->changed = wm2->changed = wm3->changed;
    PostMenuExposeEvent ( wm1 );
    PostMenuExposeEvent ( wm3 );
    redraw = true;
  }
} /*MyIdleFunc*/

void My3DWidgetRedraw ( struct xwidget *wdg )
{
  RedrawMyWorld ();
} /*My3DWidgetRedraw*/

char My3DWidgetInput ( struct xwidget *wdg, int msg, int key, int x, int y )
{
/*  XClientMessageEvent *xclient;*/
  widget3d            *ww;

  ww = (widget3d*)wdg->data0;
  switch ( wdg->state ) {
case WDGSTATE_DEFAULT:
    switch ( msg ) {
  case XWMSG_BUTTON_PRESS:
      if ( key == Button1 ) {
        ww->last_x = x;  ww->last_y = y;
        wdg->state = WDGSTATE_VIEW_TURNING;
        GrabInput ( wdg );
        return true;
      }
      break;
  case XWMSG_KEY_PRESS:
      goto process_key;
  case WDGMSG_RECONFIGURE:
      ResizeMyWorld ( wdg->r.width = x, wdg->r.height = y );
      break;
  case XWMSG_CLIENT_MESSAGE:
      goto process_client_message;
  case XWMSG_DELETE:
      goto process_delete_message;
  default:
      break;
    }
    break;

case WDGSTATE_VIEW_TURNING:
    switch ( msg ) {
  case XWMSG_MOUSE_MOTION:
      if ( IsMouseButtonDown ( Button1 ) ) {
        RotateViewer ( (double)(x - ww->last_x), (double)(y - ww->last_y) );
        ww->last_x = x;  ww->last_y = y;
        wdg->wm->changed = true;
      }
      else
        goto release;
      break;
  case XWMSG_BUTTON_RELEASE:
      if ( !IsMouseButtonDown ( Button1 ) ) {
release:
        wdg->state = WDGSTATE_DEFAULT;
        UngrabInput ( wdg );
        return true;
      }
      break;
  case XWMSG_KEY_PRESS:
process_key:
      if ( ProcessCharCommand ( key ) )
        return wdg->wm->changed = redraw = true;
      break;

  case XWMSG_CLIENT_MESSAGE:
process_client_message:
      break;
  case XWMSG_DELETE:
process_delete_message:
      free ( wdg->data0 );
      return true;
  default:
      break;
    }
    break;

default:
    break;
  }
  return false;
} /*My3DWidgetInput*/

xwidget *New3DWidget ( struct xwinmenu *wm, int id, int w, int h )
{
  widget3d *ww;

  if ( !(ww = malloc ( sizeof(widget3d) )) )
    ExitOnError ( "New3DWidget" );
  ww->opti = 0;
  return NewWidget ( wm, sizeof(xwidget), id, w, h, 0, 0,
                     My3DWidgetInput, My3DWidgetRedraw, ww, NULL );
} /*New3DWidget*/

void RedrawWin2 ( xwinmenu *wm )
{
  widget3d *ww;

  ww = (widget3d*)mywdg->data0;
  if ( ww->opti > 0 )
    ww->opti --;
  else {
    mywdg->redraw ( mywdg );
    wm->changed = redraw = false;
  }
  SwapBuffers ( gldc );
} /*RedrawWin2*/

void Win2Callback ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  widget3d *ww;

  ww = (widget3d*)mywdg->data0;
  switch ( msg ) {
case WDGMSG_RECONFIGURE:
    mywdg->input ( mywdg, WDGMSG_RECONFIGURE, 0, x, y );
    ww->opti = 4;
    redraw = true;
    break;
case XWMSG_CLIENT_MESSAGE:
    mywdg->input ( mywdg, msg, key, x, y );
    break;
default:
    break;
  }
} /*Win2Callback*/

LRESULT CALLBACK Win2MessageProc ( HWND window, UINT msg, WPARAM wParam, LPARAM lParam )
{
  LRESULT result = 0;

  if ( !wm2 )
    return DefWindowProcA ( window, msg, wParam, lParam );
  result = WinMenuInput ( wm2, msg, wParam, lParam );
  if ( wm2->changed )
    redraw = true;
  return result;
} /*Win2MessageProc*/

xwinmenu *SetupApp3dGLWindow ( void )
{
  xwinmenu *wm;

  if ( !(wm = NewWinMenu ( window[2], WIN0_WIDTH-MENU1_WIDTH, WIN0_HEIGHT-MENU3_HEIGHT,
                           0, 0, NULL, RedrawWin2, Win2Callback )) )
    ExitOnError ( "SetupApp3dGLWindow 0" );
  if ( !(mywdg = New3DWidget ( wm, GLWIN_ID_VIEW, wm->r.width, wm->r.height )) )
    ExitOnError ( "SetupApp3dGLWindow 1" );
  return wm;
} /*SetupApp3dGLWindow*/

/* ////////////////////////////////////////////////////////////////////////// */
void Win3Reshape ( xwinmenu* wm, short w, short h )
{
  RECT rect;

  myknotwdg->wdg.input ( &myknotwdg->wdg, WDGMSG_RECONFIGURE, 0,
                         w-MENU1_WIDTH, MENU3_HEIGHT-1 );
  XRectToWinRect ( &wm->r, &rect );
  InvalidateRect ( wm->window, &rect, false );
} /*Win3Reshape*/

void Win3Callback ( struct xwidget* wdg, int msg, int key, int x, int y )
{
  switch ( msg ) {
case WDGMSG_RECONFIGURE:
    Win3Reshape(wdg->wm, x, y);
    break;

case WDGMSG_BUTTON_PRESS:
    wm3->changed |= ProcessButtonCommand ( wdg->id );
    break;

case WDGMSG_SWITCH_CHANGE:
    ProcessSwitchCommand ( wdg->id );
    break;

case WDGMSG_KNOT_MCLICK:
    if ( key == 0 || key == 2 ) {
      ProcessKnotWidgetCommand ( wdg->id, msg, x );
      goto let_redraw_it;
    }
    break;

case WDGMSG_KNOT_MMOVE:
case WDGMSG_KNOT_CHANGE:
case WDGMSG_KNOT_INSERT:
case WDGMSG_KNOT_DELETE:
    ProcessKnotWidgetCommand ( wdg->id, msg, x );
let_redraw_it:
    wm1->changed = wm2->changed = wm3->changed = redraw = true;
    PostMenuExposeEvent ( wm1 );
    PostMenuExposeEvent ( wm2 );
    PostMenuExposeEvent ( wm3 );
    break;

case XWMSG_KEY_PRESS:
    mywdg->input(mywdg, msg, key, x, y);
    if ( wm2->changed )
      PostMenuExposeEvent ( wm2 );
    break;

default:
    break;
  }
} /*Win3Callback*/

void MyButtonRedraw ( struct xwidget* wdg )
{
  RECT  rect;
  POINT tr[3];

  XRectToWinRect ( &wdg->r, &rect );
  SetDCBrushColor ( hxwdgdc, XWP_BUTTON_COLOUR );
  FillRect ( hxwdgdc, &rect, hstockbrush );
  SetDCBrushColor ( hxwdgdc, XWP_TEXT_COLOUR );
  FrameRect ( hxwdgdc, &rect, hstockbrush );
  if ( wdg->state == WDGSTATE_DEFAULT ) {
    SelectObject ( hxwdgdc, hstockbrush );
    tr[0].x = tr[1].x = wdg->r.x + wdg->r.width / 2 - 4;  tr[2].x = wdg->r.x + wdg->r.width / 2 + 4;
    tr[0].y = wdg->r.y + 4;  tr[1].y = wdg->r.y + wdg->r.height - 4;
    tr[2].y = wdg->r.y + wdg->r.height / 2;
    Polygon ( hxwdgdc, tr, 3 );
  }
  else {
    rect.left = wdg->r.x + wdg->r.width/2 - 4;  rect.right = rect.left+3;
    rect.top = wdg->r.y+4;  rect.bottom = rect.top+8;
    FillRect ( hxwdgdc, &rect, hstockbrush );
    rect.left += 8;  rect.right += 8;
    FillRect ( hxwdgdc, &rect, hstockbrush );
  }
} /*MyButtonRedraw*/

xwinmenu* SetupApp3dWin3Menu ( void )
{
  KnotsWidgetf* kw;
  xwinmenu* wm;

  if ( !(wm = NewWinMenu ( window[3], WIN0_WIDTH, MENU3_HEIGHT,
                0, WIN0_HEIGHT-MENU3_HEIGHT, NULL, NULL, Win3Callback )) )
    ExitOnError ( "SetupApp3dWin3Menu" );
  kw = &appwdg->kw;
  myknotwdg = NewKnotsWidget ( wm, kw, KNOTWD_ID, WIN0_WIDTH-MENU1_WIDTH,
                MENU3_HEIGHT-4, MENU1_WIDTH, 4, 4, MAXKEYFRAMES, kw->nknots,
                kw->knots, kw->knots[0], kw->knots[kw->nknots-1] );
  kw->editswitch = true;
  kw->panswitch = kw->motion_off = false;
  NewButton ( wm, BTN_ID_LEFT, 16, 18, 0, 0, str_LEFT );
  NewButton ( wm, BTN_ID_SET, 22, 18, 19, 0, str_SET );
  NewButton ( wm, BTN_ID_RIGHT, 16, 18, 44, 0, str_RIGHT );
  playbtn = NewButton ( wm, BTN_ID_PLAY, 60, 18, 0, 20, NULL );
  playbtn->redraw = MyButtonRedraw;
  NewSwitch ( wm, SW_ID_ANIMATE_KL, 16, 16, 63, 20, NULL, &appwdg->animate_kl );
  NewSwitch ( wm, SW_ID_ANIMATE_MM, 16, 16, 82, 20, NULL, &appwdg->animate_mm );
  NewSwitch ( wm, SW_ID_ANIMATE_VP, 16, 16, 101, 20, NULL, &appwdg->animate_vp );
  NewSwitch ( wm, SW_ID_EDIT_KNOTS, 16, 16, 0, 40, str_EDIT,
              &kw->editswitch );
  NewSwitch ( wm, SW_ID_KNW_PANZOOM, 16, 16, 44, 40, str_PANZOOM,
              &kw->panswitch );
  return wm;
} /*SetupApp3dWin3Menu*/

LRESULT Win3MessageProc ( HWND window, UINT msg, WPARAM wParam, LPARAM lParam )
{
  LRESULT result = 0;

  if ( !wm3 )
    return DefWindowProcA ( window, msg, wParam, lParam );
  switch ( msg ) {
case WM_PAINT:
    WinMenuRedraw ( wm3 );
    break;
default:
    result = WinMenuInput ( wm3, msg, wParam, lParam );
    if ( wm3->changed )
      wm2->changed = redraw = true;
    break;
  }
  return result;
} /*Win3MessageProc*/

char ProcessWorldRequest ( int msg, void *data, void *reply )
{
  switch ( msg ) {
case WMSG_ANIMATION_ON:
    idlefunc = MyIdleFunc;
    playbtn->state = WDGSTATE_DEFAULT+1;
    wm3->changed = true;
    PostMenuExposeEvent ( wm3 );
    return true;
case WMSG_ANIMATION_OFF:
    idlefunc = NULL;
    playbtn->state = WDGSTATE_DEFAULT;
    wm3->changed = true;
    PostMenuExposeEvent ( wm3 );
    return true;
default:
    return false;
  }
} /*ProcessWorldRequest*/

/* ////////////////////////////////////////////////////////////////////////// */
void MessageLoop ( void )
{
  char terminate;

  for ( terminate = false; !terminate; ) {
    if ( PeekMessageA ( &msg, 0, 0, 0, PM_REMOVE ) ) {
      if ( msg.message == WM_QUIT )
        terminate = true;
      else {
        TranslateMessage ( &msg );
        DispatchMessage ( &msg );
      }
    }
    if ( redraw )
      RedrawWin2 ( wm2 );
    if ( idlefunc )
      idlefunc ();
    else
      WaitMessage ();
  }
} /*MessageLoop*/

void InitApp3dWindows ( HINSTANCE inst, int argc, char **argv, int major, int minor,
                       int width, int height )
{
  WNDCLASSA wclass;
  RECT      rect;
  DWORD     wstyle;

  memset ( &wclass, 0, sizeof(WNDCLASSA) );
  wclass.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
  wclass.lpfnWndProc = Win0MessageProc;
  wclass.hInstance = inst;
  wclass.hCursor = LoadCursor ( 0, IDC_ARROW );
  wclass.hbrBackground = 0;
  wclass.lpszClassName = "WGL_window";
  if ( !RegisterClassA ( &wclass ) )
    ExitOnError ( "Failed to register window class 0." );
  memset ( &rect, 0, sizeof(RECT) );
  rect.right = width;  rect.bottom = height;
  wstyle = WS_OVERLAPPEDWINDOW;
  AdjustWindowRect ( &rect, wstyle, 0 );
  window[0] = CreateWindowExA ( 0, wclass.lpszClassName, "Aplikacja 3D",
                        WS_OVERLAPPEDWINDOW, CW_USEDEFAULT, CW_USEDEFAULT,
                        rect.right-rect.left, rect.bottom-rect.top, 0, 0, inst, NULL );
  if ( !window[0] )
    ExitOnError ( "Failed to create window[0]." );
  wclass.cbClsExtra = sizeof(long);
  wclass.hIcon = NULL;
  wclass.lpfnWndProc = Win1MessageProc;
  wclass.lpszClassName = "WGL_subwindow_1";
  if ( !RegisterClassA ( &wclass ) )
    ExitOnError ( "Failed to register window class 1." );
  window[1] = CreateWindowExA ( 0, wclass.lpszClassName, "", WS_CHILD,
        0, 0, MENU1_WIDTH, height-MENU3_HEIGHT, window[0], 0, inst, NULL );
  wclass.lpfnWndProc = Win2MessageProc;
  wclass.lpszClassName = "WGL_subwindow_2";
  if ( !RegisterClassA ( &wclass ) )
    ExitOnError ( "Failed to register window class 2." );
  window[2] = CreateWindowExA ( 0, wclass.lpszClassName, "", WS_CHILD,
        MENU1_WIDTH, 0, width-MENU1_WIDTH, height-MENU3_HEIGHT, window[0], 0, inst, NULL );
  wclass.lpfnWndProc = Win3MessageProc;
  wclass.lpszClassName = "WG_subwindow_3";
  if ( !RegisterClassA ( &wclass ) )
    ExitOnError ( "Failed to register window class 3." );
  window[3] = CreateWindowExA ( 0, wclass.lpszClassName, "", WS_CHILD,
        0, height-MENU1_WIDTH, width, MENU3_HEIGHT, window[0], 0, inst, NULL );
  InitWinMenuPalette ();
  window0_width = width;
  window0_height = height;
} /*InitApp3dWindows*/

void Initialise ( HINSTANCE inst, int argc, char **argv )
{
  int i;

  InitWGLExtensions ( APP3D_GL_MAJOR, APP3D_GL_MINOR );
  InitApp3dWindows ( inst, argc, argv, APP3D_GL_MAJOR, APP3D_GL_MINOR,
                     WIN0_WIDTH, WIN0_HEIGHT );
  gldc = GetDC ( window[2] );
  wglcontext = InitWGLContext ( gldc, APP3D_GL_MAJOR, APP3D_GL_MINOR, 0, NULL );
  for ( i = 0; i < 4; i++ )
    ShowWindow ( window[i], true );
  appwdg = InitMyWorld ( argc, argv, WIN0_WIDTH-MENU1_WIDTH,
                         WIN0_HEIGHT-MENU3_HEIGHT );
  wm1 = SetupApp3dMenu ();
  wm2 = SetupApp3dGLWindow ();
  wm3 = SetupApp3dWin3Menu ();
  PostMenuExposeEvent ( wm1 );
  PostMenuExposeEvent ( wm3 );
} /*Initialise*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  DeleteWinMenu ( wm1 );
  DeleteWinMenu ( wm2 );
  DeleteWinMenu ( wm3 );
  DestroyWindow ( window[0] );
} /*Cleanup*/

int main ( int argc, char **argv )
{
  Initialise ( GetModuleHandle ( 0 ), argc, argv );
  MessageLoop ();
  Cleanup ();
  exit ( 0 );
} /*main*/
