#version 450 core

#define MAX_NLIGHTS 8

layout(triangles) in;
layout(triangle_strip,max_vertices=3) out;

in GVertex {
    vec4 Normal;
    vec4 ShadowPos[MAX_NLIGHTS];
  } In[];

out FVertex {
    vec3 Position;
    vec3 Normal, TNormal;
    vec4 ShadowPos[MAX_NLIGHTS];
  } Out;

layout(std430,binding=3) buffer meshsurf {
    int  nv, nhe, nfac, nsattr, pdim, pofs, nvofs;
    bool MeshNormals;
    vec3 Colour;
  };

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm;
    vec4 eyepos;
  } trb;

struct LSPar {
    vec4 position;
    vec3 ambient;
    vec3 direct;
    vec3 attenuation;
    mat4 shadow_vpm;
  };

uniform LSBlock {
    uint  nls;              /* liczba zrodel swiatla */
    uint  mask;             /* maska wlaczonych zrodel */
    uint  shmask;           /* maska tekstur cienia */
    LSPar ls[MAX_NLIGHTS];  /* poszczegolne zrodla swiatla */
  } light;

void main ( void )
{
  uint  i, l, mask;
  vec4 p[3];
  vec3 q[3], nv[3], v1, v2, tnv;

  for ( i = 0; i < 3; i++ ) {
    p[i] = trb.mm * gl_in[i].gl_Position;
    q[i] = p[i].xyz/p[i].w;
    nv[i] = normalize ( (trb.mmti * In[i].Normal).xyz );
  }
  v1 = q[1] - q[0];  v2 = q[2] - q[0];
  tnv = normalize ( cross ( v2, v1 ) );
  for ( i = 0; i < 3; i++ ) {
    gl_Position = trb.vpm * p[i];
    Out.Position = q[i];
    if ( !MeshNormals || dot ( nv[i], nv[i] ) < 1.0e-10 )
      Out.Normal = Out.TNormal = tnv;
    else {
      Out.Normal = nv[i];
      Out.TNormal = dot ( nv[i], tnv ) > 0.0 ? tnv : -tnv;
    }
    for ( l = 0, mask = 0x00000001;  l < light.nls;  l++, mask <<= 1 )
      if ( (light.mask & mask) != 0 )
        Out.ShadowPos[l] = In[i].ShadowPos[l];
    EmitVertex ();
  }
  EndPrimitive ();
} /*main*/

