#version 430 core

layout (vertices=1) out;

layout (location=0) in int instance[];

layout (location=0) out int inst[];

layout(std430,binding=2) buffer BezPatch {
    int  npatches, dim, udeg, vdeg;
    int  stride_u, stride_v, stride_p, stride_q, nq;
    bool use_ind;
    vec3 Colour;
    int  TessLevel;
    bool BezNormals;
  } bezp;

void main ( void )
{
  if ( gl_InvocationID == 0 ) {
    gl_TessLevelOuter[0] = gl_TessLevelOuter[1] =
    gl_TessLevelOuter[2] = gl_TessLevelOuter[3] = bezp.TessLevel;
    gl_TessLevelInner[0] = gl_TessLevelInner[1] = bezp.TessLevel;
    inst[gl_InvocationID] = instance[gl_InvocationID];
  }
} /*main*/
