#version 450 core

layout(location=0) in vec4 in_Position;

layout(location=0) out vec3 colour;

layout(std430,binding=0) buffer meshvf { int mvf[];   } mvf;
layout(std430,binding=1) buffer meshhe { ivec4 mhe[]; } mhe;
layout(std430,binding=2) buffer meshvc { float vc[];  } mvc;
layout(std430,binding=3) buffer meshsurf {
    int  nv, nhe, nfac, nsattr, pdim, pofs, nvofs;
    bool MeshNormals;
    vec3 Colour;
  };
                       
uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm;
    vec4 eyepos;
  } trb;

#define FHEMASK  0x01FFFFFF
#define V0       x
#define mhe(I)   mhe.mhe[I]
#define mfac(I)  mvf.mvf[nv+(I)]
#define mfhei(I) mvf.mvf[nv+nfac+nhe+(I)]
#define mvc(I)   mvc.vc[I]

void main ( void )
{
  int  i, j;
  vec4 pos;

  i = mhe(mfhei((mfac(gl_InstanceID) & FHEMASK) + gl_VertexID)).V0;
  j = nsattr*i + pofs;
  switch ( pdim ) {
case 2:
    pos = vec4( mvc(j), mvc(j+1), 0.0, 1.0 );
    break;
case 3:
    pos = vec4( mvc(j), mvc(j+1), mvc(j+2), 1.0 );
    break;
default:
    pos = vec4( mvc(j), mvc(j+1), mvc(j+2), mvc(j+3) );
    break;
  }
  gl_Position = trb.vpm * (trb.mm * pos);
  colour = Colour;
} /*main*/

