#version 430

#define MAX_NLIGHTS 8

layout(triangles) in;
layout(triangle_strip,max_vertices=3) out;

in GVertex {
  vec4 Normal;
  vec4 ShadowPos[MAX_NLIGHTS];
} In[];

out FVertex {
  vec3 Position;
  vec3 Normal, TNormal;
  vec4 ShadowPos[MAX_NLIGHTS];
} Out;

layout(std430,binding=0) buffer CPoints {
    float cp[];
  } cp;

layout(std430,binding=1) buffer CPIndices {
    int cpi[];
  } cpi;

layout(std430,binding=2) buffer BezPatch {
    int  npatches, dim, udeg, vdeg;
    int  stride_u, stride_v, stride_p, stride_q, nq;
    bool use_ind;
    vec3 Colour;
    int  TessLevel;
    bool BezNormals;
  } bezp;

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm;
    vec4 eyepos;
  } trb;

struct LSPar {
    vec4 position;
    vec3 ambient;
    vec3 direct;
    vec3 attenuation;
    mat4 shadow_vpm;
  };

uniform LSBlock {
    uint  nls;              /* liczba zrodel swiatla */
    uint  mask;             /* maska wlaczonych zrodel */
    uint  shmask;           /* maska tekstur cienia */
    LSPar ls[MAX_NLIGHTS];  /* poszczegolne zrodla swiatla */
  } light;

void main ( void )
{
  int  i, l, mask;
  vec4 p[3];
  vec3 q[3], nv[3], v1, v2, tnv;

  for ( i = 0; i < 3; i++ ) {
    p[i] = trb.mm * gl_in[i].gl_Position;
    q[i] = p[i].xyz/p[i].w;
    nv[i] = normalize ( (trb.mmti * In[i].Normal).xyz );
  }
  v1 = q[1] - q[0];  v2 = q[2] - q[0];
  tnv = normalize ( cross ( v1, v2 ) );
  for ( i = 0; i < 3; i++ ) {
    gl_Position = trb.vpm * p[i];
    Out.Position = q[i];
    if ( !bezp.BezNormals || dot ( nv[i], nv[i] ) < 1.0e-10 )
      Out.Normal = Out.TNormal = tnv;
    else {
      Out.Normal = nv[i];
      Out.TNormal = dot ( nv[i], tnv ) > 0.0 ? tnv : -tnv;
    }
    for ( l = 0, mask = 0x00000001;  l < light.nls;  l++, mask <<= 1 )
      if ( (light.mask & mask) != 0 )
        Out.ShadowPos[l] = In[i].ShadowPos[l];
    EmitVertex ();
  }
  EndPrimitive ();
} /*main*/
