
#define MESHDEG         3
#define NPALMMESHES     4
#define NKLOBJ         1
#define NKLINKS       21
#define NKLREFS       17
#define NKLJOINTS     20
#define NKLARTPARAMS  20

typedef struct {
    GLuint progid[2];
  } MeshRenderPrograms;

typedef struct {
    GLuint progid;
    GLuint dim_loc, ncp_loc, trnum_loc;
    GLuint cpibp, cpobp, ctrbp, ctribp;
  } KLArticulationProgram;

typedef struct {
    GPUmesh *mesh[NPALMMESHES+2];
    GLfloat ecolour[3], fcolour[3];
    GLuint  tribuf;
  } KLMesh;

typedef struct {
    int    win_width, win_height;
    float  left, right, top, bottom, near, far, rl, tb;
    float  viewer_pos0[4], viewer_rvec[3];
    double viewer_rangle;
  } Camera;

typedef struct {
    AppWidgets            wdg;
    KLMesh                palm;
    kl_linkage            *linkage;
    Camera                camera;
    TransBl               trans;
    LightBl               light;
    GLuint                lktrbuf;
    char                  lod, edges, mnv;
    float                 speed;
    float                 model_rot_axis[3];
    double                model_rot_angle;
    MeshRenderPrograms    mrprog;
    KLArticulationProgram artprog;
  } AppData;


void LoadMeshRenderingPrograms ( MeshRenderPrograms *prog );
void DeleteMeshRenderingPrograms ( MeshRenderPrograms *prog );
void DrawMeshEdges ( MeshRenderPrograms *prog,
                     GPUmesh *mesh, GLfloat colour[3] );
void DrawMeshFacets ( MeshRenderPrograms *prog,
                      GPUmesh *mesh, GLfloat colour[3], char nvs );


void LoadLinkageArticulationProgram ( KLArticulationProgram *prog );
void DeleteLinkageArticulationProgram ( KLArticulationProgram *prog );
kl_linkage *ConstructPalmLinkage ( AppData *ad );
void SetArticulationParameter ( AppData *ad, int pnum );
void ArticulatePalmLinkage ( AppData *ad );

