#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#include "../utilities/openglheader.h"

#include "../utilities/xwidgets.h"
#include "../utilities/initglxctx.h"
#include "../utilities/utilities.h"
#include "app3b.h"
#include "app3bproc.h"

#define WIN0_WIDTH   480
#define WIN0_HEIGHT  360
#define MENU_WIDTH   120

#define WDGSTATE_VIEW_TURNING 1

typedef struct {
    int  last_x, last_y;
    char opti;
  } widget3d;

static Window     window[3];
static GLXContext glxcontext;
static char       terminate;
static Atom       aAnimate;

static int        window0_width, window0_height;
static xwinmenu   *wm1, *wm2;
static xwidget    *mywdg;
static AppWidgets *appwdg;

static char str_EXIT[] = "Exit";

void Win1Callback ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  switch ( msg ) {
case WDGMSG_BUTTON_PRESS:
    switch ( wdg->id ) {
  case BTN_ID_EXIT:
      terminate = true;
      break;
  default:
      break;
    }
    break;

case WDGMSG_SWITCH_CHANGE:
    ProcessSwitchCommand ( wdg->id );
    goto redraw_win2;

case WDGMSG_SLIDEBAR_CHANGE:
    ProcessSlidebarCommand ( wdg->id );
redraw_win2:
    wm2->changed = true;
    PostMenuExposeEvent ( wm2 );
    break;

case XWMSG_KEY_PRESS:
    mywdg->input ( mywdg, msg, key, x, y );
    if ( wm2->changed )
      PostMenuExposeEvent ( wm2 );
    break;

default:
    break;
  }
} /*Win1CallBack*/

xwinmenu *SetupApp3bMenu ( void )
{
  xwinmenu *wm;
  int      i;

  if ( !(wm = NewWinMenu ( window[1], MENU_WIDTH, WIN0_HEIGHT, 0, 0,
                           NULL, NULL, Win1Callback )) )
    ExitOnError ( "SetupApp3bMenu" );
  NewButton ( wm, BTN_ID_EXIT, 60, 18, 2, 2, str_EXIT );
  for ( i = 0; i <= NPALMMESHES; i++ )
    NewSwitch ( wm, SW_ID_MESH0+i, 16, 16, 2+20*i, 22, NULL, &appwdg->sw[i] );
  for ( i = 0; i < NKLARTPARAMS; i++ )
    NewSlidebarf ( wm, SL_ID_ARTP0+i, 116, 10, 2, 46+15*i, &appwdg->artp[i] );
  return wm;
} /*SetupApp3Menu*/

/* ////////////////////////////////////////////////////////////////////////// */
void Win0MessageProc ( XEvent *ev )
{
  XClientMessageEvent *xclient;

  switch ( ev->xany.type ) {
case ConfigureNotify:
    XMoveResizeWindow ( xdisplay, window[1], 0, 0,
                      MENU_WIDTH, window0_height = ev->xconfigure.height );
    XMoveResizeWindow ( xdisplay, window[2], MENU_WIDTH, 0,
                        (window0_width = ev->xconfigure.width)-MENU_WIDTH,
                        window0_height );
    break;
case ClientMessage:
    xclient = (XClientMessageEvent *)ev;
    if ( xclient->message_type == WMProtocols &&
         (Atom)xclient->data.l[0] == DeleteWindow ) {
      terminate = true;
      break;
    }
default:
    break;
  }
} /*Win0MessageProc*/

/* ////////////////////////////////////////////////////////////////////////// */
void My3DWidgetRedraw ( struct xwidget *wdg )
{
  RedrawMyWorld ();
} /*My3DWidgetRedraw*/

char My3DWidgetInput ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  XClientMessageEvent *xclient;
  widget3d            *ww;

  ww = (widget3d*)wdg->data0;
  switch ( wdg->state ) {
case WDGSTATE_DEFAULT:
    switch ( msg ) {
  case XWMSG_BUTTON_PRESS:
      if ( key == Button1 ) {
        ww->last_x = x;  ww->last_y = y;
        wdg->state = WDGSTATE_VIEW_TURNING;
        GrabInput ( wdg );
        return true;
      }
      break;
  case XWMSG_KEY_PRESS:
      goto process_key;
  case WDGMSG_RECONFIGURE:
      ResizeMyWorld ( wdg->r.width = x, wdg->r.height = y );
      break;
  case XWMSG_CLIENT_MESSAGE:
      goto process_client_message;
  case XWMSG_DELETE:
      goto process_delete_message;
  default:
      break;
    }
    break;

case WDGSTATE_VIEW_TURNING:
    switch ( msg ) {
  case XWMSG_MOUSE_MOTION:
      if ( ((XMotionEvent*)wdg->wm->ev)->state & Button1Mask ) {
        RotateViewer ( (double)(x - ww->last_x), (double)(y - ww->last_y) );
        ww->last_x = x;  ww->last_y = y;
        wdg->wm->changed = true;
      }
      else
        goto release;
      break;
  case XWMSG_BUTTON_RELEASE:
      if ( key == Button1 ) {
release:
        wdg->state = WDGSTATE_DEFAULT;
        UngrabInput ( wdg );
        return true;
      }
      break;
  case XWMSG_KEY_PRESS:
process_key:
      if ( ProcessCharCommand ( key ) )
        return wdg->wm->changed = true;
      break;
  case XWMSG_CLIENT_MESSAGE:
process_client_message:
      xclient = (XClientMessageEvent*)wdg->wm->ev;
      if ( xclient->message_type == aAnimate && appwdg->animation ) {
        if ( MoveOn () ) {
          wm2->changed = true;
          PostMenuExposeEvent ( wm2 );
        }
        PostClientMessageEvent ( window[2], aAnimate, 8, NULL );
      }
      break;
  case XWMSG_DELETE:
process_delete_message:
      free ( wdg->data0 );
      return true;
  default:
      break;
    }
    break;

default:
    break;
  }
  return false;
} /*My3DWidgetInput*/

xwidget *New3DWidget ( struct xwinmenu *wm, int id, int w, int h )
{
  widget3d *ww;

  if ( !(ww = malloc ( sizeof(widget3d) )) )
    ExitOnError ( "New3DWidget" );
  ww->opti = 0;
  return NewWidget ( wm, sizeof(xwidget), id, w, h, 0, 0,
                     My3DWidgetInput, My3DWidgetRedraw, ww, NULL );
} /*New3DWidget*/

void RedrawWin2 ( xwinmenu *wm )
{
  widget3d *ww;

  ww = (widget3d*)mywdg->data0;
  if ( ww->opti > 0 ) {
    ww->opti --;
    PostExposeEvent ( wm->window, wm->r.width, wm->r.height );
  }
  else
    mywdg->redraw ( mywdg );
  glXSwapBuffers ( xdisplay, wm->window );
} /*RedrawWin2*/

void Win2Callback ( struct xwidget *wdg, int msg, int key, int x, int y )
{
  widget3d *ww;

  ww = (widget3d*)mywdg->data0;
  switch ( msg ) {
case WDGMSG_RECONFIGURE:
    mywdg->input ( mywdg, WDGMSG_RECONFIGURE, 0, x, y );
    ww->opti = 4;
    PostMenuExposeEvent ( wdg->wm );
    break;
case XWMSG_CLIENT_MESSAGE:
    mywdg->input ( mywdg, msg, key, x, y );
    break;
default:
    break;
  }
} /*Win2Callback*/

xwinmenu *SetupApp3bGLWindow ( void )
{
  xwinmenu *wm;

  if ( !(wm = NewWinMenu ( window[2], WIN0_WIDTH-MENU_WIDTH, WIN0_HEIGHT, 0, 0,
                           NULL, RedrawWin2, Win2Callback )) )
    ExitOnError ( "SetupApp3bGLWindow 0" );
  if ( !(mywdg = New3DWidget ( wm, GLWIN_ID_VIEW, wm->r.width, wm->r.height )) )
    ExitOnError ( "SetupApp3bGLWindow 1" );
  return wm;
} /*SetupApp3bGLWindow*/

/* ////////////////////////////////////////////////////////////////////////// */
char ProcessWorldRequest ( int msg, void *data, void *reply )
{
  switch ( msg ) {
case WMSG_ANIMATION_ON:
    PostClientMessageEvent ( window[2], aAnimate, 8, NULL );
    return true;
case WMSG_ANIMATION_OFF:
    return true;
default:
    return false;
  }
} /*ProcessWorldRequest*/

/* ////////////////////////////////////////////////////////////////////////// */
void MessageLoop ( void )
{
  XEvent ev;

  terminate = false;
  do {
    XNextEvent ( xdisplay, &ev );
    if ( ev.xany.window == window[0] )
      Win0MessageProc ( &ev );
    else if ( ev.xany.window == window[1] )
      WinMenuInput ( wm1, &ev );
    else if ( ev.xany.window == window[2] )
      WinMenuInput ( wm2, &ev );
  } while ( !terminate );
} /*MessageLoop*/

void InitApp3bWindows ( int argc, char **argv, int major, int minor )
{
  int vattr[] =
    {
      GLX_RGBA,           True,
      GLX_DOUBLEBUFFER,   True,
      GLX_RED_SIZE,       8,
      GLX_GREEN_SIZE,     8,
      GLX_BLUE_SIZE,      8,
      GLX_DEPTH_SIZE,    24,
      GLX_SAMPLE_BUFFERS, True,
      GLX_SAMPLES,        8,
      None };
  static const int     wx[3] = { 0, 0, MENU_WIDTH };
  static const int     wh[3] = { WIN0_WIDTH, MENU_WIDTH, WIN0_WIDTH-MENU_WIDTH };
  XVisualInfo          *xvii;
  Colormap             xcolormap;
  XSetWindowAttributes swa;
  Window               upw;
  int                  i;

  InitGLXContext ( major, minor, 0, vattr, &xvii, &glxcontext );
  if ( !(xcolormap = XCreateColormap ( xdisplay, xrootwin,
                                       xvii->visual, AllocNone )) )
    ExitOnError ( "InitApp3bWindows 1" );
  swa.colormap = xcolormap;
  swa.event_mask = ExposureMask | StructureNotifyMask| ButtonPressMask |
                   ButtonReleaseMask | PointerMotionMask | KeyPressMask ;
  for ( i = 0, upw = xrootwin; i < 3; i++, upw = window[0] ) {
    window[i] = XCreateWindow ( xdisplay, upw, wx[i], 0, wh[i], WIN0_HEIGHT,
                             0, xvii->depth, InputOutput, xvii->visual,
                             CWColormap | CWEventMask, &swa );
    XMapWindow ( xdisplay, window[i] );
  }
  XSetWMProtocols ( xdisplay, window[0], &DeleteWindow, 1 );
  XStoreName ( xdisplay, window[0], "Aplikacja 3B" );
  xgc = XCreateGC ( xdisplay, window[1], 0, 0 );
  InitRGBXColourmap ( xvii ); 
  XFreeColormap ( xdisplay, xcolormap );
  XFree ( xvii );
  InitWinMenuPalette ();
  if ( !glXMakeCurrent ( xdisplay, window[2], glxcontext ) )
    ExitOnError ( "InitApp3bWindows 2" );
  GetGLProcAddresses ( major, minor );
  PrintGLVersion ();
  window0_width = WIN0_WIDTH;
  window0_height = WIN0_HEIGHT;
} /*InitApp3bWindows*/

void Initialise ( int argc, char **argv )
{
  InitXServerConnection ( argc, argv, false );
  InitApp3bWindows ( argc, argv, APP3B_GL_MAJOR, APP3B_GL_MINOR );
  aAnimate = XInternAtom ( xdisplay, "aAnimate", False );
  appwdg = InitMyWorld ( argc, argv, WIN0_WIDTH-MENU_WIDTH, WIN0_HEIGHT );
  wm1 = SetupApp3bMenu ();
  wm2 = SetupApp3bGLWindow ();
} /*Initialise*/

void Cleanup ( void )
{
  DeleteMyWorld ();
  DeleteWinMenu ( wm1 );
  DeleteWinMenu ( wm2 );
  XDestroySubwindows ( xdisplay, window[0] );
  XDestroyWindow ( xdisplay, window[0] );
  XFreeGC ( xdisplay, xgc );
  XCloseDisplay ( xdisplay );
} /*Cleanup*/

int main ( int argc, char **argv )
{
  Initialise ( argc, argv );
  MessageLoop ();
  Cleanup ();
  exit ( 0 );
} /*main*/
