#version 450 core

#define FHEMASK  0x01FFFFFF

#define V0   x
#define FACN z

layout(location=0) out vec3 Normal;
layout(location=1) out vec3 colour;

layout(std430,binding=0) buffer Mvf { int   mvf[]; } mmvf;
layout(std430,binding=1) buffer Mhe { ivec4 mhe[]; } mmhe;
layout(std430,binding=2) buffer Mvc { float vc[];  } mmvc;
layout(std430,binding=3) buffer meshsurf {
    int  nv, nhe, nfac, nsattr, pdim, pofs, nvofs;
    bool MeshNormals;
    vec3 Colour;
  };

#define mfac(I)  mmvf.mvf[nv+(I)]
#define mfhei(I) mmvf.mvf[nv+nfac+nhe+(I)]
#define mhe(I)   mmhe.mhe[I]   
#define mvc(I)   mmvc.vc[I]

void main ( void )
{
  int i, j;

  i = mhe(mfhei((mfac(gl_InstanceID) & FHEMASK) + gl_VertexID)).V0;
  j = nsattr*i + pofs;
  switch ( pdim ) {
case 2:
    gl_Position = vec4( mvc(j), mvc(j+1), 0.0, 1.0 );
    Normal = vec3 ( 0.0, 0.0, 1.0 );
    return;
case 3:
    gl_Position = vec4( mvc(j), mvc(j+1), mvc(j+2), 1.0 );
    break;
default:
    gl_Position = vec4( mvc(j), mvc(j+1), mvc(j+2), mvc(j+3) );
    break;
  }
  if ( nvofs >= 0 && MeshNormals ) {
    j = nsattr*i + nvofs;
    Normal = vec3 ( mvc(j), mvc(j+1), mvc(j+2) );
  }
  else
    Normal = vec3 ( 0.0 );
  colour = Colour;
} /*main*/
