
#define MESHDEG         3
#define NPALMMESHES     4

typedef struct {
    GLuint progid[2];
  } MeshRenderPrograms;

typedef struct {
    GPUmesh *mesh[NPALMMESHES+1];
    GLfloat ecolour[3], fcolour[3];
  } KLMesh;

typedef struct {
    int     win_width, win_height;
    float   left, right, top, bottom, near, far, rl, tb;
    float   viewer_pos0[4], viewer_rvec[3];
    double  viewer_rangle;
  } Camera;

typedef struct {
    AppWidgets          wdg;
    KLMesh              palm;
    Camera              camera;
    TransBl             trans;
    LightBl             light;
    char                lod, edges, mnv;
    float               speed;
    float               model_rot_axis[3];
    double              model_rot_angle;
    MeshRenderPrograms  mrprog;
  } AppData;


void LoadMeshRenderingPrograms ( MeshRenderPrograms *prog );
void DeleteMeshRenderingPrograms ( MeshRenderPrograms *prog );
void DrawMeshEdges ( MeshRenderPrograms *prog,
                     GPUmesh *mesh, GLfloat colour[3] );
void DrawMeshFacets ( MeshRenderPrograms *prog,
                      GPUmesh *mesh, GLfloat colour[3], char nvs );

