#version 450 core

layout(location=0) out vec3 colour;

layout(std430,binding=0) buffer meshvf { int mvf[];   } mvf;
layout(std430,binding=1) buffer meshhe { ivec4 mhe[]; } mhe;
layout(std430,binding=2) buffer meshvc { float vc[];  } mvc;
layout(std430,binding=3) buffer meshsurf {
    int  nv, nhe, nfac, nsattr, pdim, pofs, nvofs;
    bool MeshNormals;
    vec3 Colour;
  };

#define FHEMASK  0x01FFFFFF
#define V0       x
#define mfac(I)  mvf.mvf[nv+(I)]
#define mfhei(I) mvf.mvf[nv+nfac+nhe+(I)]

#define FetchVertex(I) \
  switch ( pdim ) { \
case 2: \
    gl_Position = vec4( mvc.vc[I], mvc.vc[(I)+1], 0.0, 1.0 );  break; \
case 3: \
    gl_Position = vec4( mvc.vc[I], mvc.vc[(I)+1], mvc.vc[(I)+2], \
                        1.0 );  break; \
default: \
    gl_Position = vec4( mvc.vc[I], mvc.vc[(I)+1], mvc.vc[(I)+2], \
                        mvc.vc[(I)+3] );  break; \
  }

void main ( void )
{
  int i;

  i = mhe.mhe[mfhei((mfac(gl_InstanceID) & FHEMASK) + gl_VertexID)].V0;
  i = nsattr*i + pofs;
  FetchVertex ( i );
  colour = Colour;
} /*main*/

