#version 450 core

layout(triangles) in;
layout(triangle_strip,max_vertices=3) out;

layout(location=0) in vec3 Colour[];

out FVertex {
    vec3 Colour;
    vec3 Position;
    flat vec3 Normal;
  } Out;

uniform TransBlock {
    mat4 mm, mmti, vm, pm, vpm;
    vec4 eyepos;
  } trb;

void main ( void )
{
  int  i;
  vec4 p[3];
  vec3 q[3], v1, v2, nv;

  for ( i = 0; i < 3; i++ ) {
    p[i] = trb.mm * gl_in[i].gl_Position;
    q[i] = p[i].xyz/p[i].w;
  }
  v1 = q[1] - q[0];  v2 = q[2] - q[0];
  nv = normalize ( cross ( v1, v2 ) );
  for ( i = 0; i < 3; i++ ) {
    gl_Position = trb.vpm * p[i];
    Out.Colour = Colour[i];
    Out.Position = q[i];
    Out.Normal = i == 0 ? nv : vec3(0.0);
    EmitVertex ();
  }
  EndPrimitive ();
} /*main*/

