
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"

#ifdef USE_GL3W
#define tglGenBuffers    gl3w_glGenBuffers
#define tglDeleteBuffers gl3w_glDeleteBuffers
#else
#ifdef USE_GLAD
#define tglGenBuffers    glad_glGenBuffers
#define tglDeleteBuffers glad_glDeleteBuffers
#endif
#endif

#ifdef DEBUG_BUFFERS_ALLOCATION
#define MAXNBUF 512
static char buf_id[MAXNBUF];

void traceglGenBuffers ( GLsizei n, GLuint *buffers, char *file, int line )
{
  int i;

  fprintf ( stderr, "%s (%d): ", file, line );
  for ( i = 0; i < n; i++ )
    if ( buffers[i] ) {
      fprintf ( stderr, "+%d%s", buffers[i], i == n-1 ? "" : ", " );
      if ( buffers[i] < MAXNBUF )
        buf_id[buffers[i]] = true;
    }
  fprintf ( stderr, "\n" );
} /*traceglGenBuffers*/

void traceglDeleteBuffers ( GLsizei n, GLuint *buffers, char *file, int line )
{
  int  i;
  char c;

  fprintf ( stderr, "%s (%d): ", file, line );
  for ( i = 0; i < n; i++ )
    if ( buffers[i] ) {
      if ( buffers[i] < MAXNBUF ) {
        if ( buf_id[buffers[i]] )
          { buf_id[buffers[i]] = false;  c = '-'; }
        else
          c = '!';
      }
      fprintf ( stderr, "%c%d%s", c, buffers[i], i == n-1 ? "" : ", " );
    }
  fprintf ( stderr, "\n" );
} /*traceglDeleteBuffers*/

void DumpBufferIdentifiers ( void )
{
  int  i;
  char u;

  fprintf ( stderr, "Undeleted buffers: " );
  for ( i = 1, u = false;  i < MAXNBUF;  i++ )
    if ( buf_id[i] ) {
      u = true;
      fprintf ( stderr, "%d, ", i );
    }
  if ( !u )
    fprintf ( stderr, "none" );
  fprintf ( stderr, "\n" );
} /*DumpBufferIdentifiers*/
#endif
