#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <math.h>
#include "../utilities/openglheader.h"

#include "../utilities/utilities.h"
#include "accumbuf.h"

#define ACCBUF_AVERAGE  0
#define ACCBUF_ANAGLYPH 1

static GLuint accprid;
static GLuint action_loc;

char LoadAccumBufShaders ( void )
{
  static const char *filename[] = { "accbuf0.comp.glsl" };
  GLuint accshid;

  accshid = CompileShaderFiles ( GL_COMPUTE_SHADER, 1, &filename[0] );
  accprid = LinkShaderProgram ( 1, &accshid, "acc0" );
  glDeleteShader ( accshid );
  action_loc = glGetUniformLocation ( accprid, "action" );
  ExitIfGLError ( "LoadAccumBufShaders" );
  return true;
} /*LoadAccumBufShaders*/

void DeleteAccumBufShaders ( void )
{
  glUseProgram ( 0 );
  glDeleteProgram ( accprid );
  ExitIfGLError ( "DeleteAccumBufShaders" );
} /*DeleteAccumBufShaders*/

static char AllocAccTextures ( AccumBuf *acb, int w, int h )
{
  glGenTextures ( 3, acb->txt );
  glBindTexture ( GL_TEXTURE_2D, acb->txt[0] );
  glTexStorage2D ( GL_TEXTURE_2D, 1, GL_RGBA32F, w, h );
  glBindTexture ( GL_TEXTURE_2D, 0 );
  glBindFramebuffer ( GL_FRAMEBUFFER, acb->fbo[0] );
  glFramebufferTexture ( GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, acb->txt[0], 0 );
  if ( glCheckFramebufferStatus ( GL_FRAMEBUFFER ) != GL_FRAMEBUFFER_COMPLETE )
    ExitOnError ( "AllocAccTextures 0" );
  glBindTexture ( GL_TEXTURE_2D_ARRAY, acb->txt[1] );
  glTexStorage3D ( GL_TEXTURE_2D_ARRAY, 1, GL_RGBA32F, w, h, NLAYERS );
  glBindTexture ( GL_TEXTURE_2D_ARRAY, acb->txt[2] );
  glTexStorage3D ( GL_TEXTURE_2D_ARRAY, 1, GL_DEPTH_COMPONENT32F, w, h, NLAYERS );
  glBindTexture ( GL_TEXTURE_2D_ARRAY, 0 );
  glBindFramebuffer ( GL_FRAMEBUFFER, acb->fbo[1] );
  glFramebufferTexture ( GL_FRAMEBUFFER, GL_COLOR_ATTACHMENT0, acb->txt[1], 0 );
  glFramebufferTexture ( GL_FRAMEBUFFER, GL_DEPTH_ATTACHMENT, acb->txt[2], 0 );
  if ( glCheckFramebufferStatus ( GL_FRAMEBUFFER ) != GL_FRAMEBUFFER_COMPLETE )
    ExitOnError ( "AllocAccTextures 1" );
  glBindFramebuffer ( GL_FRAMEBUFFER, 0 );
  acb->width = w;  acb->height = h;
  ExitIfGLError ( "AllocAccTextures" );
  return true;
} /*AllocAccTextures*/

AccumBuf *NewAccumBuf ( int w, int h )
{
  AccumBuf *acb;

  if ( (acb = malloc ( sizeof(AccumBuf) )) ) {
    glGenFramebuffers ( 2, acb->fbo );
    if ( AllocAccTextures ( acb, w, h ) )
      return acb;
    else {
      glDeleteFramebuffers ( 2, acb->fbo );
      free ( acb );
    }
  }
  return NULL;
} /*NewAccumBuf*/

char SetAccumBufSize ( AccumBuf *acb, int w, int h )
{
  if ( w != acb->width || h != acb->height ) {
    glDeleteTextures ( 3, acb->txt );
    if ( !AllocAccTextures ( acb, w, h ) ) {
      glDeleteFramebuffers ( 2, acb->fbo );
      free ( acb );
      return false;
    }
  }
  return true;
} /*SetAccumBufSize*/

void DeleteAccumBuf ( AccumBuf *acb )
{
  glDeleteFramebuffers ( 2, acb->fbo );
  glDeleteTextures ( 3, acb->txt );
  free ( acb );
} /*DeleteAccumBuf*/

void AccumBufAverage ( AccumBuf *acb, char stereo )
{
  glUseProgram ( accprid );
  glUniform1i ( action_loc, stereo ? ACCBUF_ANAGLYPH : ACCBUF_AVERAGE );
  glBindImageTexture ( 0, acb->txt[0], 0, GL_FALSE, 0, GL_READ_WRITE, GL_RGBA32F );
  glBindImageTexture ( 1, acb->txt[1], 0, GL_FALSE, 0, GL_READ_ONLY, GL_RGBA32F );
  glDispatchCompute ( acb->width, acb->height, 1 );
  glMemoryBarrier ( GL_SHADER_IMAGE_ACCESS_BARRIER_BIT );
  ExitIfGLError ( "AccumBufAverage" );
} /*AccumBufAverage*/

