#version 450 core

#define NLAYERS        16
#define ACCBUF_AVERAGE  0
#define ACCBUF_ANAGLYPH 1

layout(local_size_x=1) in;
layout(rgba32f,binding=0) uniform image2D accb;
layout(rgba32f,binding=1) uniform image2DArray img;
layout(location=0) uniform int action;

const vec3 c = vec3(0.299,0.587,0.114);

#define AGamma(VEC,colour) pow ( colour, VEC(256.0/563.0) )

void main ( void )
{
  ivec2 xy;
  vec3  pix, rpix;
  float lp, rp;

  xy = ivec2 ( gl_GlobalInvocationID.xy );
  switch ( action ) {
case ACCBUF_AVERAGE:
    pix = vec3 ( 0.0 );
    for ( int i = 0; i < NLAYERS; i++ )
      pix += imageLoad ( img, ivec3 ( xy, i ) ).rgb;
    imageStore ( accb, xy,
                 vec4 ( AGamma ( vec3, pix/float(NLAYERS) ), 1.0 ) );
    break;
case ACCBUF_ANAGLYPH:
    pix = rpix = vec3 ( 0.0 );
    for ( int i = 0; i < NLAYERS/2; i++ ) {
      pix += imageLoad ( img, ivec3 ( xy, i ) ).rgb;
      rpix += imageLoad ( img, ivec3 ( xy, i + NLAYERS/2 ) ).rgb;
    }
    lp = dot ( pix, c )/(0.5*float(NLAYERS));
    rp = dot ( rpix, c )/(0.5*float(NLAYERS));
    imageStore ( accb, xy,
                 vec4 ( AGamma ( vec2, vec2 ( rp, lp ) ), 0.0, 1.0 ) );
    break;
default:
    return;
  }
} /*main*/

