#version 450 core

#define ACCBUF_NONE     0
#define ACCBUF_CLEAR    1
#define ACCBUF_ADD      2
#define ACCBUF_MULT     3
#define ACCBUF_MULT_ADD 4
#define ACCBUF_GAMMA    5

layout (local_size_x=1) in;
layout (rgba32f,binding=0) uniform image2D accb;
layout (rgba32f,binding=1) uniform image2D img;
uniform int   action;
uniform float fct;

#define AGamma(colour) pow ( colour, vec3(256.0/563.0) )

void main ( void )
{
  ivec2 xy;
  vec4  pix;

  xy = ivec2 ( gl_GlobalInvocationID.xy );
  switch ( action ) {
case ACCBUF_CLEAR:
    pix = vec4 ( 0.0, 0.0, 0.0, 0.0 );
    break;
case ACCBUF_ADD:
    pix = imageLoad ( accb, xy ) + imageLoad ( img, xy );
    break;
case ACCBUF_MULT:
    pix = fct * imageLoad ( accb, xy );
    break;
case ACCBUF_MULT_ADD:
    pix = imageLoad ( accb, xy ) + fct * imageLoad ( img, xy );
    break;
case ACCBUF_GAMMA:
    pix = vec4 ( AGamma ( imageLoad ( accb, xy ).rgb ), 1.0 );
    break;
default:
    return;
  }
  imageStore ( accb, xy, pix );
} /*main*/

