
#define SHADOW_MAP_SIZE 1024

#define MAX_NLIGHTS   8
#define MAX_MATERIALS 10

typedef struct LSPar {
          GLfloat position[4];
          GLfloat ambient[3];
          GLfloat direct[3];
          GLfloat attenuation[3];
          GLuint  shadow_fbo, shadow_txt[2];
          GLfloat shadow_view[16], shadow_proj[16];
        } LSPar;

typedef struct LightBl {
          GLuint lsbuf;
          GLuint nls, mask, shmask;
          LSPar  ls[MAX_NLIGHTS];
        } LightBl;

typedef struct Material {
          GLfloat emission0[4], emission1[4];
          GLfloat diffref[4];
          GLfloat specref[4];
          GLfloat shininess, wa, we;
        } Material;

typedef struct MatBl {
          GLuint matbuf;
          int    nmat;
          Material mat[MAX_MATERIALS];
        } MatBl;

void GetAccessToLightMatUniformBlocks ( GLuint program_id );
void AttachUniformLightBlockToBP ( GLuint program_id );
GLuint NewUniformLightBlock ( void );

void SetLightAmbient ( LightBl *light, int l, GLfloat amb[3] );
void SetLightDirect ( LightBl *light, int l, GLfloat dir[3] );
void SetLightPosition ( LightBl *light, int l, GLfloat pos[4] );
void SetLightAttenuation ( LightBl *light, int l, GLfloat at3[3] );
void SetLightOnOff ( LightBl *light, int l, char on );

void ConstructShadowTxtFBO ( LightBl *light, int l );
void UpdateShadowMatrix ( LightBl *light, int l );
void SetupShadowTxtTransformations ( LightBl *light, int l, float sc[3], float R );
void BindShadowTxtFBO ( TransBl *trans, LightBl *light, int l );
void DeleteShadowFBO ( LightBl *light );
void SetShadowsOnOff ( LightBl *light, char on );

GLuint NewUniformMatBlock ( void );
int SetupMaterial ( MatBl *matbl, int m, const GLfloat diffr[3],
                    const GLfloat specr[3], GLfloat shn, GLfloat wa, GLfloat we );
void SetMaterialEmission ( MatBl *matbl, int m, const GLfloat em0[4],
                           const GLfloat em1[4] );
void ChooseMaterial ( MatBl *matbl, GLint m );


