
#define MIN_TESS_LEVEL  3
#define MAX_TESS_LEVEL 32

#define ANGULAR_VELOCITY1 (0.25*PI)

#define MIRRORTXT_W 1024
#define MIRRORTXT_H 1024

#define PARTICLE_COUNT 1048576

typedef struct Camera {
    int    win_width, win_height;
    float  left, right, bottom, top, near, far, rl, tb;
    float  viewer_pos0[4];
    float  viewer_rvec[3];
    double viewer_rangle;
  } Camera;

typedef struct Mirror {
    GLuint  mirror_fbo, mirror_txt[2];
    GLuint  mirror_vao, mirror_vbo;
    GLfloat mirror_matrix[16];
  } Mirror;

typedef struct {
    GLuint program_id[3];
    GLint  ColourSourceLoc, colour_source,
           LightingModelLoc, lighting_model,
           NormalSourceLoc, normal_source,
           ModifyDepthLoc, modify_depth;
  } BPRenderPrograms;

typedef struct {
    GLuint program_id;
    GLuint dim_loc, trnum_loc;
    GLuint cpibp, cpobp, ctrbp, ctribp;
  } KLArticulationProgram;

typedef struct {
    BezierPatchObjf *bpatches[2];
    GLuint          texture, tribuf;
    GLint           ntr, mtn;
  } KLBezPatches;

typedef struct {
    GLuint  vao, sbo[3], ubo;
    double  time0, last_time;
    GLint   tablength, iter;
    GLfloat dt, Tpart, vel, TC, acc, divv, divp;
    GLfloat pos0[3], pos1[3], vel0[3], vel1[3], conv[3];
  } PartSystem;

typedef struct {
    GLuint program_id[2];
    GLint  psofs[14], pcloc, psbsize;
    GLuint psbp, rvpbp, posbp, velbp;
  } PartSysPrograms;

typedef struct {
    Camera                camera;
    kl_linkage            *linkage;
    KLBezPatches          bezp[2];
    PartSystem            ps;
    Mirror                mirror;
    TransBl               trans;
    LightBl               light;
    MatBl                 mat;
    GLuint                lktrbuf;
    GLint                 BezNormals, TessLevel;
    char                  cnet, skeleton, shadows, particles,
                          animate, hold, final;
    double                hold_time, hold_time0;
    double                teapot_rot_angle;
    BPRenderPrograms      brprog;
    GLuint                miprog[2];
    KLArticulationProgram artprog;
    PartSysPrograms       psprog;
  } AppData;


void LoadLinkageArticulationProgram ( KLArticulationProgram *prog );
void DeleteLinkageArticulationProgram ( KLArticulationProgram *prog );
kl_linkage *ConstructMyLinkage ( AppData *ad );
void ArticulateMyLinkage ( kl_linkage *lk );
void DrawMyLinkage ( AppData *ad, char final );

void LoadMirrorShaders ( GLuint program_id[2] );
void ConstructMirror ( Mirror *mirror );
void SetupMirrorVPMatrices ( GLfloat eyepos[4], GLfloat reyepos[4],
                             GLfloat mvm[16], GLfloat mpm[16] );
void DrawMirror ( Mirror *mirror, GLuint program_id, char final );
void DeleteMirror ( Mirror *mirror );

void LoadParticleShaders ( PartSysPrograms *psprog );
void InitParticleSystem ( PartSysPrograms *psprog, PartSystem *ps );
void MoveParticles ( PartSysPrograms *psprog, PartSystem *ps, double time );
void DrawParticles ( PartSysPrograms *psprog, PartSystem *ps,
                     Camera *camera, char final );
void ResetParticles ( PartSysPrograms *psprog, PartSystem *ps, double time );
void DeleteParticleSystem ( PartSystem *ps );
void DeleteParticleShaders ( PartSysPrograms *psprog );

