#version 430 core

layout (local_size_x=1) in;

layout (binding=0) buffer RandomVecPool { vec4 rv[]; } rvpool;
layout (binding=1) buffer PartPos { vec4 pos[]; } pos;
layout (binding=2) buffer PartVel { vec3 vel[]; } vel;

uniform PartSys {
    int   tablength, iter;
    float dt, Tpart, vel, TC, acc, divv, divp;
    vec3  pos0, pos1, vel0, vel1, conv;
  } ps;

const float xx = 1.5, ymin = -1.2, ymax = 1.2, zmin = -1.0, zmax = 1.0, d = 0.2;

void main ( void )
{
  vec3  v0, v, p, u, t;
  float w0, w1, a, e;
  int   k;

  k = int ( gl_GlobalInvocationID.x );
  p = pos.pos[k].xyz;
  w0 = pos.pos[k].w;
  w1 = w0 + ps.dt/ps.Tpart;
  if ( w1 > 1.0 )
    { w0 -= 1.0;  w1 -= 1.0; }
  if ( w0 < 0.0 && w1 >= 0.0 ) {
    a = -w0/ps.dt;
    v = ps.vel*mix ( ps.vel0, ps.vel1, a ) +
        ps.divv*rvpool.rv[(k+1) % ps.tablength].xyz;
    p = mix ( ps.pos0, ps.pos1, a ) + ps.divp*rvpool.rv[k].xyz;
  }
  else {
    v0 = vel.vel[k];
    v = ps.conv + exp ( -ps.dt/ps.TC ) * (v0 - ps.conv) +
             ps.dt*ps.acc*rvpool.rv[(ps.iter+k) % ps.tablength].xyz;
    if ( abs ( a = p.x - xx ) < d &&
         p.y >= ymin && p.y <= ymax && p.z >= zmin && p.z <= zmax ) {
      if ( a > 0.0 != v.x > 0.0 ) {
        a = abs ( a ) / d;
        v.x *= pow ( a, 0.1 );
        v.y /= pow ( a, 0.05 );
      }
    }
    p.xyz += 0.5*ps.dt*(v0+v);
  }
  vel.vel[k] = v;
  pos.pos[k] = vec4 ( p, w1 );
} /*main*/

